/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import oracle.eclipse.tools.cloud.AuthenticationException;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.dev.CloudProject;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.DevServiceDesc;
import oracle.eclipse.tools.cloud.profile.ConnectionState;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.profile.JavaServiceDesc;
import oracle.eclipse.tools.cloud.profile.OPCPortalServiceClient;
import oracle.eclipse.tools.cloud.profile.ServiceDesc;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.wst.server.core.IServer;

public final class CloudServices
extends RemoteData<List<Object>> {
    private CloudConnection connection;

    CloudServices(CloudConnection connection) {
        super("services", new Serializer());
        this.connection = connection;
    }

    public CloudConnection connection() {
        return this.connection;
    }

    public ServiceDesc getServiceDesc(IServer server) {
        OracleCloudRuntime crt = (OracleCloudRuntime)((Object)server.getRuntime().getAdapter(OracleCloudRuntime.class));
        if (crt != null) {
            String profileId = (String)crt.getConfig().getProfileId().content();
            String jcsName = (String)crt.getConfig().getService().content();
            if (((String)this.connection().profile().getId().content()).equals(profileId)) {
                for (Object service : (List)this.content()) {
                    JavaServiceDesc sd;
                    if (!(service instanceof JavaServiceDesc) || !(sd = (JavaServiceDesc)service).getName().equals(jcsName)) continue;
                    return sd;
                }
            }
        }
        return null;
    }

    @Override
    protected List<Object> read() throws Exception {
        ConnectionState state = (ConnectionState)((Object)this.connection.profile().getConnectionState().content());
        if (state == ConnectionState.AUTHETICATION_ERROR || state == ConnectionState.ACCOUNT_LOCKED) {
            throw new AuthenticationException("authentication error", null);
        }
        try {
            List<ServiceDesc> ret = new OPCPortalServiceClient(this.connection).getServices((IProgressMonitor)new NullProgressMonitor());
            return this.read(ret);
        }
        catch (AuthenticationException ae) {
            if (OracleCloudTools.isDebugMode() && OracleCloudTools.isDevCloudDebugMode()) {
                ICloudProfile profile = this.connection.profile();
                ListFactory servicesListFactory = ListFactory.start();
                DevServiceDesc devService = DevCloudCore.createInternalDevServiceDesc(this.connection, profile);
                List<CloudProject> ret = DevCloudCore.getCloudProjects(devService);
                if (ret != null && ret.size() > 0) {
                    servicesListFactory.add((Object)devService);
                }
                if (servicesListFactory.size() > 0) {
                    return servicesListFactory.result();
                }
            }
            if (ae.getMessage().equals("Your account is locked. ")) {
                this.connection.profile().setConnectionState(ConnectionState.ACCOUNT_LOCKED);
            } else {
                this.connection.profile().setConnectionState(ConnectionState.AUTHETICATION_ERROR);
            }
            throw ae;
        }
    }

    private List<Object> read(List<ServiceDesc> services) throws Exception {
        ICloudProfile profile = this.connection.profile();
        ListFactory servicesListFactory = ListFactory.start();
        for (ServiceDesc sd : services) {
            if (sd.getType() != ServiceDesc.TYPE.JCS) continue;
            servicesListFactory.add((Object)sd);
        }
        if (OracleCloudTools.isDebugMode()) {
            boolean foundDcsInCloudPortal = false;
            for (ServiceDesc sd : services) {
                if (sd.getType() != ServiceDesc.TYPE.DCS) continue;
                servicesListFactory.add((Object)sd);
                foundDcsInCloudPortal = true;
            }
            if (OracleCloudTools.isDevCloudDebugMode() && !foundDcsInCloudPortal) {
                DevServiceDesc dcs = DevCloudCore.createInternalDevServiceDesc(this.connection, profile);
                servicesListFactory.add((Object)dcs);
            }
        }
        for (ServiceDesc sd : services) {
            if (sd.getType() != ServiceDesc.TYPE.DB) continue;
            servicesListFactory.add((Object)sd);
        }
        return servicesListFactory.result();
    }

    private static final class Serializer
    extends RemoteData.Serializer<List<Object>> {
        private Serializer() {
        }

        @Override
        public String id() {
            return ((CloudServices)this.context()).connection().name();
        }

        @Override
        public List<Object> read(InputStream stream) throws Exception {
            CloudServices context = (CloudServices)this.context();
            CloudConnection connection = context.connection();
            ObjectInputStream st = new ObjectInputStream(stream);
            ListFactory servicesListFactory = ListFactory.start();
            int size = st.readInt();
            int i = 0;
            while (i < size) {
                String name = st.readUTF();
                ServiceDesc.TYPE type = ServiceDesc.TYPE.valueOf(st.readUTF());
                String url = st.readUTF();
                ServiceDesc sd = type == ServiceDesc.TYPE.JCS ? new JavaServiceDesc(connection, name, url) : (type == ServiceDesc.TYPE.DCS ? new DevServiceDesc(connection, name, url, connection.profile()) : new ServiceDesc(connection, name, type, url));
                servicesListFactory.add((Object)sd);
                ++i;
            }
            return context.read(servicesListFactory.result());
        }

        @Override
        public void write(List<Object> data, OutputStream stream) throws Exception {
            ObjectOutputStream st = new ObjectOutputStream(stream);
            st.writeInt(data.size());
            for (Object service : data) {
                if (!(service instanceof ServiceDesc)) continue;
                ServiceDesc sd = (ServiceDesc)service;
                st.writeUTF(sd.getName());
                st.writeUTF(sd.getType().name());
                st.writeUTF(sd.getUrl());
            }
            st.flush();
        }
    }
}

