/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.server.internal.INuviaqDeployer;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudServerBehaviour;
import oracle.eclipse.tools.cloud.server.modules.CloudJavaEEModule;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.DeletedModule;

public final class CloudModules
extends RemoteData<List<Object>> {
    private final OracleCloudRuntime runtime;

    public CloudModules(OracleCloudRuntime runtime) {
        super("published modules");
        this.runtime = runtime;
    }

    @Override
    protected List<Object> read() throws Exception {
        ListFactory list = ListFactory.start();
        INuviaqDeployer deployer = this.runtime.getNuviaqDeployer();
        Map<String, String> modules = deployer.listApplications();
        IServer server = this.server();
        HashSet<String> modulesOnServer = new HashSet<String>();
        IModule[] iModuleArray = server.getModules();
        int n = iModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModule m = iModuleArray[n2];
            if (!(m instanceof DeletedModule)) {
                modulesOnServer.add(m.getName());
            }
            ++n2;
        }
        for (Map.Entry<String, String> entry : modules.entrySet()) {
            String name = entry.getKey();
            if (modulesOnServer.contains(name)) continue;
            CloudJavaEEModule m = new CloudJavaEEModule(name, entry.getValue(), server);
            list.add((Object)m);
        }
        return list.result();
    }

    public OracleCloudServerBehaviour getOracleCloudServerBehaviour() {
        return (OracleCloudServerBehaviour)((Object)this.server().loadAdapter(OracleCloudServerBehaviour.class, null));
    }

    public IServer server() {
        return this.runtime.server();
    }
}

