/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class ApacheHttpClient {
    private DefaultHttpClient httpClient = this.wrapClient((HttpClient)new DefaultHttpClient());
    private Proxy proxy = null;
    private String userName;
    private String passwd;
    private String proxyUserName = null;
    private String proxyPassword = null;
    private static final int HTTP_PORT = 80;
    private static final int HTTPS_PORT = 443;
    private static final int CONNECTION_TIMEOUT = 30000;
    private int timeout = 30000;

    public ApacheHttpClient(String userName, String passwd) {
        this.userName = userName;
        this.passwd = passwd;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public ApacheHttpClient(String userName, String passwd, Proxy proxy) {
        this(userName, passwd);
        this.proxy = proxy;
        this.configProxy();
    }

    public ApacheHttpClient(String userName, String passwd, Proxy proxy, String proxyUser, String proxyPasswd) {
        this(userName, passwd, proxy);
        this.proxyUserName = proxyUser;
        this.proxyPassword = proxyPasswd;
        this.configProxy();
    }

    private void configureAuthentication(String url) {
        if (this.userName != null && this.passwd != null) {
            String host = ApacheHttpClient.getHost(url);
            int port = ApacheHttpClient.getPort(url);
            this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(this.userName, this.passwd));
        }
        if (this.proxyUserName != null && this.proxyPassword != null) {
            InetSocketAddress address = (InetSocketAddress)this.proxy.address();
            String proxyHost = address.getHostName();
            int proxyPort = address.getPort();
            this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new UsernamePasswordCredentials(this.userName, this.passwd));
        }
    }

    private void configProxy() {
        if (this.proxy != null) {
            if (this.proxy.type() == Proxy.Type.DIRECT) {
                return;
            }
            InetSocketAddress address = (InetSocketAddress)this.proxy.address();
            HttpHost httProxy = new HttpHost(address.getHostName(), address.getPort());
            this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)httProxy);
        }
    }

    public static String getHost(String repositoryUrl) {
        String result = repositoryUrl;
        int colonSlashSlash = repositoryUrl.indexOf("://");
        if (colonSlashSlash >= 0) {
            result = repositoryUrl.substring(colonSlashSlash + 3);
        }
        int colonPort = result.indexOf(58);
        int requestPath = result.indexOf(47);
        int substringEnd = colonPort > 0 && requestPath > 0 ? Math.min(colonPort, requestPath) : (colonPort > 0 ? colonPort : (requestPath > 0 ? requestPath : result.length()));
        return result.substring(0, substringEnd);
    }

    private static boolean isRepositoryHttps(String repositoryUrl) {
        return repositoryUrl.matches("https.*");
    }

    public static int getPort(String repositoryUrl) {
        int colonSlashSlash = repositoryUrl.indexOf("://");
        int firstSlash = repositoryUrl.indexOf("/", colonSlashSlash + 3);
        int colonPort = repositoryUrl.indexOf(58, colonSlashSlash + 1);
        if (firstSlash == -1) {
            firstSlash = repositoryUrl.length();
        }
        if (colonPort < 0 || colonPort > firstSlash) {
            return ApacheHttpClient.isRepositoryHttps(repositoryUrl) ? 443 : 80;
        }
        int requestPath = repositoryUrl.indexOf(47, colonPort + 1);
        int end = requestPath < 0 ? repositoryUrl.length() : requestPath;
        String port = repositoryUrl.substring(colonPort + 1, end);
        if (port.length() == 0) {
            return ApacheHttpClient.isRepositoryHttps(repositoryUrl) ? 443 : 80;
        }
        return Integer.parseInt(port);
    }

    public ResponseData doGet(String url) {
        ResponseData resp;
        block3: {
            resp = new ResponseData();
            try {
                int statusCode;
                this.configureAuthentication(url);
                HttpGet request = new HttpGet(url);
                HttpResponse response = this.execute((HttpUriRequest)request, resp);
                resp.statusCode = statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    return resp;
                }
                resp.bodyText = this.readHttpEntityContent(response.getEntity());
            }
            catch (Exception e) {
                resp.exception = e;
                if (!OracleCloudTools.isDebugMode()) break block3;
                CloudPlugin.log(e);
            }
        }
        return resp;
    }

    public void printCookies(HttpResponse response) {
        if (!OracleCloudTools.isDebugCloudPortal()) {
            return;
        }
        System.err.println("================================================");
        Header[] headerArray = response.getAllHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header h = headerArray[n2];
            System.out.println(String.valueOf(h.getName()) + " = " + h.getValue());
            ++n2;
        }
        System.err.println("================================================");
    }

    public void setRedirect() {
        this.httpClient.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

            public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) {
                int responseCode;
                boolean isRedirect = false;
                try {
                    isRedirect = super.isRedirected(request, response, context);
                }
                catch (ProtocolException e) {
                    e.printStackTrace();
                }
                if (!(isRedirect || (responseCode = response.getStatusLine().getStatusCode()) != 301 && responseCode != 302)) {
                    return true;
                }
                return isRedirect;
            }
        });
    }

    private String readHttpEntityContent(HttpEntity entity) throws IOException {
        StringBuilder buf = new StringBuilder();
        InputStream stream = entity.getContent();
        try {
            String line;
            BufferedReader rd = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            while ((line = rd.readLine()) != null) {
                buf.append(String.valueOf(line) + "\n");
            }
        }
        catch (Throwable throwable) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
        return buf.toString();
    }

    public ResponseData doPost(String url, Map<String, String> params) {
        ResponseData resp;
        block4: {
            resp = new ResponseData();
            try {
                int statusCode;
                this.configureAuthentication(url);
                HttpPost post = new HttpPost(url);
                ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    nameValuePairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
                HttpResponse response = this.execute((HttpUriRequest)post, resp);
                resp.statusCode = statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    return resp;
                }
                resp.bodyText = this.readHttpEntityContent(response.getEntity());
            }
            catch (Exception e) {
                resp.exception = e;
                if (!OracleCloudTools.isDebugMode()) break block4;
                CloudPlugin.log(e);
            }
        }
        return resp;
    }

    public ResponseData doPost(String url, String body, String mimeType) {
        ResponseData resp;
        block3: {
            resp = new ResponseData();
            try {
                int statusCode;
                this.configureAuthentication(url);
                HttpPost post = new HttpPost(url);
                post.addHeader("content-type", mimeType);
                post.setEntity((HttpEntity)new StringEntity(body, mimeType, "ISO-8859-1"));
                HttpResponse response = this.execute((HttpUriRequest)post, resp);
                resp.statusCode = statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    return resp;
                }
                resp.bodyText = this.readHttpEntityContent(response.getEntity());
            }
            catch (Exception e) {
                resp.exception = e;
                if (!OracleCloudTools.isDebugMode()) break block3;
                CloudPlugin.log(e);
            }
        }
        return resp;
    }

    private HttpResponse execute(HttpUriRequest request, ResponseData resp) throws ClientProtocolException, IOException {
        BasicHttpContext context = new BasicHttpContext();
        HttpResponse response = this.httpClient.execute(request, (HttpContext)context);
        if (OracleCloudTools.isDebugCloudPortal()) {
            Header[] headerArray = response.getAllHeaders();
            int n = headerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Header h = headerArray[n2];
                System.out.println(String.valueOf(h.getName()) + " = " + h.getValue());
                ++n2;
            }
            this.printCookies(response);
        }
        HttpUriRequest currentReq = (HttpUriRequest)context.getAttribute("http.request");
        HttpHost currentHost = (HttpHost)context.getAttribute("http.target_host");
        if (OracleCloudTools.isDebugCloudPortal()) {
            String currentUrl = currentReq.getURI().isAbsolute() ? currentReq.getURI().toString() : String.valueOf(currentHost.toURI()) + currentReq.getURI();
            System.out.println("Redirected to URL : " + currentUrl);
        }
        resp.redirectedHost = currentReq.getURI().isAbsolute() ? currentReq.getURI().getHost() : currentHost.toURI();
        return response;
    }

    public DefaultHttpClient wrapClient(HttpClient base) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            X509HostnameVerifier verifier = new X509HostnameVerifier(){

                public void verify(String string, SSLSocket ssls) throws IOException {
                }

                public void verify(String string, X509Certificate xc) throws SSLException {
                }

                public void verify(String string, String[] strings, String[] strings1) throws SSLException {
                }

                public boolean verify(String string, SSLSession ssls) {
                    return true;
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx);
            ssf.setHostnameVerifier(verifier);
            ClientConnectionManager ccm = base.getConnectionManager();
            SchemeRegistry sr = ccm.getSchemeRegistry();
            sr.register(new Scheme("https", (SocketFactory)ssf, 443));
            HttpParams httpParameters = base.getParams();
            int timeoutConnection = this.timeout;
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParameters, (int)timeoutConnection);
            int timeoutSocket = this.timeout;
            HttpConnectionParams.setSoTimeout((HttpParams)httpParameters, (int)timeoutSocket);
            return new DefaultHttpClient(ccm, httpParameters);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static class ResponseData {
        public int statusCode = -1;
        public String bodyText = null;
        public String redirectedHost = null;
        public Exception exception = null;

        public String getExceptionMessage() {
            return this.exception != null ? this.exception.toString() : "";
        }
    }
}

