/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.util;

import java.util.HashMap;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackage;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackageBody;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackageObject;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.DBHelper;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.emf.ecore.EObject;

public class DSEUtil {
    public static Database findDatabaseByChild(Object child) {
        if (child instanceof org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo) {
            return ((org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo)child).getSharedDatabase();
        }
        if (child instanceof SQLObject) {
            return DSEUtil.getDatabase((EObject)((SQLObject)child));
        }
        if (child instanceof IVirtualNode && ((IVirtualNode)child).getParent() instanceof SQLObject) {
            return DSEUtil.findDatabaseByChild((SQLObject)((IVirtualNode)child).getParent());
        }
        return null;
    }

    public static IConnectionProfile getConnectionProfile(Database database) {
        ConnectionInfo connInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(database);
        IConnectionProfile connectionProfile = null;
        if (connInfo instanceof ConnectionInfoImpl) {
            connectionProfile = ((ConnectionInfoImpl)connInfo).getConnectionProfile();
        }
        return connectionProfile;
    }

    public static ProcIdentifier getProcIdentifier(SQLObject sqlObj) {
        ProcIdentifier procId = null;
        Database database = DSEUtil.findDatabaseByChild(sqlObj);
        if (database == null) {
            return null;
        }
        IConnectionProfile connectionProfile = DSEUtil.getConnectionProfile(database);
        if (connectionProfile == null) {
            return null;
        }
        DatabaseIdentifier dbId = new DatabaseIdentifier(connectionProfile.getName(), database.getName());
        SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByProfileName((String)connectionProfile.getName());
        if (config == null) {
            return null;
        }
        DBHelper h = config.getDBHelper();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("NAME", sqlObj.getName());
        if (sqlObj instanceof OraclePackageObject) {
            OraclePackageObject packObj = (OraclePackageObject)sqlObj;
            map.put("OWNER", packObj.getSchema().getName());
            map.put("PACKAGE", packObj.getPackageName());
            map.put("PACKAGE TYPE", packObj.getType());
            map.put("OVERLOAD ORDER", Integer.toString(packObj.getOrder()));
            int type = 0;
            if (packObj.isFunction()) {
                type = 1;
            }
            procId = h.getProcIdentifier(dbId, type, map);
        } else if (sqlObj instanceof OraclePackage) {
            OraclePackage oraPack = (OraclePackage)sqlObj;
            map.put("OWNER", oraPack.getSchema().getName());
            map.put("PACKAGE", oraPack.getName());
            map.put("PACKAGE TYPE", oraPack.getOracleType());
            procId = h.getProcIdentifier(dbId, 4, map);
        } else if (sqlObj instanceof OraclePackageBody) {
            OraclePackageBody packBody = (OraclePackageBody)sqlObj;
            map.put("OWNER", packBody.getOraclePackage().getSchema().getName());
            map.put("PACKAGE", packBody.getOraclePackage().getName());
            map.put("PACKAGE TYPE", packBody.getOracleType());
            procId = h.getProcIdentifier(dbId, 4, map);
        }
        return procId;
    }

    private static Database getDatabase(EObject obj) {
        EObject container = obj;
        while (container != null) {
            obj = container;
            if (obj instanceof Database) {
                return (Database)obj;
            }
            container = ContainmentServiceImpl.INSTANCE.getContainer(obj);
        }
        return null;
    }
}

