/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.sqltools.plan;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import oracle.eclipse.tools.database.ui.sqltools.SqlToolsUiMessages;
import oracle.eclipse.tools.database.ui.sqltools.plan.ExplainPlanExec;
import oracle.eclipse.tools.database.ui.sqltools.plan.ExplainPlanRow;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.sqltools.plan.IExecutionPlanDocument;
import org.eclipse.datatools.sqltools.plan.IPlanParser;
import org.eclipse.datatools.sqltools.plan.treeplan.TreeExecutionPlanDocument;
import org.eclipse.datatools.sqltools.plan.treeplan.TreePlanNodeComponent;
import org.eclipse.datatools.sqltools.plan.treeplan.TreePlanNodeComposite;

public class ExplainPlanParser
implements IPlanParser {
    public IExecutionPlanDocument[] parsePlan(String rawPlan) {
        TreePlanNodeComponent[] nodes = new TreePlanNodeComponent[ExplainPlanExec.result.size()];
        int i = 0;
        while (i < ExplainPlanExec.result.size()) {
            ExplainPlanRow row = (ExplainPlanRow)ExplainPlanExec.result.get(i);
            String total = row.COST != null ? row.COST.toString() : "";
            String cpu = row.CPU_COST != null ? ((BigDecimal)row.CPU_COST).movePointLeft(2).toEngineeringString() : "";
            String io = row.IO_COST != null ? ((BigDecimal)row.IO_COST).movePointLeft(2).toEngineeringString() : "";
            TreePlanNodeComposite node = new TreePlanNodeComposite(row.OPERATION, String.valueOf(row.OPERATION) + "(" + row.OPTIONS + ")", row.getXML(), row, String.valueOf(SqlToolsUiMessages.ExplainPlanParser_cost) + total, false, String.valueOf(SqlToolsUiMessages.ExplainPlanParser_io) + io + " " + SqlToolsUiMessages.ExplainPlanParser_cpu + cpu, false, null){

                public String getDetail() {
                    String html = "<TABLE>";
                    ExplainPlanRow row = (ExplainPlanRow)this.getData();
                    Field[] fs = ExplainPlanRow.class.getDeclaredFields();
                    int j = 0;
                    while (j < fs.length) {
                        try {
                            html = String.valueOf(html) + "<TR><TD bgcolor=\"#ccccff\" align=\"right\" valign=\"top\">" + fs[j].getName() + "</TD>";
                            Object o = fs[j].get(row);
                            if (o != null) {
                                html = String.valueOf(html) + "<TD align=\"left\" valign=\"top\">" + o + "</TD></TR>";
                            }
                        }
                        catch (Exception e) {
                            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
                        }
                        ++j;
                    }
                    return String.valueOf(html) + "</TABLE>";
                }
            };
            nodes[row.ID.intValue()] = node;
            if (row.PARENT_ID != null) {
                TreePlanNodeComposite parent = (TreePlanNodeComposite)nodes[row.PARENT_ID.intValue()];
                parent.addChild((TreePlanNodeComponent)node);
            }
            ++i;
        }
        TreeExecutionPlanDocument doc = new TreeExecutionPlanDocument((TreePlanNodeComponent)((TreePlanNodeComposite)nodes[0]), "Explain Plan", (Object)ExplainPlanExec.result);
        return new TreeExecutionPlanDocument[]{doc};
    }
}

