/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.sqltools.plan;

import java.lang.reflect.Field;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import oracle.eclipse.tools.database.ui.sqltools.SqlToolsUiMessages;
import oracle.eclipse.tools.database.ui.sqltools.plan.ExplainPlanRow;
import org.eclipse.core.runtime.Plugin;

public class ExplainPlanExec {
    public static final int TEXT_MODE = 0;
    public static final int GRAPHIC_MODE = 1;
    private static String XPLAN_TABLE = "PLAN_TABLE";
    private static String XPLAN_CLEAR_STMT = "DELETE FROM " + XPLAN_TABLE;
    private static String XPLAN_EXEC_STMT = "EXPLAIN PLAN FOR ";
    private static String XPLAN_TEXT_RESULT_STMT = "SELECT * FROM table(DBMS_XPLAN.DISPLAY('" + XPLAN_TABLE + "', null, 'typical'))";
    private static String XPLAN_GRAPHIC_RESULT_STMT = "SELECT statement_id,plan_id,timestamp,remarks,operation,options,object_node,object_owner,object_name,object_alias,object_instance,object_type,optimizer,search_columns,id,parent_id,depth,position,cost,bytes,other_tag,partition_start,partition_stop,partition_id,other,other_xml,distribution,cpu_cost,io_cost,temp_space,access_predicates,filter_predicates,projection,time,qblock_name,cardinality \"ROWS\" FROM " + XPLAN_TABLE + " ORDER BY id";
    static ArrayList result = null;

    public static String doExplainPlan(Connection con, String sql, int mode) throws SQLException {
        Statement cs1 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        ResultSet rs3 = null;
        try {
            cs1 = con.createStatement();
            rs1 = cs1.executeQuery(XPLAN_CLEAR_STMT);
            String _sql = sql.trim();
            _sql = _sql.endsWith(";") ? _sql.substring(0, _sql.length() - 1) : _sql;
            rs3 = cs1.executeQuery(String.valueOf(XPLAN_EXEC_STMT) + _sql);
            if (mode == 0) {
                rs2 = cs1.executeQuery(XPLAN_TEXT_RESULT_STMT);
                ResultSetMetaData rsmd2 = rs2.getMetaData();
                String result = "";
                while (rs2.next()) {
                    int i = 1;
                    while (i <= rsmd2.getColumnCount()) {
                        Object o = rs2.getObject(i);
                        result = String.valueOf(result) + o.toString() + "\n";
                        ++i;
                    }
                }
                String string = result;
                return string;
            }
            result = new ArrayList(){

                private String toColumnedText() {
                    ExplainPlanRow row;
                    String txt = String.valueOf(SqlToolsUiMessages.ExplainPlanExec_rows) + "\t\t" + SqlToolsUiMessages.ExplainPlanExec_operation + "\n";
                    txt = String.valueOf(txt) + "-------\t\t---------------\n";
                    int max = 0;
                    int i = 0;
                    while (i < this.size()) {
                        row = (ExplainPlanRow)this.get(i);
                        Number num = row.ROWS;
                        if (num != null && num.toString().length() > max) {
                            max = row.ROWS.toString().length();
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < this.size()) {
                        row = (ExplainPlanRow)this.get(i);
                        txt = String.valueOf(txt) + row.ROWS;
                        if (row.DEPTH != null) {
                            int k = 0;
                            while (k < max + row.DEPTH.intValue()) {
                                txt = String.valueOf(txt) + "  ";
                                ++k;
                            }
                        }
                        txt = String.valueOf(txt) + row.OPERATION + "\n";
                        ++i;
                    }
                    return txt;
                }

                @Override
                public String toString() {
                    return this.toColumnedText();
                }
            };
            rs2 = cs1.executeQuery(XPLAN_GRAPHIC_RESULT_STMT);
            ResultSetMetaData rsmd2 = rs2.getMetaData();
            while (rs2.next()) {
                ExplainPlanRow row = new ExplainPlanRow();
                int i = 1;
                while (i <= rsmd2.getColumnCount()) {
                    Object o = rs2.getObject(i);
                    String column = rsmd2.getColumnName(i);
                    try {
                        if (o != null) {
                            Field f = ExplainPlanRow.class.getDeclaredField(column);
                            if (o instanceof Clob) {
                                Clob clob = (Clob)o;
                                f.set(row, clob.getSubString(1L, (int)clob.length()));
                            } else {
                                f.set(row, o);
                            }
                        }
                    }
                    catch (Exception e) {
                        LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
                    }
                    ++i;
                }
                result.add(row);
            }
            String string = result.toString();
            return string;
        }
        finally {
            if (rs1 != null) {
                rs1.close();
            }
            if (rs2 != null) {
                rs2.close();
            }
            if (rs3 != null) {
                rs3.close();
            }
            if (cs1 != null) {
                cs1.close();
            }
        }
    }
}

