/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.explorer.providers;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.database.connectivity.catalog.OracleComposedType;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDatabase;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDatabaseLink;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDirectory;
import oracle.eclipse.tools.database.connectivity.catalog.OracleFunction;
import oracle.eclipse.tools.database.connectivity.catalog.OracleIndex;
import oracle.eclipse.tools.database.connectivity.catalog.OracleMaterializedView;
import oracle.eclipse.tools.database.connectivity.catalog.OracleOtherUser;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackage;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackageObject;
import oracle.eclipse.tools.database.connectivity.catalog.OracleProcedure;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePublicSynonym;
import oracle.eclipse.tools.database.connectivity.catalog.OracleRecycleBinObject;
import oracle.eclipse.tools.database.connectivity.catalog.OracleSchema;
import oracle.eclipse.tools.database.connectivity.catalog.OracleSequence;
import oracle.eclipse.tools.database.connectivity.catalog.OracleSynonym;
import oracle.eclipse.tools.database.connectivity.catalog.OracleTable;
import oracle.eclipse.tools.database.connectivity.catalog.OracleTrigger;
import oracle.eclipse.tools.database.connectivity.catalog.OracleView;
import oracle.eclipse.tools.database.modelbase.db.OraPackage;
import oracle.eclipse.tools.database.modelbase.db.OraSchema;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.explorer.virtual.DatabaseLinkFolder;
import oracle.eclipse.tools.database.ui.explorer.virtual.DirectoryFolder;
import oracle.eclipse.tools.database.ui.explorer.virtual.MaterializedViewFolder;
import oracle.eclipse.tools.database.ui.explorer.virtual.OracleColumnNode;
import oracle.eclipse.tools.database.ui.explorer.virtual.OracleConstraintNode;
import oracle.eclipse.tools.database.ui.explorer.virtual.OracleIndexNode;
import oracle.eclipse.tools.database.ui.explorer.virtual.OracleSchemaNode;
import oracle.eclipse.tools.database.ui.explorer.virtual.OracleSequenceNode;
import oracle.eclipse.tools.database.ui.explorer.virtual.OracleStoredProcedureNode;
import oracle.eclipse.tools.database.ui.explorer.virtual.OracleTableNode;
import oracle.eclipse.tools.database.ui.explorer.virtual.OracleTriggerNode;
import oracle.eclipse.tools.database.ui.explorer.virtual.OracleUDFNode;
import oracle.eclipse.tools.database.ui.explorer.virtual.OracleUDTNode;
import oracle.eclipse.tools.database.ui.explorer.virtual.OracleViewNode;
import oracle.eclipse.tools.database.ui.explorer.virtual.OtherUsersFolder;
import oracle.eclipse.tools.database.ui.explorer.virtual.PackageBodyFolder;
import oracle.eclipse.tools.database.ui.explorer.virtual.PackageFolder;
import oracle.eclipse.tools.database.ui.explorer.virtual.PublicSynonymFolder;
import oracle.eclipse.tools.database.ui.explorer.virtual.RecycleBinFolder;
import oracle.eclipse.tools.database.ui.explorer.virtual.SynonymFolder;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionFilter;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObjectListener;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.providers.content.virtual.VirtualNode;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.loading.ILoadingService;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServicesManager;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class OracleDSEContentProvider
implements ICommonContentProvider,
ICatalogObjectListener,
ILoadingService {
    private CommonViewer viewer;
    private static final Object[] EMPTY_ELEMENT_ARRAY = new Object[0];
    private RecycleBinFolder recycleBinFolder;

    public Object[] load(Object parentElement) {
        if (parentElement instanceof OracleDatabase) {
            OracleSchemaNode schemaNode = new OracleSchemaNode(DBToolsUiMessages.SCHEMA_NODE, DBToolsUiMessages.SCHEMA_NODE, parentElement);
            return new Object[]{schemaNode};
        }
        if (parentElement instanceof OraSchema) {
            assert (parentElement instanceof OracleSchema);
            return this.getSchemaChildren((OracleSchema)parentElement);
        }
        if (parentElement instanceof MaterializedViewFolder) {
            Schema owningSchema = (Schema)((IVirtualNode)parentElement).getParent();
            EList matViews = ((OracleSchema)owningSchema).getMaterializedViews();
            ConnectionInfo ci = this.getConnectionInfo(owningSchema);
            String filterName = ((MaterializedViewFolder)((Object)parentElement)).getFilterName();
            org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter cf = ci.getFilter(filterName);
            return this.getFilteredObjects((ConnectionFilter)cf, (List)matViews).toArray();
        }
        if (parentElement instanceof RecycleBinFolder) {
            Schema owningSchema = (Schema)((IVirtualNode)parentElement).getParent();
            return ((OracleSchema)owningSchema).getRecycleBin().toArray();
        }
        if (parentElement instanceof DatabaseLinkFolder) {
            Schema owningSchema = (Schema)((IVirtualNode)parentElement).getParent();
            EList links = ((OracleSchema)owningSchema).getDatabaseLinks();
            ConnectionInfo ci = this.getConnectionInfo(owningSchema);
            String filterName = ((DatabaseLinkFolder)((Object)parentElement)).getFilterName();
            org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter cf = ci.getFilter(filterName);
            return this.getFilteredObjects((ConnectionFilter)cf, (List)links).toArray();
        }
        if (parentElement instanceof PackageFolder) {
            Schema owningSchema = (Schema)((IVirtualNode)parentElement).getParent();
            EList packs = ((OracleSchema)owningSchema).getPackages();
            ConnectionInfo ci = this.getConnectionInfo(owningSchema);
            String filterName = ((PackageFolder)((Object)parentElement)).getFilterName();
            org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter cf = ci.getFilter(filterName);
            return this.getFilteredObjects((ConnectionFilter)cf, (List)packs).toArray();
        }
        if (parentElement instanceof OraPackage) {
            OraPackage owningPackage = (OraPackage)parentElement;
            Object[] specModules = owningPackage.getSpecification().getDeclarations().toArray();
            if (((OraclePackage)owningPackage).hasPackageBody()) {
                Object[] all = new Object[specModules.length + 1];
                all[0] = new PackageBodyFolder(DBToolsUiMessages.PACKAGES_BODY_FOLDER, DBToolsUiMessages.PACKAGES_BODY_FOLDER, parentElement);
                System.arraycopy(specModules, 0, all, 1, specModules.length);
                return all;
            }
            return specModules;
        }
        if (parentElement instanceof PackageBodyFolder) {
            OraPackage owningPackage = (OraPackage)((IVirtualNode)parentElement).getParent();
            return owningPackage.getBody().getDeclarations().toArray();
        }
        if (parentElement instanceof SynonymFolder) {
            Schema owningSchema = (Schema)((IVirtualNode)parentElement).getParent();
            EList syns = ((OracleSchema)owningSchema).getSynonyms();
            ConnectionInfo ci = this.getConnectionInfo(owningSchema);
            String filterName = ((SynonymFolder)((Object)parentElement)).getFilterName();
            org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter cf = ci.getFilter(filterName);
            return this.getFilteredObjects((ConnectionFilter)cf, (List)syns).toArray();
        }
        if (parentElement instanceof PublicSynonymFolder) {
            Schema owningSchema = (Schema)((IVirtualNode)parentElement).getParent();
            EList psyns = ((OracleSchema)owningSchema).getPublicSynonyms();
            ConnectionInfo ci = this.getConnectionInfo(owningSchema);
            String filterName = ((PublicSynonymFolder)((Object)parentElement)).getFilterName();
            org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter cf = ci.getFilter(filterName);
            return this.getFilteredObjects((ConnectionFilter)cf, (List)psyns).toArray();
        }
        if (parentElement instanceof OtherUsersFolder) {
            Schema owningSchema = (Schema)((IVirtualNode)parentElement).getParent();
            return ((OracleSchema)owningSchema).getOtherUsers().toArray();
        }
        if (parentElement instanceof DirectoryFolder) {
            Schema owningSchema = (Schema)((IVirtualNode)parentElement).getParent();
            EList dirs = ((OracleSchema)owningSchema).getDirectories();
            ConnectionInfo ci = this.getConnectionInfo(owningSchema);
            String filterName = ((DirectoryFolder)((Object)parentElement)).getFilterName();
            org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter cf = ci.getFilter(filterName);
            return this.getFilteredObjects((ConnectionFilter)cf, (List)dirs).toArray();
        }
        if (parentElement instanceof OracleTableNode) {
            String filterName;
            Schema owningSchema = (Schema)((IVirtualNode)parentElement).getParent();
            EList tables = ((OracleSchema)owningSchema).getTables();
            ArrayList pureTables = new ArrayList();
            for (Object obj : tables) {
                if (!(obj instanceof OracleTable)) continue;
                pureTables.add(obj);
            }
            ConnectionInfo ci = this.getConnectionInfo(owningSchema);
            org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter cf = ci.getFilter(filterName = ((OracleTableNode)((Object)parentElement)).getFilterName());
            if (cf == null) {
                cf = ci.getFilter("DatatoolsTableFilterPredicate");
            }
            return this.getFilteredObjects((ConnectionFilter)cf, pureTables).toArray();
        }
        if (parentElement instanceof OracleViewNode) {
            Schema owningSchema = (Schema)((IVirtualNode)parentElement).getParent();
            EList tables = ((OracleSchema)owningSchema).getTables();
            ArrayList views = new ArrayList();
            for (Object obj : tables) {
                if (!(obj instanceof OracleView)) continue;
                views.add(obj);
            }
            ConnectionInfo ci = this.getConnectionInfo(owningSchema);
            String filterName = ((OracleViewNode)((Object)parentElement)).getFilterName();
            org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter cf = ci.getFilter(filterName);
            return this.getFilteredObjects((ConnectionFilter)cf, views).toArray();
        }
        if (parentElement instanceof OracleStoredProcedureNode) {
            Schema owningSchema = (Schema)((IVirtualNode)parentElement).getParent();
            EList routines = ((OracleSchema)owningSchema).getRoutines();
            ArrayList iroutines = new ArrayList();
            Object filterName = routines.iterator();
            while (filterName.hasNext()) {
                Object obj = filterName.next();
                if (!(obj instanceof OracleProcedure) || !((OracleProcedure)obj).getOracleType().equals("PROCEDURE")) continue;
                iroutines.add(obj);
            }
            ConnectionInfo ci = this.getConnectionInfo(owningSchema);
            org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter cf = ci.getFilter((String)(filterName = ((OracleStoredProcedureNode)((Object)parentElement)).getFilterName()));
            if (cf == null) {
                cf = ci.getFilter("DatatoolsSPFilterPredicate");
            }
            return this.getFilteredObjects((ConnectionFilter)cf, iroutines).toArray();
        }
        if (parentElement instanceof OracleUDFNode) {
            Schema owningSchema = (Schema)((IVirtualNode)parentElement).getParent();
            EList functions = ((OracleSchema)owningSchema).getUDFs();
            ArrayList ifunctions = new ArrayList();
            for (Object obj : functions) {
                if (!(obj instanceof OracleFunction) || !((OracleFunction)obj).getOracleType().equals("FUNCTION")) continue;
                ifunctions.add(obj);
            }
            ConnectionInfo ci = this.getConnectionInfo(owningSchema);
            String filterName = ((OracleUDFNode)((Object)parentElement)).getFilterName();
            org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter cf = ci.getFilter(filterName);
            return this.getFilteredObjects((ConnectionFilter)cf, ifunctions).toArray();
        }
        if (parentElement instanceof OracleSequenceNode) {
            Schema owningSchema = (Schema)((IVirtualNode)parentElement).getParent();
            EList sequences = ((OracleSchema)owningSchema).getSequences();
            ConnectionInfo ci = this.getConnectionInfo(owningSchema);
            String filterName = ((OracleSequenceNode)((Object)parentElement)).getFilterName();
            org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter cf = ci.getFilter(filterName);
            return this.getFilteredObjects((ConnectionFilter)cf, (List)sequences).toArray();
        }
        if (parentElement instanceof OracleUDTNode) {
            Schema owningSchema = (Schema)((IVirtualNode)parentElement).getParent();
            EList udts = ((OracleSchema)owningSchema).getUserDefinedTypes();
            ConnectionInfo ci = this.getConnectionInfo(owningSchema);
            String filterName = ((OracleUDTNode)((Object)parentElement)).getFilterName();
            org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter cf = ci.getFilter(filterName);
            return this.getFilteredObjects((ConnectionFilter)cf, (List)udts).toArray();
        }
        if (parentElement instanceof OracleOtherUser) {
            return this.getSchemaChildren((OracleSchema)parentElement);
        }
        if (parentElement instanceof OracleTable) {
            return this.getTableChildren(parentElement);
        }
        if (parentElement instanceof OracleColumnNode) {
            return this.getColumnNodeChildren(parentElement);
        }
        if (parentElement instanceof OracleTriggerNode) {
            return this.getTriggerNodeChildren(parentElement);
        }
        if (parentElement instanceof OracleIndexNode) {
            return this.getIndexNodeChildren(parentElement);
        }
        if (parentElement instanceof OracleConstraintNode) {
            return this.getConstraintNodeChildren(parentElement);
        }
        if (parentElement instanceof OracleView || parentElement instanceof OracleMaterializedView) {
            return this.getViewNodeChildren(parentElement);
        }
        return EMPTY_ELEMENT_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof IVirtualNode) {
            return ((IVirtualNode)element).getParent();
        }
        if (element instanceof OracleRecycleBinObject) {
            return this.recycleBinFolder;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return !(element instanceof OraclePackageObject) && !(element instanceof OracleIndex) && !(element instanceof OracleTrigger) && !(element instanceof Column) && !(element instanceof Constraint) && !(element instanceof OracleProcedure) && !(element instanceof OracleFunction) && !(element instanceof OracleComposedType) && !(element instanceof OracleSequence) && !(element instanceof OracleSynonym) && !(element instanceof OraclePublicSynonym) && !(element instanceof OracleDatabaseLink) && !(element instanceof OracleDirectory) && !(element instanceof OracleRecycleBinObject);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof CommonViewer && this.viewer == null) {
            this.viewer = (CommonViewer)viewer;
        }
    }

    public Object[] getChildren(Object parent) {
        return new ILoadingService.Loading().getChildren((AbstractTreeViewer)this.viewer, parent, (ILoadingService)this);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void notifyChanged(ICatalogObject dmElement, int eventType) {
        if (eventType == 0 && dmElement instanceof OracleDatabase) {
            IServicesManager.INSTANCE.getServerExplorerContentService().refreshNode((Object)dmElement);
        }
    }

    public void dispose() {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getLoadingDescription() {
        return DBToolsUiMessages.OracleDSEContentProvider_serviceDesc;
    }

    private Object[] getSchemaChildren(OracleSchema parentElement) {
        ArrayList<VirtualNode> objLst = new ArrayList<VirtualNode>();
        objLst.add(new PackageFolder(DBToolsUiMessages.PACKAGES_FOLDER, DBToolsUiMessages.PACKAGES_FOLDER, parentElement));
        objLst.add(new SynonymFolder(DBToolsUiMessages.SYNONYMS_FOLDER, DBToolsUiMessages.SYNONYMS_FOLDER, parentElement));
        objLst.add(new PublicSynonymFolder(DBToolsUiMessages.PUBLIC_SYNONYMS_FOLDER, DBToolsUiMessages.PUBLIC_SYNONYMS_FOLDER, parentElement));
        objLst.add(new MaterializedViewFolder(DBToolsUiMessages.MATERIALIZED_VIEW_FOLDER, DBToolsUiMessages.MATERIALIZED_VIEW_FOLDER, parentElement));
        objLst.add(new DatabaseLinkFolder(DBToolsUiMessages.DATABASE_LINKS_FOLDER, DBToolsUiMessages.DATABASE_LINKS_FOLDER, parentElement));
        objLst.add(new DirectoryFolder(DBToolsUiMessages.DIRECTORIES_FOLDER, DBToolsUiMessages.DIRECTORIES_FOLDER, parentElement));
        this.recycleBinFolder = new RecycleBinFolder(DBToolsUiMessages.RECYCLE_BIN_FOLDER, DBToolsUiMessages.RECYCLE_BIN_FOLDER, parentElement);
        objLst.add(this.recycleBinFolder);
        objLst.add(new OracleTableNode(DBToolsUiMessages.TABLE_FOLDER, DBToolsUiMessages.TABLE_FOLDER, parentElement));
        objLst.add(new OracleViewNode(DBToolsUiMessages.VIEW_FOLDER, DBToolsUiMessages.VIEW_FOLDER, parentElement));
        objLst.add(new OracleStoredProcedureNode(DBToolsUiMessages.STORED_PROCEDURE_FOLDER, DBToolsUiMessages.STORED_PROCEDURE_FOLDER, parentElement));
        objLst.add(new OracleUDFNode(DBToolsUiMessages.FUNCTION_FOLDER, DBToolsUiMessages.FUNCTION_FOLDER, parentElement));
        objLst.add(new OracleSequenceNode(DBToolsUiMessages.SEQUENCE_FOLDER, DBToolsUiMessages.SEQUENCE_FOLDER, parentElement));
        objLst.add(new OracleUDTNode(DBToolsUiMessages.TYPE_FOLDER, DBToolsUiMessages.TYPE_FOLDER, parentElement));
        if (!(parentElement instanceof OracleOtherUser)) {
            objLst.add(new OtherUsersFolder(DBToolsUiMessages.OTHER_USERS_FOLDER, DBToolsUiMessages.OTHER_USERS_FOLDER, parentElement));
        }
        return objLst.toArray();
    }

    private ConnectionInfo getConnectionInfo(Schema schema) {
        Database db = schema.getDatabase();
        return DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(db);
    }

    private List getFilteredObjects(ConnectionFilter filter, List oldList) {
        if (filter == null) {
            return oldList;
        }
        ArrayList<SQLObject> result = new ArrayList<SQLObject>();
        for (SQLObject sqlObj : oldList) {
            String name = sqlObj.getName();
            if (filter.isFiltered(name)) continue;
            result.add(sqlObj);
        }
        return result;
    }

    private Object[] getTableChildren(Object parent) {
        ArrayList<Object> collection = new ArrayList<Object>(4);
        collection.add((Object)new OracleColumnNode(DBToolsUiMessages.COLUMN_FOLDER, DBToolsUiMessages.COLUMN_FOLDER, parent));
        collection.add((Object)new OracleTriggerNode(DBToolsUiMessages.TRIGGER_FOLDER, DBToolsUiMessages.TRIGGER_FOLDER, parent));
        collection.add((Object)new OracleIndexNode(DBToolsUiMessages.INDEX_FOLDER, DBToolsUiMessages.INDEX_FOLDER, parent));
        collection.add((Object)new OracleConstraintNode(DBToolsUiMessages.CONSTRAINT_FOLDER, DBToolsUiMessages.CONSTRAINT_FOLDER, parent));
        return collection.toArray();
    }

    private Object[] getViewNodeChildren(Object parent) {
        ArrayList<Object> collection = new ArrayList<Object>(2);
        collection.add((Object)new OracleColumnNode(DBToolsUiMessages.COLUMN_FOLDER, DBToolsUiMessages.COLUMN_FOLDER, parent));
        collection.add((Object)new OracleTriggerNode(DBToolsUiMessages.TRIGGER_FOLDER, DBToolsUiMessages.TRIGGER_FOLDER, parent));
        return collection.toArray();
    }

    private Object[] getColumnNodeChildren(Object parent) {
        Table table = (Table)((IVirtualNode)parent).getParent();
        return table.getColumns().toArray();
    }

    private Object[] getTriggerNodeChildren(Object parent) {
        Table table = (Table)((IVirtualNode)parent).getParent();
        return table.getTriggers().toArray();
    }

    private Object[] getIndexNodeChildren(Object parent) {
        BaseTable table = (BaseTable)((IVirtualNode)parent).getParent();
        return table.getIndex().toArray();
    }

    protected Object[] getConstraintNodeChildren(Object parent) {
        BaseTable table = (BaseTable)((IVirtualNode)parent).getParent();
        return table.getConstraints().toArray();
    }
}

