/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.editors.table;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.connectivity.actions.OracleObject;
import oracle.eclipse.tools.database.connectivity.catalog.OracleTable;
import oracle.eclipse.tools.database.connectivity.editors.IPartEditContext;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import oracle.eclipse.tools.database.ui.editors.SQLObjectComposite;
import oracle.eclipse.tools.database.ui.editors.table.OracleTableDataEditor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class TableComposite
extends SQLObjectComposite {
    private OracleTableDataEditor dataEditor;
    private PreparedStatement constraintStmt;
    private static final String constraintQuery = "SELECT * FROM all_constraints WHERE  OWNER = ? AND TABLE_NAME= ? ";

    public TableComposite(IPartEditContext context, Composite parent, int style) {
        super(context, parent, style);
        try {
            TabFolder tabFolder = (TabFolder)this.getParent();
            this.addColumns(tabFolder);
            this.addData(tabFolder);
            this.addIndexes(tabFolder);
            this.addConstraints(tabFolder);
            this.addObjectGrantsTab(DBToolsUiMessages.Composite_grantsTab);
            this.addObjectDetailTab(DBToolsUiMessages.Composite_detailTab);
            this.addSqlTab();
            this.selectTabItem(tabFolder.getItem(0));
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
        }
    }

    @Override
    protected ResultSet getPartData(String partName) throws SQLException {
        String schemaName;
        DatabaseMetaData dbmd;
        block14: {
            block13: {
                dbmd = this.context.getDatabaseObject().getConnection().getMetaData();
                schemaName = this.getSchema(dbmd);
                if (partName.equalsIgnoreCase("Row Identifiers")) {
                    return dbmd.getBestRowIdentifier(null, schemaName, this.context.getDatabaseObject().getName(), 1, true);
                }
                if (partName.equalsIgnoreCase("Table Privileges")) {
                    return dbmd.getTablePrivileges(null, schemaName, this.context.getDatabaseObject().getName());
                }
                if (!partName.equalsIgnoreCase("Indexes")) break block13;
                OracleObject oo = this.context.getDatabaseObject().getOracleObject();
                Connection con = this.context.getDatabaseObject().getConnection();
                if (oo instanceof OracleTable) {
                    return OracleTable.getTableIndexResultSet((Connection)con, (Table)((OracleTable)oo));
                }
                return null;
            }
            if (partName.equalsIgnoreCase("Outward References")) {
                return dbmd.getImportedKeys(null, this.getSchema(dbmd), this.context.getDatabaseObject().getName());
            }
            if (partName.equalsIgnoreCase("Inward References")) {
                return dbmd.getExportedKeys(null, schemaName, this.context.getDatabaseObject().getName());
            }
            if (!partName.equalsIgnoreCase("Data")) break block14;
            return null;
        }
        try {
            if (partName.equalsIgnoreCase("Constraints")) {
                Connection con = this.context.getDatabaseObject().getConnection();
                this.constraintStmt = con.prepareStatement(constraintQuery);
                this.constraintStmt.setString(1, schemaName.toUpperCase());
                this.constraintStmt.setString(2, this.context.getDatabaseObject().getName().toUpperCase());
                return this.constraintStmt.executeQuery();
            }
            if (partName.equalsIgnoreCase("Columns")) {
                return dbmd.getColumns(null, schemaName, this.context.getDatabaseObject().getName(), "%");
            }
            if (partName.equalsIgnoreCase("Column Privileges")) {
                return dbmd.getColumnPrivileges(null, schemaName, this.context.getDatabaseObject().getName(), "%");
            }
            throw new RuntimeException(String.valueOf(DBToolsUiMessages.TableComposite_noData) + " " + partName);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
            return null;
        }
    }

    private String getSchema(DatabaseMetaData dbmd) throws SQLException {
        OracleObject obj = this.context.getDatabaseObject().getOracleObject();
        if (obj instanceof OracleTable) {
            OracleTable sqlTable = (OracleTable)obj;
            Database db = sqlTable.getSchema().getCatalog() != null ? sqlTable.getSchema().getCatalog().getDatabase() : sqlTable.getSchema().getDatabase();
            RDBCorePlugin plugin = RDBCorePlugin.getDefault();
            DatabaseDefinition dbDefinition = plugin.getDatabaseDefinitionRegistry().getDefinition(db);
            if (dbDefinition.supportsSchema()) {
                return sqlTable.getSchema().getName();
            }
        }
        return dbmd.getUserName();
    }

    private void addRowIdentifiers(TabFolder tab) {
        this.add("Row Identifiers", DBToolsUiMessages.TableComposite_rowIdTab);
    }

    private void addPrivileges(TabFolder tab) {
        this.add("Table Privileges", DBToolsUiMessages.TableComposite_tablePrivilegesTab);
    }

    private void addIndexes(TabFolder tab) {
        this.add("Indexes", DBToolsUiMessages.TableComposite_indexTab);
    }

    private void addImportedKeys(TabFolder tab) {
        this.add("Outward References", DBToolsUiMessages.TableComposite_outwardReferenceTab);
    }

    private void addExportedKeys(TabFolder tab) {
        this.add("Inward References", DBToolsUiMessages.TableComposite_inwardReferenceTab);
    }

    private void addData(TabFolder tab) throws SQLException {
        this.dataEditor = new OracleTableDataEditor(tab, "Data", DBToolsUiMessages.TableComposite_dataTab, this.context);
        this.dataEditor.create();
    }

    private void addConstraints(TabFolder tab) {
        this.add("Constraints", DBToolsUiMessages.TableComposite_constraintTab);
    }

    private void addColumns(TabFolder tab) {
        this.add("Columns", DBToolsUiMessages.TableComposite_columnTab);
    }

    private void addColumnPrivileges(TabFolder tab) {
        this.add("Column Privileges", DBToolsUiMessages.TableComposite_columnPrivTab);
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        this.dataEditor.doSave(monitor);
    }

    @Override
    public void dispose() {
        this.dataEditor.dispose();
        super.dispose();
        try {
            if (this.constraintStmt != null) {
                this.constraintStmt.close();
            }
        }
        catch (SQLException se) {
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)se);
        }
    }

    @Override
    protected void selectTabItem(TabItem tabItem) {
        String partName = (String)tabItem.getData("PART_NAME");
        if (partName != null && partName.equals("Data")) {
            Runnable longJob = new Runnable(){

                @Override
                public void run() {
                    TableComposite.this.dataEditor.loadData();
                }
            };
            BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)longJob);
        } else {
            super.selectTabItem(tabItem);
        }
    }
}

