/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.editors.table;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.sqltools.data.internal.core.common.IColumnDataAccessor;
import org.eclipse.datatools.sqltools.data.internal.core.editor.IRowData;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class OracleTableDataLabelProvider
implements ITableLabelProvider {
    protected static final int MAX_LABEL_LENGTH = Integer.MAX_VALUE;

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        assert (element != null);
        IRowData row = (IRowData)element;
        try {
            Object o = row.getValue(columnIndex);
            IColumnDataAccessor acc = row.getTable().getColumnDataAccessor(columnIndex);
            int type = row.getTable().getColumnType(columnIndex);
            String s = acc.getLabel(o, type);
            if (s == null) {
                return DBToolsUiMessages.TableDataLabelProvider_null;
            }
            boolean truncated = acc.isSnippet(o, type);
            if (s.length() > Integer.MAX_VALUE) {
                s = s.substring(0, Integer.MAX_VALUE);
                truncated = true;
            }
            if (truncated) {
                s = String.valueOf(s) + "...";
            }
            return s;
        }
        catch (Exception ex) {
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)ex);
            return DBToolsUiMessages.TableDataCellModifier_error;
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

