/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.editors.table;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.connectivity.db.DatabaseObject;
import oracle.eclipse.tools.database.connectivity.editors.IPartEditContext;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import oracle.eclipse.tools.database.ui.editors.ObjectEditor;
import oracle.eclipse.tools.database.ui.editors.table.OracleTableData;
import oracle.eclipse.tools.database.ui.editors.table.OracleTableDataCellModifier;
import oracle.eclipse.tools.database.ui.editors.table.OracleTableDataContentProvider;
import oracle.eclipse.tools.database.ui.editors.table.OracleTableDataLabelProvider;
import oracle.eclipse.tools.database.ui.editors.table.OracleTableDataTableCursor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.data.internal.core.DataCorePlugin;
import org.eclipse.datatools.sqltools.data.internal.core.common.Output;
import org.eclipse.datatools.sqltools.data.internal.core.editor.IRowData;
import org.eclipse.datatools.sqltools.data.internal.core.editor.ITableData;
import org.eclipse.datatools.sqltools.data.internal.ui.OutputItemAdapter;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.ResultsViewAPI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableColumn;

public class OracleTableDataEditor {
    private static final int INITIALMAXROWS = 1000;
    private TabFolder tabFolder;
    private TabItem tabItem;
    private TableViewer tableViewer;
    private IPartEditContext context = null;
    private DatabaseObject dbObject;
    private Table sqlTable;
    protected OracleTableDataTableCursor cursor;
    protected ITableData tableData;
    private String partName;
    private String partLabel;
    private boolean askConfirmation;
    private boolean dataLoaded = false;

    public OracleTableDataEditor(TabFolder tabFolder, String partName, String partLabel, IPartEditContext context) {
        this.tabFolder = tabFolder;
        this.partName = partName;
        this.partLabel = partLabel;
        this.context = context;
        this.dbObject = context.getDatabaseObject();
        this.sqlTable = (Table)this.dbObject.getOracleObject();
    }

    public void create() {
        this.tabItem = new TabItem(this.tabFolder, 0);
        this.tabItem.setText(this.partLabel);
        this.tabItem.setData("PART_NAME", (Object)this.partName);
    }

    public void setVisible() {
        this.loadData();
    }

    protected void loadData() {
        if (!this.dataLoaded) {
            org.eclipse.swt.widgets.Table table = new org.eclipse.swt.widgets.Table((Composite)this.tabFolder, 0x10008000);
            this.tableViewer = new TableViewer(table);
            this.tableViewer.getTable().setHeaderVisible(true);
            this.tableViewer.getTable().setLinesVisible(true);
            this.tableViewer.getTable().setLayoutData((Object)new GridData(1808));
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new OracleTableDataLabelProvider());
            OracleTableDataContentProvider contentProvider = new OracleTableDataContentProvider();
            this.tableViewer.setContentProvider((IContentProvider)contentProvider);
            contentProvider.setEditor(this);
            this.tabItem.setControl((Control)table);
            try {
                this.tableData = new OracleTableData(this.sqlTable);
                this.configureTable();
                int rowCount = ((OracleTableData)this.tableData).getSqlRowCount();
                if (rowCount > 1000) {
                    rowCount = 1000;
                }
                this.tableViewer.getTable().setItemCount(rowCount);
                this.tableViewer.setInput((Object)this.tableData);
            }
            catch (CoreException core) {
                String title = DBToolsUiMessages.TableDataEditor_ErrorInitializingEditor;
                ErrorDialog.openError((Shell)this.tableViewer.getControl().getShell(), (String)title, null, (IStatus)core.getStatus());
            }
            catch (Exception ex) {
                LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)ex);
            }
            this.cursor = new OracleTableDataTableCursor(this.tableViewer);
            if (this.tableViewer.getTable().getItemCount() > 0) {
                this.cursor.setSelection(0, 0);
            }
            this.createContextMenu();
            this.dataLoaded = true;
        }
    }

    protected void configureTable() {
        TextCellEditor textEditor = new TextCellEditor((Composite)this.tableViewer.getTable());
        CellEditor[] editors = new CellEditor[this.tableData.getColumnCount()];
        String[] properties = new String[this.tableData.getColumnCount()];
        int i = 0;
        while (i < this.tableData.getColumnCount()) {
            TableColumn col = new TableColumn(this.tableViewer.getTable(), 0);
            col.setWidth(100);
            col.setText(this.tableData.getColumnHeader(i));
            col.pack();
            editors[i] = textEditor;
            properties[i] = this.tableData.getColumnName(i);
            ++i;
        }
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setColumnProperties(properties);
        this.tableViewer.setCellModifier((ICellModifier)new OracleTableDataCellModifier(this, this.tableViewer));
    }

    public void dispose() {
        if (this.tableData != null) {
            this.tableData.dispose();
        }
    }

    protected void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                Action countRows = new Action(){

                    public void run() {
                        OracleTableDataEditor.this.doCountRows();
                    }
                };
                countRows.setText(DBToolsUiMessages.TableDataEditor_CountRows);
                mgr.add((IAction)countRows);
                Action deleteRow = new Action(){

                    public void run() {
                        OracleTableDataEditor.this.doDelete();
                    }

                    public boolean isEnabled() {
                        return !OracleTableDataEditor.this.isReadonly() && OracleTableDataEditor.this.getCursor().getRow() != null && OracleTableDataEditor.this.getCursor().getRow().getData() instanceof IRowData;
                    }
                };
                deleteRow.setText(DBToolsUiMessages.TableDataEditor_DeleteRow);
                mgr.add((IAction)deleteRow);
                Action updateValue = new Action(){

                    public void run() {
                        OracleTableDataEditor.this.doUpdateValue();
                    }

                    public boolean isEnabled() {
                        return !OracleTableDataEditor.this.isReadonly() && (this).OracleTableDataEditor.this.cursor.getRow() != null;
                    }
                };
                updateValue.setText(DBToolsUiMessages.TableDataEditor_EditValue);
                mgr.add((IAction)updateValue);
                Action insertRow = new Action(){

                    public void run() {
                        OracleTableDataEditor.this.doInsertRow();
                    }

                    public boolean isEnabled() {
                        return !OracleTableDataEditor.this.isReadonly();
                    }
                };
                insertRow.setText(DBToolsUiMessages.TableDataEditor_InsertRow);
                mgr.add((IAction)insertRow);
                Action saveAction = new Action(){

                    public void run() {
                        OracleTableDataEditor.this.doSave((IProgressMonitor)new NullProgressMonitor());
                    }

                    public boolean isEnabled() {
                        return ((ObjectEditor)OracleTableDataEditor.this.context.getEditor()).isDirty();
                    }
                };
                saveAction.setText(DBToolsUiMessages.TableDataEditor_Save);
                mgr.add((IAction)saveAction);
                Action revertAction = new Action(){

                    public void run() {
                        OracleTableDataEditor.this.doRevert();
                    }

                    public boolean isEnabled() {
                        return ((ObjectEditor)OracleTableDataEditor.this.context.getEditor()).isDirty();
                    }
                };
                revertAction.setText(DBToolsUiMessages.TableDataEditor_Revert);
                mgr.add((IAction)revertAction);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.tableViewer.getTable());
        this.tableViewer.getTable().setMenu(menu);
        this.cursor.setMenu(menu);
    }

    public void doCountRows() {
        int rowCount = ((OracleTableData)this.tableData).getSqlRowCount();
        String msg = String.format(DBToolsUiMessages.TableDataEditor_RowCountDlgMsg, rowCount, this.sqlTable.getName());
        MessageBox msgBox = new MessageBox(Display.getDefault().getActiveShell());
        msgBox.setMessage(msg);
        msgBox.setText(DBToolsUiMessages.TableDataEditor_RowCountDlgTitle);
        msgBox.open();
    }

    public void doDelete() {
        IRowData row = this.getRow();
        if (row != null) {
            int index = this.tableViewer.getTable().indexOf(this.cursor.getRow());
            this.tableData.deleteRow(row);
            int oldCount = this.tableViewer.getTable().getItemCount();
            this.tableViewer.getTable().setItemCount(oldCount - 1);
            this.tableViewer.refresh(true, false);
            int colIndex = this.cursor.getColumn();
            if (index + 1 < oldCount - 1) {
                this.cursor.setSelection(index + 1, colIndex);
                if (index < oldCount - 1) {
                    this.cursor.setSelection(index, colIndex);
                }
            } else if (index - 1 >= 0) {
                this.cursor.setSelection(index - 1, colIndex);
                if (index < oldCount - 1) {
                    this.cursor.setSelection(index, colIndex);
                }
            }
            this.cursor.redraw();
            this.setDirty(true);
            this.askConfirmation = true;
        }
    }

    public IRowData doInsertRow() {
        int oldCount = this.tableViewer.getTable().getItemCount();
        int insertIndex = 0;
        if (oldCount > 0) {
            insertIndex = this.tableViewer.getTable().indexOf(this.cursor.getRow()) + 1;
        }
        IRowData newRow = ((OracleTableData)this.tableData).insertRow(insertIndex);
        this.tableViewer.getTable().setItemCount(oldCount + 1);
        this.tableViewer.refresh(true, false);
        this.cursor.setSelection(insertIndex, this.cursor.getColumn());
        this.cursor.redraw();
        this.doUpdateValue();
        this.setDirty(true);
        return newRow;
    }

    public void doUpdateValue() {
        this.cursor.edit();
    }

    protected void doSave(IProgressMonitor monitor) {
        if (this.askConfirmation) {
            String msg = String.format(DBToolsUiMessages.TableDataEditor_RemoveRowsConfirmation_message, String.valueOf(this.sqlTable.getSchema().getName()) + "." + this.sqlTable.getName());
            boolean okay = MessageDialog.openQuestion((Shell)this.tableViewer.getControl().getShell(), (String)DBToolsUiMessages.TableDataEditor_RemoveRowsConfirmation_title, (String)msg);
            if (!okay) {
                return;
            }
        }
        OperationCommand item = this.initDbOutputItem();
        try {
            ResultsViewAPI resultsView = ResultsViewAPI.getInstance();
            resultsView.createNewInstance(item, null);
            resultsView.updateStatus(item, 1);
            int ret = this.tableData.save((Output)new OutputItemAdapter(item));
            resultsView.updateStatus(item, ret);
            if (ret == 3 || ret == 4) {
                this.setDirty(false);
                this.askConfirmation = false;
                this.tableViewer.refresh(true, false);
                this.cursor.redraw();
            } else {
                monitor.setCanceled(true);
            }
        }
        catch (Exception ex) {
            monitor.setCanceled(true);
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)ex);
        }
    }

    public void doRevert() {
        this.tableData.revert();
        int rowCount = ((OracleTableData)this.tableData).getSqlRowCount();
        if (rowCount > 1000) {
            rowCount = 1000;
        }
        this.tableViewer.getTable().setItemCount(rowCount);
        this.tableViewer.refresh(true, false);
        this.cursor.redraw();
        this.setDirty(false);
        this.askConfirmation = false;
    }

    protected void setDirty(boolean value) {
        ((ObjectEditor)this.context.getEditor()).setDirty(value);
    }

    public boolean isReadonly() {
        return this.tableData.isReadonly();
    }

    public ITableData getTableData() {
        return this.tableData;
    }

    public Table getSqlTable() {
        return this.sqlTable;
    }

    private IRowData getRow() {
        Object row = this.cursor.getRow().getData();
        if (row instanceof IRowData) {
            return (IRowData)row;
        }
        return null;
    }

    public OracleTableDataTableCursor getCursor() {
        return this.cursor;
    }

    public IRowData getOrCreateRow() {
        IRowData row = this.getRow();
        if (row == null) {
            IRowData newRow = this.tableData.insertRow();
            this.tableViewer.insert((Object)newRow, this.tableViewer.getTable().getItemCount() - 1);
            this.cursor.setSelection(this.tableViewer.getTable().getItemCount() - 2, this.cursor.getColumn());
            this.cursor.redraw();
            return newRow;
        }
        return row;
    }

    protected OperationCommand initDbOutputItem() {
        String qualifiedTableName = DataCorePlugin.getQualifiedTableName((Table)this.sqlTable);
        int actionType = 6;
        String displayStr = qualifiedTableName;
        String consumerName = null;
        Database database = this.sqlTable.getSchema().getCatalog() != null ? this.sqlTable.getSchema().getCatalog().getDatabase() : this.sqlTable.getSchema().getDatabase();
        ConnectionInfo connInfo = DatabaseConnectionRegistry.getConnectionForDatabase((Database)database);
        String connectionProfieName = ((ConnectionInfoImpl)connInfo).getConnectionProfile().getName();
        String databaseName = database.getName();
        OperationCommand oCommand = new OperationCommand(actionType, displayStr, consumerName, connectionProfieName, databaseName);
        return oCommand;
    }
}

