/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.editors.table;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import oracle.eclipse.tools.database.ui.editors.table.OracleRowData;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.data.internal.core.DataCorePlugin;
import org.eclipse.datatools.sqltools.data.internal.core.common.IColumnDataAccessor;
import org.eclipse.datatools.sqltools.data.internal.core.common.Output;
import org.eclipse.datatools.sqltools.data.internal.core.editor.IRowData;
import org.eclipse.datatools.sqltools.data.internal.core.editor.ITableData;
import org.eclipse.datatools.sqltools.data.internal.core.editor.TableDataSaveStatus;
import org.eclipse.emf.common.util.EList;

public class OracleTableData
implements ITableData {
    protected Table sqlTable;
    protected Connection con;
    protected int sqlRowCounts = -1;
    protected Vector<IRowData> rows = new Vector();
    protected String selectStmt;
    protected Statement stmt;
    protected ResultSet rs;
    protected ResultSetMetaData rsmd;
    protected int sqlCursorPos = -1;
    List<Integer> deletedRowIndices;
    protected int[] colTtypes;
    protected String[] colNames;
    protected String[] colTypeNames;
    IColumnDataAccessor[] colDataAccessor;
    protected int[] key = null;
    protected boolean readonly;
    protected List resultColumns;

    public OracleTableData(Table sqlTable) throws SQLException, IOException, Exception {
        this.sqlTable = sqlTable;
        this.con = ((ICatalogObject)sqlTable).getConnection();
        if (sqlTable instanceof BaseTable) {
            this.findKey((BaseTable)sqlTable);
            this.readonly = false;
        } else {
            this.readonly = true;
        }
        this.resultColumns = new ArrayList();
        this.stmt = this.con.createStatement();
        this.colDataAccessor = new IColumnDataAccessor[sqlTable.getColumns().size()];
        int i = 0;
        while (i < sqlTable.getColumns().size()) {
            Column sqlCol = (Column)sqlTable.getColumns().get(i);
            this.resultColumns.add(sqlCol);
            this.colDataAccessor[i] = DataCorePlugin.getDefault().newColumnDataAccessor(sqlCol);
            ++i;
        }
        this.selectStmt = this.computeSelectStatement();
        this.rs = this.stmt.executeQuery(this.selectStmt);
        this.rsmd = this.rs.getMetaData();
        int cc = this.rsmd.getColumnCount();
        this.colTtypes = new int[cc];
        this.colNames = new String[cc];
        this.colTypeNames = new String[cc];
        int i2 = 0;
        while (i2 < cc) {
            this.colTtypes[i2] = this.rsmd.getColumnType(i2 + 1);
            this.colNames[i2] = this.rsmd.getColumnName(i2 + 1);
            this.colTypeNames[i2] = this.rsmd.getColumnTypeName(i2 + 1);
            ++i2;
        }
        this.sqlCursorPos = -1;
        this.deletedRowIndices = new ArrayList<Integer>();
    }

    public void deleteRow(IRowData row) {
        if (((OracleRowData)row).getState() == 3) {
            this.rows.remove(row);
        } else {
            int index = this.rows.indexOf(row);
            ((OracleRowData)row).setState(2);
            this.deletedRowIndices.add(index);
        }
    }

    protected void findKey(BaseTable baseTable) {
        EList cols;
        EList constraints = baseTable.getConstraints();
        UniqueConstraint chosenConstr = null;
        for (TableConstraint constr : constraints) {
            if (!(constr instanceof UniqueConstraint)) continue;
            UniqueConstraint uniqueConstr = (UniqueConstraint)constr;
            if (chosenConstr != null && uniqueConstr.getMembers().size() >= chosenConstr.getMembers().size()) continue;
            chosenConstr = uniqueConstr;
        }
        if (chosenConstr == null) {
            cols = this.sqlTable.getColumns();
            this.key = new int[cols.size()];
            int i = 0;
            while (i < cols.size()) {
                this.key[i] = i;
                ++i;
            }
        } else {
            cols = chosenConstr.getMembers();
            this.key = new int[cols.size()];
            int i = 0;
            while (i < cols.size()) {
                Column col = (Column)cols.get(i);
                this.key[i] = col.getTable().getColumns().indexOf((Object)col);
                ++i;
            }
        }
    }

    public void dispose() {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
            if (this.stmt != null) {
                this.stmt.close();
            }
        }
        catch (SQLException ex) {
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)ex);
        }
    }

    public int getColumnCount() {
        return this.resultColumns.size();
    }

    public IColumnDataAccessor getColumnDataAccessor(int col) {
        return this.colDataAccessor[col];
    }

    public String getColumnHeader(int col) {
        Column sqlCol = (Column)this.resultColumns.get(col);
        return String.valueOf(sqlCol.getName()) + " [" + OracleTableData.getFormattedTypeName(sqlCol) + "]";
    }

    public String getColumnName(int col) {
        Column sqlCol = (Column)this.resultColumns.get(col);
        return sqlCol.getName();
    }

    public static String getFormattedTypeName(Column sqlCol) {
        Table table = sqlCol.getTable();
        Schema schema = table.getSchema();
        Database db = schema.getCatalog() != null ? schema.getCatalog().getDatabase() : schema.getDatabase();
        DatabaseDefinition dbDef = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(db);
        DataType dt = sqlCol.getDataType();
        if (dt != null) {
            if (dt instanceof PredefinedDataType) {
                return dbDef.getPredefinedDataTypeFormattedName((PredefinedDataType)dt);
            }
            if (dt instanceof UserDefinedType) {
                return DataCorePlugin.getQualifiedUDTName((UserDefinedType)((UserDefinedType)dt));
            }
            return dt.getName();
        }
        return "";
    }

    public int getColumnType(int col) {
        return this.colTtypes[col];
    }

    public Vector getRows() {
        return null;
    }

    public IRowData insertRow() {
        return null;
    }

    public IRowData insertRow(int viewerIndex) {
        int rowIndex = this.getRowIndex(viewerIndex);
        Object[] data = new Object[this.getColumnCount()];
        OracleRowData row = new OracleRowData(this, 3, data);
        if (rowIndex < this.rows.size() - this.deletedRowIndices.size()) {
            this.rows.add(rowIndex, (IRowData)row);
        } else {
            this.rows.add((IRowData)row);
        }
        return row;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void revert() {
        int i = 0;
        while (i < this.rows.size()) {
            OracleRowData row = (OracleRowData)this.rows.elementAt(i);
            if (row.getState() == 1 || row.getState() == 2) {
                row.revertToOriginal();
                ++i;
                continue;
            }
            if (row.getState() == 3) {
                this.rows.remove(i);
                continue;
            }
            if (row.getState() != 0) continue;
            ++i;
        }
        this.deletedRowIndices.clear();
    }

    public int save(Output output) throws SQLException {
        int res;
        boolean setAutoCommitAllowed = true;
        boolean autocomit = this.con.getAutoCommit();
        try {
            this.con.setAutoCommit(false);
            this.con.commit();
        }
        catch (SQLException sQLException) {
            setAutoCommitAllowed = false;
        }
        TableDataSaveStatus status = new TableDataSaveStatus();
        try {
            for (OracleRowData oracleRowData : this.rows) {
                oracleRowData.save(status, output);
            }
            if (setAutoCommitAllowed) {
                this.con.commit();
                this.con.setAutoCommit(autocomit);
            }
            res = status.duplicateRow ? 4 : 3;
        }
        catch (Exception ex) {
            output.write(ex.toString());
            if (setAutoCommitAllowed) {
                this.con.rollback();
                this.con.setAutoCommit(autocomit);
            }
            res = 6;
            status.reset();
        }
        if (res == 3 || res == 4) {
            this.resetRowsToOriginal();
        }
        this.writeOutput(output, res, status);
        return res;
    }

    protected String computeSelectStatement() {
        StringBuffer sb = new StringBuffer("SELECT");
        int i = 0;
        while (i < this.sqlTable.getColumns().size()) {
            if (i == 0) {
                sb.append(" ");
            } else {
                sb.append(", ");
            }
            sb.append(this.colDataAccessor[i].getSelectExpr());
            ++i;
        }
        sb.append(" FROM ");
        sb.append(this.getQualifiedTableName());
        return sb.toString();
    }

    public String getQualifiedTableName() {
        StringBuffer sb = new StringBuffer(50);
        Database db = this.sqlTable.getSchema().getCatalog() != null ? this.sqlTable.getSchema().getCatalog().getDatabase() : this.sqlTable.getSchema().getDatabase();
        RDBCorePlugin plugin = RDBCorePlugin.getDefault();
        DatabaseDefinition dbDefinition = plugin.getDatabaseDefinitionRegistry().getDefinition(db);
        if (dbDefinition.supportsSchema()) {
            sb.append(DataCorePlugin.quoteIdentifier((Connection)this.con, (String)this.sqlTable.getSchema().getName())).append(".");
        }
        sb.append(DataCorePlugin.quoteIdentifier((Connection)this.con, (String)this.sqlTable.getName()));
        return sb.toString();
    }

    public int[] getKeyColumns() {
        return this.key;
    }

    public Connection getConnection() {
        return this.con;
    }

    public Table getSQLTable() {
        return this.sqlTable;
    }

    public String getQuotedColumnName(int col) {
        Database db = this.sqlTable.getSchema().getDatabase() != null ? this.sqlTable.getSchema().getDatabase() : this.sqlTable.getSchema().getCatalog().getDatabase();
        return DataCorePlugin.quoteIdentifier((Database)db, (String)this.getColumnName(col));
    }

    public String getColumnTypeName(int col) {
        return this.colTypeNames[col];
    }

    public int getSqlRowCount() {
        if (this.sqlRowCounts == -1) {
            ResultSet rs = null;
            Statement statement = null;
            String sql = "SELECT COUNT(*) FROM " + this.getQualifiedTableName();
            try {
                try {
                    statement = this.con.createStatement();
                    rs = statement.executeQuery(sql);
                    rs.next();
                    this.sqlRowCounts = rs.getInt(1);
                }
                catch (Exception e) {
                    LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception e2) {
                        LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e2);
                    }
                }
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception e) {
                    LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
                }
            }
        }
        return this.sqlRowCounts;
    }

    public IRowData getRow(int viewerIndex) {
        OracleRowData row = null;
        int rowIndex = this.getRowIndex(viewerIndex);
        try {
            int cc = this.rsmd.getColumnCount();
            if (rowIndex > this.sqlCursorPos) {
                while (rowIndex > this.sqlCursorPos && this.rs.next()) {
                    ++this.sqlCursorPos;
                    Object[] a = new Object[cc];
                    int col = 0;
                    while (col < cc) {
                        a[col] = this.colDataAccessor[col].read(this.rs, col, this.colTtypes[col], true);
                        ++col;
                    }
                    row = new OracleRowData(this, 0, a);
                    this.rows.add((IRowData)row);
                }
            }
        }
        catch (Exception ex) {
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)ex);
        }
        if (viewerIndex < this.rows.size() - this.deletedRowIndices.size()) {
            return this.rows.get(rowIndex);
        }
        return null;
    }

    private int getRowIndex(int viewerIndex) {
        if (this.rows.size() - this.deletedRowIndices.size() < viewerIndex + 1) {
            return viewerIndex + this.deletedRowIndices.size();
        }
        int rowIndex = -1;
        int undeletedRows = 0;
        for (IRowData rowData : this.rows) {
            ++rowIndex;
            OracleRowData oracleRow = (OracleRowData)rowData;
            if (oracleRow.getState() == 2 || ++undeletedRows != viewerIndex + 1) continue;
            return rowIndex;
        }
        return -1;
    }

    protected void resetRowsToOriginal() {
        this.rows.clear();
        this.deletedRowIndices.clear();
        this.dispose();
        try {
            this.stmt = this.con.createStatement();
            this.rs = this.stmt.executeQuery(this.selectStmt);
            this.rsmd = this.rs.getMetaData();
        }
        catch (SQLException ex) {
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)ex);
        }
        this.sqlCursorPos = -1;
    }

    protected void writeOutput(Output output, int res, TableDataSaveStatus status) {
        String endl = System.getProperty("line.separator");
        if (res == 3 || res == 4) {
            output.write(DBToolsUiMessages.TableData_DataSuccessfullySaved);
        } else {
            output.write(DBToolsUiMessages.TableData_ErrorSavingData);
        }
        if (status.duplicateRow) {
            output.write(DBToolsUiMessages.TableData_DuplicateRows);
        }
        String msg = "";
        msg = String.valueOf(msg) + DBToolsUiMessages.TableData_Inserted + String.valueOf(status.inserted) + DBToolsUiMessages.TableData_rows + endl;
        msg = String.valueOf(msg) + DBToolsUiMessages.TableData_Updated + String.valueOf(status.updated) + DBToolsUiMessages.TableData_rows + endl;
        msg = String.valueOf(msg) + DBToolsUiMessages.TableData_Deleted + String.valueOf(status.deleted) + DBToolsUiMessages.TableData_rows;
        output.write(msg);
    }
}

