/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.editors;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.connectivity.editors.IPartEditContext;
import oracle.eclipse.tools.database.modelbase.db.OraPublicSynonym;
import oracle.eclipse.tools.database.modelbase.db.Synonym;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import oracle.eclipse.tools.database.ui.editors.SQLObjectComposite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;

public class SynonymComposite
extends SQLObjectComposite {
    private String synonymQuery = "select OWNER, SYNONYM_NAME, TABLE_OWNER, TABLE_NAME, DB_LINK from all_synonyms where OWNER = ? and SYNONYM_NAME = ?";
    private PreparedStatement stmt = null;

    public SynonymComposite(IPartEditContext context, Composite parent, int style) {
        super(context, parent, style);
        this.addDetails((TabFolder)this.getParent());
        this.addSqlTab();
        this.selectTabItem(this.tabFolder.getItem(0));
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
        }
        catch (SQLException se) {
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)se);
        }
    }

    @Override
    protected ResultSet getPartData(String partName) throws SQLException {
        Connection connection = this.context.getDatabaseObject().getConnection();
        Synonym synonym = (Synonym)this.context.getDatabaseObject().getOracleObject();
        this.stmt = connection.prepareCall(this.synonymQuery);
        if (synonym instanceof OraPublicSynonym) {
            this.stmt.setString(1, "PUBLIC");
        } else {
            this.stmt.setString(1, synonym.getSchema().getName());
        }
        this.stmt.setString(2, synonym.getName());
        ResultSet rset = this.stmt.executeQuery();
        return rset;
    }

    private void addDetails(TabFolder tab) {
        this.add("Details", DBToolsUiMessages.Composite_detailTab, true);
    }
}

