/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.editors;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.connectivity.db.DBElementStore;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class SQLObjectDataProvider
implements ITableLabelProvider,
IStructuredContentProvider {
    private ArrayList<ArrayList> data = null;
    private String partName = null;
    private Object[] columnProperties;

    public SQLObjectDataProvider(ResultSet rs, String partName, TableViewer tableViewer) {
        this.partName = partName;
        this.columnProperties = tableViewer.getColumnProperties();
        this.populate(rs);
    }

    private void populate(ResultSet rs) {
        try {
            try {
                this.data = new ArrayList();
                ResultSetMetaData cMetaData = rs.getMetaData();
                ArrayList<Object> details = new ArrayList<Object>();
                while (rs.next()) {
                    int i = 1;
                    while (i <= cMetaData.getColumnCount()) {
                        Object o;
                        String key = String.valueOf(this.partName) + ".";
                        if (i - 1 < this.columnProperties.length) {
                            key = String.valueOf(key) + this.columnProperties[i - 1];
                        }
                        if ((o = rs.getObject(i)) == null) {
                            details.add(DBToolsUiMessages.SqlObjectComposite_nullValueLabel);
                        } else {
                            List options = DBElementStore.getColumnValueOptions((String)key);
                            if (options == null) {
                                details.add(o);
                            } else if (options.contains(o)) {
                                details.add(options.indexOf(o));
                            } else {
                                details.add(o);
                            }
                        }
                        ++i;
                    }
                    this.addMetaData(details, "UNMODIFIED");
                    this.data.add(details);
                    details = new ArrayList();
                }
            }
            catch (SQLException se) {
                LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)se);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException se2) {
                    LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)se2);
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException se) {
                LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)se);
            }
        }
    }

    private void addMetaData(ArrayList<Object> row, String status) {
        row.add(this.partName);
        row.add(status);
        row.add(row.hashCode());
    }

    public Object[] getElements(Object inputElement) {
        return this.data.toArray(new ArrayList[this.data.size()]);
    }

    public String getColumnText(Object element, int columnIndex) {
        ArrayList v = (ArrayList)element;
        String textValue = v.get(columnIndex).toString();
        String columnKey = String.valueOf(this.partName) + "." + this.columnProperties[columnIndex];
        List values = DBElementStore.getColumnValueOptions((String)columnKey);
        if (values != null) {
            int tempInt = -1;
            try {
                tempInt = Integer.parseInt(textValue);
            }
            catch (NumberFormatException numberFormatException) {
                return textValue;
            }
            if (tempInt >= 0 && tempInt < values.size()) {
                return (String)values.get(tempInt);
            }
            return textValue;
        }
        return textValue;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.data = null;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

