/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.editors;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.connectivity.actions.OracleObject;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackage;
import oracle.eclipse.tools.database.connectivity.db.DatabaseObject;
import oracle.eclipse.tools.database.connectivity.ddl.OracleDdlGenerator;
import oracle.eclipse.tools.database.connectivity.editors.IPartEditContext;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import oracle.eclipse.tools.database.ui.editors.ObjectEditor;
import oracle.eclipse.tools.database.ui.editors.SQLObjectDataProvider;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public abstract class SQLObjectComposite
extends Composite
implements ObjectEditor.IPartEdit {
    public static final String PART_NAME_PROPERTY = "PART_NAME";
    public static final String PART_DISPLAY_VERTICALLY = "PART_DISPLAY VERTICALLY";
    public static final String SQL_PART_NAME = "SQL";
    public static final String OBJECT_DETAIL_PART_NAME = "Details";
    public static final String OBJECT_GRANTS_PART_NAME = "Grants";
    protected IPartEditContext context = null;
    protected TabFolder tabFolder;
    private boolean sqlGenerated = false;
    private String sqlString;
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected HashMap<String, TabItem> tabItemMap = new HashMap();
    protected HashMap<String, Boolean> partDataLoadMap = new HashMap();
    protected HashMap<String, ResultSet> resultSets = new HashMap();
    protected final String objectDetailQuery = "SELECT * FROM ALL_OBJECTS where owner = ? and object_name = ? and object_type = ?";
    protected PreparedStatement objectDetailStmt = null;
    protected final String objectGrantsQuery = "SELECT privilege, grantee, grantable, grantor, table_name FROM ALL_TAB_PRIVS where grantor = ? and table_name = ? ";
    protected PreparedStatement objectGrantsStmt = null;

    public SQLObjectComposite(IPartEditContext context, Composite parent, int style) {
        super(parent, style);
        this.tabFolder = (TabFolder)parent;
        this.context = context;
    }

    protected abstract ResultSet getPartData(String var1) throws SQLException;

    protected String[] addColumnsFromMetaData(TableViewer tableViewer, ResultSet rs, String viewTitle) {
        String[] columnProperties = null;
        try {
            ResultSetMetaData metaData = rs.getMetaData();
            Table table = tableViewer.getTable();
            TableLayout layout = new TableLayout();
            columnProperties = new String[metaData.getColumnCount()];
            int i = 1;
            while (i <= metaData.getColumnCount()) {
                String text;
                columnProperties[i - 1] = text = metaData.getColumnLabel(i);
                String columnKey = String.valueOf(viewTitle) + "." + text;
                TableColumn tc = new TableColumn(table, 0);
                tc.setText(this.context.getViewProperties().getColumnTitle(columnKey));
                if (this.context.getViewProperties().isVisible(columnKey)) {
                    layout.addColumnData((ColumnLayoutData)new ColumnPixelData(text.length() * 10, true, true));
                } else {
                    layout.addColumnData((ColumnLayoutData)new ColumnPixelData(0, false, false));
                }
                ++i;
            }
            table.setLayout((Layout)layout);
        }
        catch (SQLException se) {
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)se);
        }
        return columnProperties;
    }

    protected void add(String partName, String partLabel, ResultSet rs) throws SQLException {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText(partName);
        Table table = this.createTable((Composite)this.tabFolder);
        tabItem.setControl((Control)table);
        table.setVisible(true);
        TableViewer tableViewer = new TableViewer(table);
        String[] columnProperties = this.addColumnsFromMetaData(tableViewer, rs, partName);
        tableViewer.setColumnProperties(columnProperties);
        tableViewer.setUseHashlookup(true);
        SQLObjectDataProvider dataProvider = new SQLObjectDataProvider(rs, partName, tableViewer);
        tableViewer.setContentProvider((IContentProvider)dataProvider);
        tableViewer.setLabelProvider((IBaseLabelProvider)dataProvider);
        tableViewer.setInput((Object)this.context.getDatabaseObject());
        this.tabItemMap.put(partName, tabItem);
        this.partDataLoadMap.put(partName, true);
        this.resultSets.put(partName, rs);
    }

    protected void add(String partName, String partLabel) {
        this.add(partName, partLabel, false);
    }

    protected void add(String partName, String partLabel, boolean vertical) {
        TabItem lazyItem = new TabItem(this.tabFolder, 0);
        lazyItem.setText(partLabel);
        lazyItem.setData(PART_NAME_PROPERTY, (Object)partName);
        if (vertical) {
            lazyItem.setData(PART_DISPLAY_VERTICALLY, (Object)true);
        }
        this.tabItemMap.put(partName, lazyItem);
        this.partDataLoadMap.put(partName, false);
    }

    protected Table createTable(Composite parent) {
        Table table = new Table(parent, 67586);
        table.setVisible(false);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        return table;
    }

    protected void addExceptionMessage(TabItem tabItem, SQLException se) {
        Text text = new Text((Composite)this.tabFolder, 2);
        text.setText(se.getMessage());
        tabItem.setControl((Control)text);
    }

    protected void addSqlTab() {
        this.addSqlTab(DBToolsUiMessages.SqlObjectComposite_SqlTabLabel);
    }

    protected void addSqlTab(String tabLabel) {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText(tabLabel);
        tabItem.setData(PART_NAME_PROPERTY, (Object)SQL_PART_NAME);
        this.tabItemMap.put(SQL_PART_NAME, tabItem);
        this.partDataLoadMap.put(SQL_PART_NAME, false);
    }

    protected void addObjectDetailTab(String tabLabel) {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText(tabLabel);
        tabItem.setData(PART_NAME_PROPERTY, (Object)OBJECT_DETAIL_PART_NAME);
        tabItem.setData(PART_DISPLAY_VERTICALLY, (Object)true);
        this.tabItemMap.put(OBJECT_DETAIL_PART_NAME, tabItem);
        this.partDataLoadMap.put(OBJECT_DETAIL_PART_NAME, false);
    }

    protected void addObjectGrantsTab(String tabLabel) {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText(tabLabel);
        tabItem.setData(PART_NAME_PROPERTY, (Object)OBJECT_GRANTS_PART_NAME);
        this.tabItemMap.put(OBJECT_GRANTS_PART_NAME, tabItem);
        this.partDataLoadMap.put(OBJECT_GRANTS_PART_NAME, false);
    }

    protected void addPropertiesTab(String partName, String partLabel, List<Pair<String, String>> props) {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText(partLabel);
        tabItem.setData(PART_NAME_PROPERTY, (Object)partName);
        this.addPropertiesToTabItem(tabItem, props);
    }

    private void addPropertiesToTabItem(TabItem tabItem, List<Pair<String, String>> props) {
        Table table = this.createTable((Composite)this.tabFolder);
        tabItem.setControl((Control)table);
        table.setVisible(true);
        TableLayout layout = new TableLayout();
        TableColumn nameTc = new TableColumn(table, 0);
        nameTc.setText(DBToolsUiMessages.SqlObjectComposite_nameLabel);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(150, true, true));
        TableColumn valueTc = new TableColumn(table, 0);
        valueTc.setText(DBToolsUiMessages.SqlObjectComposite_valueLabel);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(200, true, true));
        table.setLayout((Layout)layout);
        for (Pair<String, String> prop : props) {
            String key = (String)prop.getFirst();
            String value = (String)prop.getSecond();
            TableItem tableItem = new TableItem(table, 0);
            tableItem.setText(new String[]{key, value});
        }
    }

    protected String getSql() {
        if (!this.sqlGenerated) {
            OracleObject oracleObj = this.context.getDatabaseObject().getOracleObject();
            assert (oracleObj instanceof SQLObject);
            SQLObject sqlObj = (SQLObject)oracleObj;
            if (sqlObj instanceof OraclePackage) {
                sqlObj = ((OraclePackage)sqlObj).getSpecification();
            }
            SQLObject[] elements = new SQLObject[]{sqlObj};
            String[] sqls = new OracleDdlGenerator().createSQLObjects(elements, true, true, null);
            StringBuffer buf = new StringBuffer();
            buf.append(NEWLINE);
            String[] stringArray = sqls;
            int n = sqls.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                buf.append(str);
                buf.append(";");
                buf.append(NEWLINE);
                buf.append(NEWLINE);
                ++n2;
            }
            this.sqlString = buf.toString();
            this.sqlGenerated = true;
        }
        return this.sqlString;
    }

    protected ResultSet getObjectDetailData() throws SQLException {
        DatabaseObject dbObj = this.context.getDatabaseObject();
        Connection connection = dbObj.getConnection();
        this.objectDetailStmt = connection.prepareCall("SELECT * FROM ALL_OBJECTS where owner = ? and object_name = ? and object_type = ?");
        this.objectDetailStmt.setString(1, dbObj.getOwner());
        this.objectDetailStmt.setString(2, dbObj.getName());
        this.objectDetailStmt.setString(3, dbObj.getType());
        ResultSet rset = this.objectDetailStmt.executeQuery();
        return rset;
    }

    protected ResultSet getObjectGrantsData() throws SQLException {
        DatabaseObject dbObj = this.context.getDatabaseObject();
        Connection connection = dbObj.getConnection();
        this.objectGrantsStmt = connection.prepareCall("SELECT privilege, grantee, grantable, grantor, table_name FROM ALL_TAB_PRIVS where grantor = ? and table_name = ? ");
        this.objectGrantsStmt.setString(1, dbObj.getOwner());
        this.objectGrantsStmt.setString(2, dbObj.getName());
        ResultSet rset = this.objectGrantsStmt.executeQuery();
        return rset;
    }

    @Override
    public void dispose() {
        try {
            for (ResultSet rs : this.resultSets.values()) {
                if (rs == null) continue;
                rs.close();
            }
            if (this.objectDetailStmt != null) {
                this.objectDetailStmt.close();
            }
            if (this.objectGrantsStmt != null) {
                this.objectGrantsStmt.close();
            }
        }
        catch (SQLException e) {
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
        }
    }

    protected void selectTabItem(final TabItem tabItem) {
        Runnable longJob = new Runnable(){

            @Override
            public void run() {
                try {
                    SQLObjectComposite.this.internalSelectTabItem(tabItem);
                }
                catch (SQLException se) {
                    SQLObjectComposite.this.addExceptionMessage(tabItem, se);
                }
            }
        };
        BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)longJob);
    }

    protected void internalSelectTabItem(TabItem tabItem) throws SQLException {
        String partName = (String)tabItem.getData(PART_NAME_PROPERTY);
        if (partName == null) {
            return;
        }
        TabItem lazyItem = this.tabItemMap.get(partName);
        if (lazyItem != null) {
            boolean dataLoaded = this.partDataLoadMap.get(partName);
            if (!dataLoaded) {
                if (partName.equals(SQL_PART_NAME)) {
                    Text text = new Text((Composite)this.tabFolder, 778);
                    GridData gd = new GridData(4, 4, true, true);
                    text.setLayoutData((Object)gd);
                    text.setBackground(new Color(null, 255, 255, 255));
                    text.setText(this.getSql());
                    tabItem.setControl((Control)text);
                } else {
                    ResultSet rs = null;
                    rs = partName.equals(OBJECT_DETAIL_PART_NAME) ? this.getObjectDetailData() : (partName.equals(OBJECT_GRANTS_PART_NAME) ? this.getObjectGrantsData() : this.getPartData(partName));
                    boolean vertical = false;
                    if (tabItem.getData(PART_DISPLAY_VERTICALLY) != null) {
                        vertical = (Boolean)tabItem.getData(PART_DISPLAY_VERTICALLY);
                    }
                    if (vertical) {
                        List<Pair<String, String>> props = this.resultSetToProperties(rs);
                        this.addPropertiesToTabItem(tabItem, props);
                    } else if (rs != null) {
                        Table table = this.createTable((Composite)this.tabFolder);
                        tabItem.setControl((Control)table);
                        table.setVisible(true);
                        TableViewer tableViewer = new TableViewer(table);
                        String[] columnProperties = this.addColumnsFromMetaData(tableViewer, rs, partName);
                        tableViewer.setColumnProperties(columnProperties);
                        tableViewer.setUseHashlookup(true);
                        SQLObjectDataProvider dataProvider = new SQLObjectDataProvider(rs, partName, tableViewer);
                        tableViewer.setContentProvider((IContentProvider)dataProvider);
                        tableViewer.setLabelProvider((IBaseLabelProvider)dataProvider);
                        tableViewer.setInput((Object)this.context.getDatabaseObject());
                    }
                    this.resultSets.put(partName, rs);
                }
            }
            this.tabFolder.layout(true, true);
            this.partDataLoadMap.put(partName, true);
        }
    }

    protected TabFolder getTabFolder() {
        return this.tabFolder;
    }

    protected IPartEditContext getContext() {
        return this.context;
    }

    private List<Pair<String, String>> resultSetToProperties(ResultSet rs) throws SQLException {
        ArrayList<Pair<String, String>> props = new ArrayList<Pair<String, String>>();
        ResultSetMetaData metaData = rs.getMetaData();
        if (rs.next()) {
            int i = 1;
            while (i <= metaData.getColumnCount()) {
                String name = metaData.getColumnLabel(i);
                String value = rs.getString(i);
                if (value == null || value.length() == 0) {
                    value = DBToolsUiMessages.SqlObjectComposite_nullValueLabel;
                }
                props.add((Pair<String, String>)new Pair((Object)name, (Object)value));
                ++i;
            }
        }
        return props;
    }
}

