/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.editors;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.connectivity.actions.IPrivilegeObject;
import oracle.eclipse.tools.database.connectivity.db.DatabaseObject;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import oracle.eclipse.tools.database.ui.editors.PrivilegeDialog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;

public class RevokePrivilegeDialog
extends PrivilegeDialog {
    private static final String objectGrantsQuery = "SELECT privilege, grantee FROM ALL_TAB_PRIVS where grantor = ? and table_name = ? ";
    private DatabaseObject dbObj;
    private HashMap<String, List<String>> objGrantMap = new HashMap();

    public RevokePrivilegeDialog(String dlgTitle, IPrivilegeObject privilegeObj, DatabaseObject dbObject) {
        super(dlgTitle, privilegeObj);
        this.dbObj = dbObject;
        this.retrieveGrantInfo();
    }

    @Override
    protected void initializeData() {
        super.initializeData();
        Set<String> keys = this.objGrantMap.keySet();
        if (keys != null) {
            for (String user : keys) {
                this.usrNameCombo.add(user);
            }
            if (this.usrNameCombo.getItemCount() > 0) {
                this.usrNameCombo.select(0);
            }
        }
    }

    @Override
    protected void handleUserSelection() {
        super.handleUserSelection();
        List<String> privs = this.objGrantMap.get(this.selectedUser);
        this.availableList.removeAll();
        this.availableList.setItems(privs.toArray(new String[privs.size()]));
        this.availableList.select(0);
        this.validate();
    }

    private void retrieveGrantInfo() {
        CallableStatement objectGrantsStmt = null;
        ResultSet grantResult = null;
        try {
            try {
                Connection connection = this.dbObj.getConnection();
                objectGrantsStmt = connection.prepareCall(objectGrantsQuery);
                objectGrantsStmt.setString(1, this.dbObj.getOwner());
                objectGrantsStmt.setString(2, this.dbObj.getName());
                grantResult = objectGrantsStmt.executeQuery();
                while (grantResult.next()) {
                    List<Object> privList;
                    String privilege = grantResult.getString(1);
                    String grantee = grantResult.getString(2);
                    if (this.objGrantMap.containsKey(grantee)) {
                        privList = this.objGrantMap.get(grantee);
                        privList.add(privilege);
                        continue;
                    }
                    privList = new ArrayList<String>();
                    privList.add(privilege);
                    this.objGrantMap.put(grantee, privList);
                }
            }
            catch (SQLException e) {
                LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
                try {
                    if (grantResult != null) {
                        grantResult.close();
                    }
                    if (objectGrantsStmt != null) {
                        objectGrantsStmt.close();
                    }
                }
                catch (SQLException e2) {
                    LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (grantResult != null) {
                    grantResult.close();
                }
                if (objectGrantsStmt != null) {
                    objectGrantsStmt.close();
                }
            }
            catch (SQLException e) {
                LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
            }
        }
    }

    @Override
    protected void validate() {
        if (this.usrNameCombo.getItemCount() == 0) {
            IStatus status = RevokePrivilegeDialog.makeWarningStatus((String)DBToolsUiMessages.noPrivilegeGrantedMsg);
            this.setStatus(status);
        }
        super.validate();
    }
}

