/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.editors;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.connectivity.db.DatabaseObject;
import oracle.eclipse.tools.database.connectivity.ddl.OracleDdlBuilder;
import oracle.eclipse.tools.database.connectivity.editors.IPartEditContext;
import oracle.eclipse.tools.database.connectivity.editors.SourceInput;
import oracle.eclipse.tools.database.connectivity.editors.ViewProperties;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import oracle.eclipse.tools.database.ui.editors.DatabaseLinkComposite;
import oracle.eclipse.tools.database.ui.editors.DirectoryComposite;
import oracle.eclipse.tools.database.ui.editors.GenericObjectComposite;
import oracle.eclipse.tools.database.ui.editors.SQLObjectComposite;
import oracle.eclipse.tools.database.ui.editors.SynonymComposite;
import oracle.eclipse.tools.database.ui.editors.table.TableComposite;
import oracle.eclipse.tools.database.ui.editors.table.ViewComposite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class ObjectEditor
extends EditorPart {
    private DatabaseObject dbo = null;
    private static ViewProperties viewProperties = null;
    private boolean dirty;
    private final OracleDdlBuilder ddlbuilder = new OracleDdlBuilder();
    private final List<IPartEdit> partEditors = new ArrayList<IPartEdit>();
    private String id = "";
    private Composite parent = null;

    static {
        try {
            viewProperties = new ViewProperties(ObjectEditor.class.getResourceAsStream("ObjectEditor.properties"));
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.setSite((IWorkbenchPartSite)site);
        super.setInput(input);
        if (input instanceof SourceInput) {
            SourceInput si = (SourceInput)input;
            this.dbo = si.getDatabaseObject();
        }
    }

    public void createPartControl(Composite parent) {
        String partName = this.dbo.getName();
        if (this.dbo.getType().equals("PACKAGE BODY")) {
            partName = String.format(DBToolsUiMessages.PACKAGES_BODY_WITH_SPACE, partName);
        }
        super.setPartName(partName);
        this.parent = parent;
        TabFolder tabFolder = new TabFolder(parent, 128);
        IPartEditContext context = new IPartEditContext(){

            public EditorPart getEditor() {
                return ObjectEditor.this;
            }

            public OracleDdlBuilder getDDLStatementBuilder() {
                return ObjectEditor.this.ddlbuilder;
            }

            public ViewProperties getViewProperties() {
                return viewProperties;
            }

            public DatabaseObject getDatabaseObject() {
                return ObjectEditor.this.dbo;
            }
        };
        SQLObjectComposite sqlComposite = null;
        Image image = null;
        if (this.dbo.getType().equals("TABLE")) {
            image = OracleDBUIPlugin.getInstance().getImage("icons/table.png");
            sqlComposite = new TableComposite(context, (Composite)tabFolder, 0);
        } else if (this.dbo.getType().equals("VIEW") || this.dbo.getType().equals("MATERIALIZED VIEW")) {
            image = OracleDBUIPlugin.getInstance().getImage("icons/view.png");
            sqlComposite = new ViewComposite(context, (Composite)tabFolder, 0);
        } else if (this.dbo.getType().equals("PUBLIC SYNONYM")) {
            image = OracleDBUIPlugin.getInstance().getImage("icons/public-synonym.png");
            sqlComposite = new SynonymComposite(context, (Composite)tabFolder, 0);
        } else if (this.dbo.getType().equals("SYNONYM")) {
            image = OracleDBUIPlugin.getInstance().getImage("icons/synonym.png");
            sqlComposite = new SynonymComposite(context, (Composite)tabFolder, 0);
        } else if (this.dbo.getType().equals("PACKAGE")) {
            image = OracleDBUIPlugin.getInstance().getImage("icons/package.png");
            sqlComposite = new GenericObjectComposite(context, (Composite)tabFolder, 0, true);
        } else if (this.dbo.getType().equals("PACKAGE BODY")) {
            image = OracleDBUIPlugin.getInstance().getImage("icons/package.png");
            sqlComposite = new GenericObjectComposite(context, (Composite)tabFolder, 0, true);
        } else if (this.dbo.getType().equals("PROCEDURE")) {
            image = OracleDBUIPlugin.getInstance().getImage("icons/procedure.png");
            sqlComposite = new GenericObjectComposite(context, (Composite)tabFolder, 0, true);
        } else if (this.dbo.getType().equals("FUNCTION")) {
            image = OracleDBUIPlugin.getInstance().getImage("icons/function.png");
            sqlComposite = new GenericObjectComposite(context, (Composite)tabFolder, 0, true);
        } else if (this.dbo.getType().equals("TYPE")) {
            image = OracleDBUIPlugin.getInstance().getImage("icons/type.png");
            sqlComposite = new GenericObjectComposite(context, (Composite)tabFolder, 0, true);
        } else if (this.dbo.getType().equals("SEQUENCE")) {
            image = OracleDBUIPlugin.getInstance().getImage("icons/sequence.png");
            sqlComposite = new GenericObjectComposite(context, (Composite)tabFolder, 0, false);
        } else if (this.dbo.getType().equals("DIRECTORY")) {
            image = OracleDBUIPlugin.getInstance().getImage("icons/directory.png");
            sqlComposite = new DirectoryComposite(context, (Composite)tabFolder, 0);
        } else if (this.dbo.getType().equals("DATABASE LINK")) {
            image = OracleDBUIPlugin.getInstance().getImage("icons/link.png");
            sqlComposite = new DatabaseLinkComposite(context, (Composite)tabFolder, 0);
        }
        if (image != null) {
            this.setTitleImage(image);
        }
        if (sqlComposite != null) {
            this.partEditors.add(sqlComposite);
            tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ObjectEditor.this.selectTabItem((TabItem)e.item);
                }
            });
        }
    }

    protected void selectTabItem(TabItem tabItem) {
        SQLObjectComposite sqlComposite = (SQLObjectComposite)this.partEditors.get(0);
        if (sqlComposite != null) {
            sqlComposite.selectTabItem(tabItem);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.firePropertyChange(257);
    }

    public void doSave(IProgressMonitor monitor) {
        int i = 0;
        while (i < this.partEditors.size()) {
            this.partEditors.get(i).doSave(monitor);
            ++i;
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.partEditors.size()) {
            this.partEditors.get(i).dispose();
            ++i;
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    public void setFocus() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Composite getParent() {
        return this.parent;
    }

    public static interface IPartEdit {
        public void doSave(IProgressMonitor var1);

        public void dispose();
    }
}

