/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.actions;

import java.net.MalformedURLException;
import java.net.URL;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackageObject;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import oracle.eclipse.tools.database.ui.util.DSEUtil;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.LaunchingJob;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.navigator.CommonViewer;

public class RunAction
extends Action {
    private SQLObject runnableObject;
    protected CommonViewer viewer;

    public RunAction() {
        this.setText(DBToolsUiMessages.dseRun);
        try {
            URL url = new URL("platform:/plugin/org.eclipse.datatools.sqltools.routineeditor.ui/icons/execute.gif");
            ImageDescriptor newImage = ImageDescriptor.createFromURL((URL)url);
            this.setImageDescriptor(newImage);
        }
        catch (MalformedURLException e) {
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
        }
    }

    public void run() {
        if (this.runnableObject == null) {
            return;
        }
        ProcIdentifier procId = DSEUtil.getProcIdentifier(this.runnableObject);
        if (procId != null) {
            LaunchingJob launchingJob = new LaunchingJob(procId, "run");
            launchingJob.schedule();
        }
    }

    public void setCommonViewer(CommonViewer viewer) {
        this.viewer = viewer;
    }

    public void selectionChanged(ISelection selection) {
        StructuredSelection ss;
        Object item;
        this.runnableObject = null;
        if (selection instanceof StructuredSelection && (item = (ss = (StructuredSelection)selection).getFirstElement()) instanceof OraclePackageObject) {
            this.runnableObject = (OraclePackageObject)item;
        }
    }
}

