/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.actions;

import java.sql.SQLException;
import java.sql.Statement;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.connectivity.catalog.OracleRecycleBinObject;
import oracle.eclipse.tools.database.connectivity.catalog.OracleSchema;
import oracle.eclipse.tools.database.ui.DBToolsUiMessages;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.navigator.CommonViewer;

public class PurgeAction
extends Action {
    private OracleRecycleBinObject recycleObject;
    protected CommonViewer viewer;
    private Object parentNode;
    private ITreeContentProvider treeContentProvider;

    public PurgeAction() {
        this.setText(DBToolsUiMessages.dsePurge);
    }

    public void setCommonViewer(CommonViewer viewer) {
        this.viewer = viewer;
        IContentProvider provider = this.viewer.getContentProvider();
        if (provider instanceof ITreeContentProvider) {
            this.treeContentProvider = (ITreeContentProvider)provider;
        }
    }

    public void run() {
        block14: {
            if (this.recycleObject == null) {
                return;
            }
            this.parentNode = this.treeContentProvider.getParent((Object)this.recycleObject);
            String sql = "purge " + this.recycleObject.getType() + " \"" + this.recycleObject.getObjectName() + "\"";
            Statement stmt = null;
            try {
                try {
                    MessageBox msgBox = new MessageBox(this.viewer.getCommonNavigator().getSite().getShell(), 196);
                    msgBox.setText(DBToolsUiMessages.purgeTitle);
                    String msg = String.format(DBToolsUiMessages.purgeDesc, this.recycleObject.getName());
                    msgBox.setMessage(msg);
                    if (msgBox.open() == 64) {
                        stmt = this.recycleObject.getConnection().prepareStatement(sql);
                        stmt.execute();
                        ((OracleSchema)this.recycleObject.getSchema()).refresh("RECYCLE BIN");
                        this.viewer.refresh(this.parentNode, true);
                    }
                }
                catch (SQLException e) {
                    MessageBox msgBox = new MessageBox(this.viewer.getCommonNavigator().getSite().getShell(), 1);
                    msgBox.setText(DBToolsUiMessages.purgeErrorMsg);
                    msgBox.setMessage(e.getLocalizedMessage());
                    msgBox.open();
                    if (stmt == null) break block14;
                    try {
                        stmt.close();
                    }
                    catch (SQLException e2) {
                        LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e2);
                    }
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (Throwable)e);
                    }
                }
            }
        }
    }

    public void selectionChanged(ISelection selection) {
        StructuredSelection ss;
        Object item;
        this.recycleObject = null;
        if (selection instanceof StructuredSelection && (item = (ss = (StructuredSelection)selection).getFirstElement()) instanceof OracleRecycleBinObject) {
            this.recycleObject = (OracleRecycleBinObject)item;
        }
    }
}

