/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.ui.actions;

import oracle.eclipse.tools.database.connectivity.actions.OracleObject;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackage;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackageBody;
import oracle.eclipse.tools.database.connectivity.db.DatabaseObject;
import oracle.eclipse.tools.database.ui.actions.OpenViewAction;
import oracle.eclipse.tools.database.ui.editors.ObjectEditor;
import oracle.eclipse.tools.database.ui.explorer.virtual.PackageBodyFolder;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;

public class ObjectListAction {
    private IViewPart view;
    private int instance;

    public ObjectListAction(IViewPart viewPart) {
        this.view = viewPart;
    }

    public void processSelection(IStructuredSelection selection, boolean newView) {
        for (Object obj : selection) {
            OracleObject oo = null;
            String name = null;
            String owner = null;
            if (obj instanceof ENamedElement) {
                ENamedElement element = (ENamedElement)obj;
                oo = (OracleObject)obj;
                name = element.getName();
                EObject container = ContainmentServiceImpl.INSTANCE.getContainer((EObject)obj);
                owner = ((Schema)container).getName();
            } else if (obj instanceof PackageBodyFolder) {
                OraclePackage owningPackage = (OraclePackage)((IVirtualNode)obj).getParent();
                oo = (OraclePackageBody)owningPackage.getBody();
                name = ((OraclePackageBody)oo).getName();
                owner = owningPackage.getSchema().getName();
            }
            ICatalogObject co = (ICatalogObject)oo;
            if (oo == null) continue;
            String objectType = oo.getOracleType();
            DatabaseObject dbObject = new DatabaseObject();
            dbObject.setName(name);
            dbObject.setType(objectType);
            dbObject.setId(oo.getId());
            dbObject.setOracleObject(oo);
            dbObject.setOwner(owner);
            dbObject.setConnection(co.getConnection());
            OpenViewAction openViewAction = new OpenViewAction(this.view.getViewSite().getWorkbenchWindow(), "Open Table View", "", dbObject, this.instance++);
            ((ObjectEditor)openViewAction.runInternal()).setId(dbObject.getId());
        }
    }
}

