/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.ui.diagram.model.schemaentities;

import oracle.eclipse.tools.common.ui.diagram.model.ChildNode;
import oracle.eclipse.tools.common.ui.diagram.model.Node;
import oracle.eclipse.tools.database.orm.ui.diagram.model.schemaentities.TableNode;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.swt.graphics.Image;

public class ColumnNode
extends ChildNode {
    private Column column;

    public ColumnNode(Column column) {
        this.column = column;
        Image image = null;
        this.setName(column.getName());
        if (column.isPartOfPrimaryKey()) {
            image = OracleDBUIPlugin.getInstance().getImage("icons/key.gif");
        } else if (column.isPartOfForeignKey()) {
            image = OracleDBUIPlugin.getInstance().getImage("icons/fkey.gif");
        }
        this.setImage(image);
        String label = column.getName();
        this.setDisplayLabel(label);
    }

    public ColumnNode(Column column, TableNode parent) {
        this(column);
        this.setParent((Node)parent);
    }

    public void refreshCoumnType() {
        if (this.column.getDataType() != null) {
            String label = String.valueOf(this.column.getName()) + " : " + this.column.getDataType().getName();
            this.setDisplayLabel(label);
        }
        this.setTooltip(this.getTooltipText());
    }

    private String getTooltipText() {
        StringBuffer buf = new StringBuffer();
        buf.append("Name        ");
        buf.append(this.column.getName());
        buf.append("\n");
        buf.append("Nullable    ");
        buf.append(Boolean.toString(this.column.isNullable()));
        buf.append("\n");
        buf.append("Type        ");
        if (this.column.getDataType() != null) {
            buf.append(this.column.getDataType().getName());
        }
        buf.append("\n");
        buf.append("Unique      ");
        buf.append(Boolean.toString(this.column.isPartOfUniqueConstraint()));
        return buf.toString();
    }
}

