/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.ui.diagram.editor.dbschemas;

import java.util.Iterator;
import oracle.eclipse.tools.common.ui.diagram.editor.NodeDiagramEditorInput;
import oracle.eclipse.tools.common.ui.diagram.model.NodeDiagramModel;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDatabase;
import oracle.eclipse.tools.database.connectivity.catalog.OracleSchema;
import oracle.eclipse.tools.database.orm.ui.diagram.model.schemaentities.SchemaDiagramModel;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class SchemaViewerInput
implements NodeDiagramEditorInput {
    private String schemaName;
    private String connectionProfile;
    private NodeDiagramModel model;

    public SchemaViewerInput(Schema schema) {
        this.schemaName = schema.getName();
        Database database = schema.getDatabase();
        if (database == null) {
            database = schema.getCatalog().getDatabase();
        }
        IConnectionProfile profile = ModelUtil.getConnectionProfile((Database)database);
        this.connectionProfile = profile.getName();
    }

    public Schema getDTPSchema() {
        IConnectionProfile profile = ProfileManager.getInstance().getProfileByName(this.connectionProfile);
        IManagedConnection managedConnection = profile.getManagedConnection("org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo");
        Schema schema = null;
        if (managedConnection != null) {
            try {
                ConnectionInfo connectionInfo;
                if (managedConnection.getConnection() != null && (connectionInfo = (ConnectionInfo)managedConnection.getConnection().getRawConnection()) != null) {
                    Database database = connectionInfo.getSharedDatabase();
                    schema = SchemaViewerInput.getSchema(database, this.schemaName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return schema;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.schemaName;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.schemaName;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getFactoryId() {
        return null;
    }

    public void saveState(IMemento memento) {
    }

    public synchronized NodeDiagramModel getModel() throws InterruptedException {
        if (this.model == null) {
            this.model = new SchemaDiagramModel(this.getDTPSchema());
        }
        return this.model;
    }

    public synchronized NodeDiagramModel refreshModel() throws InterruptedException {
        Schema schema = this.getDTPSchema();
        if (schema instanceof OracleSchema) {
            ((OracleSchema)schema).refresh("TABLE");
        }
        this.model = new SchemaDiagramModel(this.getDTPSchema());
        return this.model;
    }

    public String getPartName() {
        return String.valueOf(this.schemaName) + " " + Resources.diagram;
    }

    public boolean equals(Object o) {
        SchemaViewerInput schemaInput;
        return o instanceof SchemaViewerInput && (schemaInput = (SchemaViewerInput)o).getDTPSchema() != null && this.getDTPSchema() != null && schemaInput.getDTPSchema().equals(this.getDTPSchema());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.connectionProfile.hashCode();
        result = 31 * result + this.schemaName.hashCode();
        return result;
    }

    private static Schema getSchema(Database database, String schemaName) {
        EList catalogs;
        Schema schema = null;
        Object schemas = database instanceof OracleDatabase ? ((OracleDatabase)database).getAllSchemas() : database.getSchemas();
        if ((schemas == null || schemas.isEmpty()) && (catalogs = database.getCatalogs()).size() > 0) {
            Catalog catalog = (Catalog)catalogs.get(0);
            schemas = catalog.getSchemas();
        }
        Iterator iterator = schemas.iterator();
        while (iterator.hasNext()) {
            Object schemaObj = iterator.next();
            Schema schema2 = (Schema)schemaObj;
            if (!schema2.getName().equals(schemaName)) continue;
            schema = schema2;
            break;
        }
        return schema;
    }

    private static final class Resources
    extends NLS {
        public static String diagram;

        static {
            Resources.initializeMessages((String)SchemaViewerInput.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

