/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.ui.diagram.actions.dbschemas;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.orm.ui.diagram.editor.dbschemas.SchemaDiagramEditor;
import oracle.eclipse.tools.database.orm.ui.diagram.editor.dbschemas.SchemaViewerInput;
import oracle.eclipse.tools.database.ui.OracleDBUIPlugin;
import oracle.eclipse.tools.database.ui.explorer.virtual.OracleTableNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;

public class LaunchSchemaViewerAction
extends Action {
    private static final String TEXT = Resources.showInSchemaViewer;
    protected CommonViewer viewer;
    private Schema schema;
    private Table table;

    public LaunchSchemaViewerAction() {
        this.setText(TEXT);
        this.setToolTipText(TEXT);
    }

    public void setCommonViewer(CommonViewer viewer) {
        this.viewer = viewer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof TreeSelection) {
            if (((TreeSelection)event.getSelection()).size() > 1) {
                this.setEnabled(false);
            } else {
                Object parent;
                this.setEnabled(true);
                Object obj = ((TreeSelection)event.getSelection()).getFirstElement();
                if (obj instanceof Schema) {
                    this.schema = (Schema)obj;
                } else if (obj instanceof Table) {
                    this.schema = ((Table)obj).getSchema();
                    this.table = (Table)obj;
                } else if (obj instanceof OracleTableNode && (parent = ((OracleTableNode)((Object)obj)).getParent()) instanceof Schema) {
                    this.schema = (Schema)parent;
                }
            }
        }
    }

    public void run() {
        if (this.schema == null) {
            return;
        }
        SchemaViewerInput input = new SchemaViewerInput(this.schema);
        try {
            input.getModel();
        }
        catch (InterruptedException e) {
            LoggingService.logException((String)Resources.launchSchemaViewerInterruptedMsg, (Throwable)e);
            return;
        }
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = null;
        if (workbenchWindow != null) {
            page = workbenchWindow.getActivePage();
        }
        try {
            if (page != null) {
                IEditorPart editorPart = page.openEditor((IEditorInput)input, "SchemaDiagramEditor");
                assert (editorPart instanceof SchemaDiagramEditor);
                if (this.table != null) {
                    ((SchemaDiagramEditor)editorPart).setInitialSelection(this.table.getName());
                }
            }
        }
        catch (PartInitException e) {
            LoggingService.logException((Plugin)OracleDBUIPlugin.getInstance(), (CoreException)e);
        }
    }

    private static final class Resources
    extends NLS {
        public static String showInSchemaViewer;
        public static String launchSchemaViewerInterruptedMsg;

        static {
            Resources.initializeMessages((String)LaunchSchemaViewerAction.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

