/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.factories;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.mylyn.internal.gerrit.ui.GerritReviewBehavior;
import org.eclipse.mylyn.internal.gerrit.ui.factories.AbstractPatchSetUiFactory;
import org.eclipse.mylyn.internal.reviews.ui.compare.FileItemCompareEditorInput;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.mylyn.reviews.ui.spi.factories.IUiContext;

public class OpenFileUiFactory
extends AbstractPatchSetUiFactory {
    private final IFileItem item;

    public OpenFileUiFactory(IUiContext context, IReviewItemSet set, IFileItem item) {
        super("Open File", context, set);
        this.item = item;
    }

    public void execute() {
        if (!this.isExecutable()) {
            this.handleExecutionStateError();
            return;
        }
        if (this.item.getBase() == null || this.item.getTarget() == null) {
            this.getEditor().setMessage("The selected file is not available, yet", 2);
            return;
        }
        GerritReviewBehavior behavior = new GerritReviewBehavior(this.getTask(), this.resolveGitRepository());
        CompareConfiguration configuration = new CompareConfiguration();
        CompareUI.openCompareEditor((CompareEditorInput)new FileItemCompareEditorInput(configuration, this.item, (ReviewBehavior)behavior));
    }

    public boolean isExecutable() {
        return this.getChange() != null;
    }
}

