/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.editor;

import com.google.gerrit.reviewdb.PatchSet;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.ui.internal.synchronize.GitModelSynchronize;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.mylyn.internal.gerrit.ui.egit.EGitUiUtil;

public class ComparePatchSetJob
extends Job {
    protected final Repository repository;
    protected final PatchSet target;
    private final PatchSet base;
    protected final RemoteConfig remote;

    public ComparePatchSetJob(Repository repository, RemoteConfig remote, PatchSet base, PatchSet target) {
        super("Comparing Patch Set");
        this.repository = repository;
        this.remote = remote;
        this.base = base;
        this.target = target;
    }

    public void openSynchronization(String baseRef, String targetRef) throws IOException {
        GitSynchronizeData data = new GitSynchronizeData(this.repository, baseRef, targetRef, false);
        Set projects = data.getProjects();
        GitModelSynchronize.launch((GitSynchronizeData)data, (IResource[])projects.toArray(new IResource[projects.size()]));
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
            String targetRef = EGitUiUtil.fetchPatchSet((IProgressMonitor)subMonitor, this.repository, this.remote, this.target).getName();
            String baseRef = this.base != null ? EGitUiUtil.fetchPatchSet((IProgressMonitor)subMonitor, this.repository, this.remote, this.base).getName() : this.fetchParent(this.target, (IProgressMonitor)subMonitor);
            this.openSynchronization(baseRef, targetRef);
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.mylyn.gerrit.ui", "Patch set retrieval failed", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private String fetchParent(PatchSet patchSet, IProgressMonitor monitor) throws URISyntaxException, CoreException, IOException {
        RevCommit targetCommit = EGitUiUtil.getRevCommit(this.repository, patchSet);
        RevCommit parentCommit = targetCommit.getParents()[0];
        return parentCommit.getName();
    }
}

