/*
 * Decompiled with CFR 0.152.
 */
package name.pachler.nio.file.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import name.pachler.nio.file.ClosedWatchServiceException;
import name.pachler.nio.file.Path;
import name.pachler.nio.file.StandardWatchEventKind;
import name.pachler.nio.file.WatchEvent;
import name.pachler.nio.file.WatchKey;
import name.pachler.nio.file.ext.ExtendedWatchEventKind;
import name.pachler.nio.file.impl.CloseableBlockingQueue;
import name.pachler.nio.file.impl.NativeLibLoader;
import name.pachler.nio.file.impl.PathImpl;
import name.pachler.nio.file.impl.PathWatchEvent;
import name.pachler.nio.file.impl.PathWatchKey;
import name.pachler.nio.file.impl.PathWatchService;
import name.pachler.nio.file.impl.VoidWatchEvent;
import name.pachler.nio.file.impl.Windows;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsPathWatchService
extends PathWatchService {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static volatile int threadCounter = 0;
    private Map<Path, WatchRecord> pathToWatchRecordMap = new HashMap<Path, WatchRecord>();
    private List<WindowsPathWatchThread> startedThreads = new LinkedList<WindowsPathWatchThread>();
    private CloseableBlockingQueue<PathWatchKey> pendingWatchKeys = new CloseableBlockingQueue();

    private static native void initNative();

    private native void translateFILE_NOTIFY_INFORMATION(WatchRecord var1, Windows.ByteBuffer var2, int var3);

    private void FILE_NOTIFY_INFORMATIONhandler(WatchRecord wr, int action, String fileName) {
        int flags = wr.getFlags();
        WatchEvent.Kind<Path> kind = null;
        switch (action) {
            case 5: {
                if (0 != (flags & 4)) {
                    kind = ExtendedWatchEventKind.ENTRY_RENAME_TO;
                    break;
                }
            }
            case 1: {
                if (0 == (flags & 8)) break;
                kind = StandardWatchEventKind.ENTRY_CREATE;
                break;
            }
            case 4: {
                if (0 != (flags & 2)) {
                    kind = ExtendedWatchEventKind.ENTRY_RENAME_FROM;
                    break;
                }
            }
            case 2: {
                if (0 == (flags & 0x10)) break;
                kind = StandardWatchEventKind.ENTRY_DELETE;
                break;
            }
            case 3: {
                if (0 == (flags & 0x20)) break;
                kind = StandardWatchEventKind.ENTRY_MODIFY;
            }
        }
        if (kind == null) {
            return;
        }
        PathWatchEvent e = new PathWatchEvent(kind, new PathImpl(new File(fileName)), 1);
        this.addWatchEvent(wr, e);
    }

    void addWatchEvent(WatchRecord wr, WatchEvent<?> e) {
        if (wr.addWatchEvent(e)) {
            this.pendingWatchKeys.add(wr);
        }
    }

    private void logLastError() {
        int lastError = Windows.GetLastError();
        String errorMsg = Windows.GetLastError_toString(lastError);
        String message = "Thread '" + Thread.currentThread().getName() + "': error while reading from watch key: " + errorMsg;
        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, message);
    }

    private void cancelImpl(WatchRecord wr) {
        if ((wr.getFlags() & 0x40) != 0) {
            this.addWatchEvent(wr, new VoidWatchEvent(ExtendedWatchEventKind.KEY_INVALID));
        }
        Windows.CancelIo(wr.handle);
        Windows.CloseHandle(wr.handle);
        Windows.CloseHandle(wr.overlapped.getEventHandle());
        wr.invalidate();
        wr.thread.eventHandleToWatchRecord.remove(wr.overlapped.getEventHandle());
        this.pathToWatchRecordMap.remove(wr.getPath());
    }

    private static long openDirectoryHandle(PathImpl pathImpl) {
        String file = pathImpl.getFile().getAbsolutePath();
        int shareMode = 7;
        int flagsAndAttributes = 0x42000000;
        return Windows.CreateFile(file, 1, shareMode, null, 3, flagsAndAttributes, 0L);
    }

    @Override
    public synchronized PathWatchKey register(Path path, WatchEvent.Kind<?>[] kinds, WatchEvent.Modifier[] modifiers) throws IOException {
        boolean commandResult;
        PathImpl pathImpl;
        try {
            pathImpl = (PathImpl)path;
        }
        catch (ClassCastException ccx) {
            throw new IllegalArgumentException("the provided Path was not created by the newPath factory method of name.pachler.nio.file.ext.Bootstrapper");
        }
        if (!pathImpl.getFile().isDirectory()) {
            throw new IOException("path " + pathImpl.toString() + " is not a directory");
        }
        int flags = this.makeFlagMask(kinds, modifiers);
        WatchRecord wr = this.pathToWatchRecordMap.get(path);
        if (wr == null) {
            long directoryHandle = WindowsPathWatchService.openDirectoryHandle(pathImpl);
            if (directoryHandle == Windows.INVALID_HANDLE_VALUE) {
                int errorCode = Windows.GetLastError();
                throw new IOException(Windows.GetLastError_toString(errorCode));
            }
            WindowsPathWatchThread currentThread = null;
            for (WindowsPathWatchThread t : this.startedThreads) {
                if (t.isFull()) continue;
                currentThread = t;
                break;
            }
            if (currentThread == null) {
                currentThread = new WindowsPathWatchThread();
                currentThread.setDaemon(true);
                currentThread.start();
                this.startedThreads.add(currentThread);
            }
            wr = new WatchRecord(this, pathImpl, flags, currentThread);
            wr.buffer = new Windows.ByteBuffer(8192);
            wr.overlapped = new Windows.OVERLAPPED();
            wr.overlapped.setEvent(Windows.CreateEvent(null, true, false, null));
            wr.handle = directoryHandle;
            commandResult = currentThread.executeCommand(new Command(1, wr));
        } else {
            commandResult = wr.thread.executeCommand(new Command(4, wr, flags));
        }
        if (!commandResult) {
            throw new IOException("register() failed, details are in log.");
        }
        return wr;
    }

    @Override
    synchronized void cancel(PathWatchKey pathWatchKey) {
        WatchRecord wr = (WatchRecord)pathWatchKey;
        wr.thread.executeCommand(new Command(3, wr));
        if (wr.thread.isEmpty()) {
            wr.thread.executeCommand(new Command(2, wr));
            this.startedThreads.remove(wr.thread);
        }
    }

    @Override
    public synchronized boolean reset(PathWatchKey pathWatchKey) {
        WatchRecord wr = (WatchRecord)pathWatchKey;
        if (wr.hasPendingWatchEvents()) {
            this.pendingWatchKeys.add(wr);
        }
        return true;
    }

    @Override
    public synchronized void close() throws IOException {
        for (WindowsPathWatchThread thread : this.startedThreads) {
            thread.close();
        }
        this.pendingWatchKeys.close();
    }

    @Override
    public WatchKey poll() throws InterruptedException, ClosedWatchServiceException {
        return this.pendingWatchKeys.poll();
    }

    @Override
    public WatchKey poll(long timeout, TimeUnit unit) throws InterruptedException, ClosedWatchServiceException {
        return this.pendingWatchKeys.poll(timeout, unit);
    }

    @Override
    public WatchKey take() throws InterruptedException, ClosedWatchServiceException {
        return this.pendingWatchKeys.take();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.close();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    static /* synthetic */ void access$700(WindowsPathWatchService x0, WatchRecord x1) {
        x0.cancelImpl(x1);
    }

    static /* synthetic */ Map access$900(WindowsPathWatchService x0) {
        return x0.pathToWatchRecordMap;
    }

    static /* synthetic */ long access$1300(PathImpl x0) {
        return WindowsPathWatchService.openDirectoryHandle(x0);
    }

    static /* synthetic */ void access$1400(WindowsPathWatchService x0) {
        x0.logLastError();
    }

    static /* synthetic */ void access$1500(WindowsPathWatchService x0, WatchRecord x1, Windows.ByteBuffer x2, int x3) {
        x0.translateFILE_NOTIFY_INFORMATION(x1, x2, x3);
    }

    static {
        NativeLibLoader.loadLibrary("jpathwatch-native");
        WindowsPathWatchService.initNative();
    }

    public class WindowsPathWatchThread
    extends Thread {
        private SynchronousQueue<Boolean> commandResultQueue = new SynchronousQueue();
        private ConcurrentLinkedQueue<Command> commandQueue = new ConcurrentLinkedQueue();
        private Map<Long, WatchRecord> eventHandleToWatchRecord = new HashMap<Long, WatchRecord>();
        private long signallingEvent = Windows.CreateEvent(null, true, false, null);

        WindowsPathWatchThread() {
            this.setName(this.getClass().getSimpleName() + '-' + threadCounter++);
        }

        private synchronized boolean executeCommand(Command command) {
            this.commandQueue.add(command);
            Windows.SetEvent(this.signallingEvent);
            boolean success = false;
            boolean result = false;
            while (!success) {
                try {
                    result = this.commandResultQueue.take();
                    success = true;
                }
                catch (InterruptedException ix) {}
            }
            return result;
        }

        public boolean isFull() {
            return this.eventHandleToWatchRecord.size() >= 63;
        }

        public boolean isEmpty() {
            return this.eventHandleToWatchRecord.isEmpty();
        }

        public synchronized void close() throws IOException {
            if (!this.isAlive() || this.signallingEvent == 0L) {
                throw new ClosedWatchServiceException();
            }
            this.executeCommand(new Command(2, null));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block16: while (true) {
                handles = new long[this.eventHandleToWatchRecord.size() + 1];
                handles[0] = this.signallingEvent;
                handleIndex = 1;
                for (long h : this.eventHandleToWatchRecord.keySet()) {
                    handles[handleIndex++] = h;
                }
                try {
                    result = Windows.WaitForMultipleObjects(handles, false, -1);
                }
                catch (RuntimeException e) {
                    message = "Thread '" + Thread.currentThread().getName() + "': error while calling WaitForMultipleObjects. Exception: " + e;
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, message);
                    done = false;
                    while (true) {
                        if (done) {
                            throw e;
                        }
                        try {
                            this.commandResultQueue.put(false);
                            done = true;
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(WindowsPathWatchService.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                if (result == 0) {
                    block40: {
                        block38: {
                            block39: {
                                Windows.ResetEvent(this.signallingEvent);
                                cmd = this.commandQueue.poll();
                                success = false;
                                watchRecord = null;
                                if (!WindowsPathWatchThread.$assertionsDisabled && cmd == null) {
                                    throw new AssertionError();
                                }
                                try {
                                    switch (Command.access$600(cmd)) {
                                        case 2: {
                                            for (WatchRecord wr : new ArrayList<WatchRecord>(this.eventHandleToWatchRecord.values())) {
                                                WindowsPathWatchService.access$700(WindowsPathWatchService.this, wr);
                                            }
                                            this.eventHandleToWatchRecord.clear();
                                            Windows.CloseHandle(this.signallingEvent);
                                            this.signallingEvent = 0L;
                                            success = true;
                                            var11_20 = null;
                                            if (success) break block38;
                                            break block39;
                                        }
                                        case 1: {
                                            watchRecord = Command.access$800(cmd);
                                            this.eventHandleToWatchRecord.put(watchRecord.overlapped.getEventHandle(), watchRecord);
                                            WindowsPathWatchService.access$900(WindowsPathWatchService.this).put(watchRecord.getPath(), watchRecord);
                                            success = Windows.ReadDirectoryChanges(watchRecord.handle, watchRecord.buffer, WatchRecord.access$1000(watchRecord), WatchRecord.access$1100(watchRecord), null, watchRecord.overlapped, null);
                                            break;
                                        }
                                        case 4: {
                                            watchRecord = Command.access$800(cmd);
                                            newFlags = Command.access$1200(cmd);
                                            oldFlags = watchRecord.getFlags();
                                            watchSubtreeChanged = ((newFlags ^ oldFlags) & 4096) != 0;
                                            watchRecord.setFlags(newFlags);
                                            success = Windows.CancelIo(watchRecord.handle);
                                            if (success && watchSubtreeChanged) {
                                                success = Windows.CloseHandle(watchRecord.handle);
                                                WindowsPathWatchService.this.addWatchEvent(watchRecord, new VoidWatchEvent(StandardWatchEventKind.OVERFLOW));
                                                if (success) {
                                                    watchRecord.handle = WindowsPathWatchService.access$1300((PathImpl)watchRecord.getPath());
                                                    v0 = success = watchRecord.handle != Windows.INVALID_HANDLE_VALUE;
                                                }
                                            }
                                            if (success) {
                                                success = Windows.ReadDirectoryChanges(watchRecord.handle, watchRecord.buffer, WatchRecord.access$1000(watchRecord), WatchRecord.access$1100(watchRecord), null, watchRecord.overlapped, null);
                                                break;
                                            }
                                            break block40;
                                        }
                                        case 3: {
                                            watchRecord = Command.access$800(cmd);
                                            WindowsPathWatchService.access$700(WindowsPathWatchService.this, watchRecord);
                                            success = true;
                                            break;
                                        }
                                        default: {
                                            throw new RuntimeException("unhandled command type");
                                        }
                                    }
                                    break block40;
                                }
                                catch (Throwable var10_23) {
                                    var11_20 = null;
                                    if (!success) {
                                        WindowsPathWatchService.access$1400(WindowsPathWatchService.this);
                                        WindowsPathWatchService.access$700(WindowsPathWatchService.this, watchRecord);
                                    }
                                    done = false;
                                    while (true) {
                                        if (done) {
                                            throw var10_23;
                                        }
                                        try {
                                            this.commandResultQueue.put(success);
                                            done = true;
                                        }
                                        catch (InterruptedException ex) {
                                            Logger.getLogger(WindowsPathWatchService.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                    }
                                }
                            }
                            WindowsPathWatchService.access$1400(WindowsPathWatchService.this);
                            WindowsPathWatchService.access$700(WindowsPathWatchService.this, watchRecord);
                        }
                        done = false;
                        while (done == false) {
                            ** try [egrp 3[TRYBLOCK] [5 : 698->716)] { 
lbl106:
                            // 1 sources

                            this.commandResultQueue.put(success);
                            return;
lbl108:
                            // 1 sources

                            catch (InterruptedException ex) {
                                Logger.getLogger(WindowsPathWatchService.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                        return;
                    }
                    var11_20 = null;
                    if (!success) {
                        WindowsPathWatchService.access$1400(WindowsPathWatchService.this);
                        WindowsPathWatchService.access$700(WindowsPathWatchService.this, watchRecord);
                    }
                    done = false;
                    while (true) {
                        if (done) continue block16;
                        ** try [egrp 3[TRYBLOCK] [5 : 698->716)] { 
lbl121:
                        // 1 sources

                        this.commandResultQueue.put(success);
                        done = true;
lbl124:
                        // 1 sources

                        catch (InterruptedException ex) {
                            Logger.getLogger(WindowsPathWatchService.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                if (0 >= result || result >= handles.length) continue;
                index = result - 0;
                h = handles[index];
                wr = this.eventHandleToWatchRecord.get(h);
                Windows.ResetEvent(wr.overlapped.getEventHandle());
                success = true;
                numberOfBytesTransferred = new int[]{0};
                if (success) {
                    success = Windows.GetOverlappedResult(wr.overlapped.getEventHandle(), wr.overlapped, numberOfBytesTransferred, true);
                }
                if (success) {
                    if (numberOfBytesTransferred[0] != 0) {
                        WindowsPathWatchService.access$1500(WindowsPathWatchService.this, wr, wr.buffer, numberOfBytesTransferred[0]);
                    } else {
                        WindowsPathWatchService.this.addWatchEvent(wr, new VoidWatchEvent(StandardWatchEventKind.OVERFLOW));
                    }
                }
                if (success) {
                    success = Windows.ReadDirectoryChanges(wr.handle, wr.buffer, WatchRecord.access$1000(wr), WatchRecord.access$1100(wr), null, wr.overlapped, null);
                }
                if (success) continue;
                if (Windows.GetLastError() != 5) {
                    WindowsPathWatchService.access$1400(WindowsPathWatchService.this);
                }
                WindowsPathWatchService.access$700(WindowsPathWatchService.this, wr);
            }
        }
    }

    private static class Command {
        static final int TYPE_ADD_WATCHRECORD = 1;
        static final int TYPE_SHUTDOWN = 2;
        static final int TYPE_REMOVE_WATCHRECORD = 3;
        static final int TYPE_MODIFY_WATCHRECORD = 4;
        private int type;
        private final WatchRecord wr;
        private int flags;

        private Command(int type, WatchRecord wr) {
            this(type, wr, 0);
        }

        private Command(int type, WatchRecord wr, int flags) {
            this.type = type;
            this.wr = wr;
            this.flags = flags;
        }

        private int getType() {
            return this.type;
        }

        private WatchRecord getWatchRecord() {
            return this.wr;
        }

        private int getFlags() {
            return this.flags;
        }

        static /* synthetic */ int access$600(Command x0) {
            return x0.getType();
        }

        static /* synthetic */ WatchRecord access$800(Command x0) {
            return x0.getWatchRecord();
        }

        static /* synthetic */ int access$1200(Command x0) {
            return x0.getFlags();
        }
    }

    private static class WatchRecord
    extends PathWatchKey {
        public long handle;
        public Windows.OVERLAPPED overlapped;
        public Windows.ByteBuffer buffer;
        private WindowsPathWatchThread thread = null;

        WatchRecord(WindowsPathWatchService pws, Path path, int flags, WindowsPathWatchThread thread) {
            super(pws, path, flags);
            this.thread = thread;
        }

        private int getNotifyFilter() {
            int flags = this.getFlags();
            int notifyFilter = 0;
            if (0 != (flags & 8 | 0x10 | 2 | 4)) {
                notifyFilter |= 3;
            }
            if (0 != (flags & 0x20)) {
                notifyFilter |= 0x18;
            }
            return notifyFilter;
        }

        private boolean getWatchSubtree() {
            int flags = this.getFlags();
            return 0 != (flags & 0x1000);
        }

        static /* synthetic */ boolean access$1000(WatchRecord x0) {
            return x0.getWatchSubtree();
        }

        static /* synthetic */ int access$1100(WatchRecord x0) {
            return x0.getNotifyFilter();
        }
    }
}

