/*
 * Decompiled with CFR 0.152.
 */
package name.pachler.nio.file.impl;

import java.util.List;
import java.util.Vector;
import name.pachler.nio.file.Path;
import name.pachler.nio.file.WatchEvent;
import name.pachler.nio.file.WatchKey;
import name.pachler.nio.file.impl.PathWatchService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathWatchKey
extends WatchKey {
    private int flags;
    private PathWatchService service;
    private Vector<WatchEvent<?>> eventQueue = new Vector();
    private final Path path;
    private boolean signalled;

    PathWatchKey(PathWatchService pws, Path path, int flags) {
        this.service = pws;
        this.path = path;
        this.flags = flags;
    }

    protected void finalize() {
        this.service.cancel(this);
    }

    @Override
    public void cancel() {
        this.service.cancel(this);
    }

    @Override
    public final boolean isValid() {
        return this.service != null;
    }

    void invalidate() {
        this.service = null;
    }

    @Override
    public synchronized List<WatchEvent<?>> pollEvents() {
        Vector polledEvents = new Vector(this.eventQueue);
        this.eventQueue.clear();
        return polledEvents;
    }

    @Override
    public synchronized boolean reset() {
        if (!this.isValid()) {
            return false;
        }
        if (!this.signalled) {
            return true;
        }
        this.signalled = false;
        return this.service.reset(this);
    }

    Path getPath() {
        return this.path;
    }

    synchronized boolean addWatchEvent(WatchEvent<?> watchEvent) {
        this.eventQueue.add(watchEvent);
        if (!this.signalled) {
            this.signalled = true;
            return true;
        }
        return false;
    }

    synchronized boolean hasPendingWatchEvents() {
        return !this.eventQueue.isEmpty();
    }

    int getFlags() {
        return this.flags;
    }

    void setFlags(int flags) {
        this.flags = flags;
    }

    protected int getNumQueuedEvents() {
        return this.eventQueue.size();
    }
}

