/*
 * Decompiled with CFR 0.152.
 */
package name.pachler.nio.file.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import name.pachler.nio.file.ClosedWatchServiceException;
import name.pachler.nio.file.Path;
import name.pachler.nio.file.WatchEvent;
import name.pachler.nio.file.WatchKey;
import name.pachler.nio.file.ext.ExtendedWatchEventKind;
import name.pachler.nio.file.impl.BSD;
import name.pachler.nio.file.impl.PathImpl;
import name.pachler.nio.file.impl.PathWatchKey;
import name.pachler.nio.file.impl.PathWatchService;
import name.pachler.nio.file.impl.PollingPathWatchKey;
import name.pachler.nio.file.impl.Unix;
import name.pachler.nio.file.impl.VoidWatchEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BSDPathWatchService
extends PathWatchService {
    private int kqueuefd = -1;
    private Map<String, Integer> dirs = new HashMap<String, Integer>();
    private Map<Integer, PollingPathWatchKey> keys = new HashMap<Integer, PollingPathWatchKey>();
    private int closePipeReadFd;
    private int closePipeWriteFd;
    private final Object changeLock = new Object();
    private Set<PathWatchKey> signalledWatchKeys = new HashSet<PathWatchKey>();
    private Queue<PathWatchKey> pendingWatchKeys = new LinkedList<PathWatchKey>();
    private static final long DEFAULT_POLLING_INTERVAL_MILLIS = 2000L;
    private long pollingIntervalMillis = 2000L;
    private int numKeysRequiringPolling;

    public BSDPathWatchService() {
        try {
            String propertyValue = System.getProperty("name.pachler.io.file.BSDPathWatchService.pollingIntervalMillis", Long.toString(2000L));
            this.pollingIntervalMillis = Long.parseLong(propertyValue);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PathWatchKey register(Path path, WatchEvent.Kind<?>[] kinds, WatchEvent.Modifier[] modifiers) throws IOException {
        int supportedFlags;
        PathImpl pathImpl = this.checkAndCastToPathImpl(path);
        int flags = this.makeFlagMask(kinds, modifiers);
        if ((flags & ~(supportedFlags = 120)) != 0) {
            throw new UnsupportedOperationException("The given watch event kind or modifier is not supported by this WatchService");
        }
        String pathname = pathImpl.getFile().getAbsolutePath();
        PollingPathWatchKey key = null;
        BSD.write(this.closePipeWriteFd, new byte[1], 1);
        Object object = this.changeLock;
        synchronized (object) {
            if (this.kqueuefd == -1) {
                throw new ClosedWatchServiceException();
            }
            Integer dirfdInteger = this.dirs.get(pathname);
            if (dirfdInteger != null) {
                key = this.keys.get(dirfdInteger);
            }
            if (key == null) {
                boolean success = false;
                int dirfd = -1;
                try {
                    dirfd = BSD.open(pathname, BSD.O_RDONLY, 0);
                    if (dirfd == -1) {
                        throw new IOException("error registering the path with the native OS: " + Unix.strerror(Unix.errno()));
                    }
                    BSD.kevent e = new BSD.kevent();
                    e.set_ident(dirfd);
                    e.set_filter(BSD.EVFILT_VNODE);
                    e.set_flags((short)(BSD.EV_ADD | BSD.EV_CLEAR));
                    e.set_fflags(BSD.NOTE_WRITE | BSD.NOTE_DELETE | BSD.NOTE_REVOKE);
                    int result = BSD.kevent(this.kqueuefd, new BSD.kevent[]{e}, null, null);
                    if (result != 0) {
                        throw new IOException("error registering the path with the native OS: " + Unix.strerror(Unix.errno()));
                    }
                    key = new PollingPathWatchKey(this, path, 0);
                    this.keys.put(dirfd, key);
                    this.dirs.put(pathname, dirfd);
                }
                finally {
                    if (key == null && dirfd != -1) {
                        BSD.close(dirfd);
                    }
                }
            }
            if (key != null && key.getFlags() != flags) {
                int moddiff = 0;
                moddiff += (flags & 0x20) != 0 ? 1 : 0;
                this.numKeysRequiringPolling += (moddiff += (key.getFlags() & 0x20) != 0 ? -1 : 0);
                key.setFlags(flags);
            }
            BSD.read(this.closePipeReadFd, new byte[1], 1);
        }
        key.poll();
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void cancel(PathWatchKey pathWatchKey) {
        byte[] b = new byte[1];
        Unix.write(this.closePipeWriteFd, b, 1);
        Object object = this.changeLock;
        synchronized (object) {
            boolean eventsAdded = this.cancelImpl(pathWatchKey);
            if (eventsAdded) {
                this.queueKey(pathWatchKey);
            }
            int nread = Unix.read(this.closePipeReadFd, b, 1);
            assert (nread == 1);
        }
    }

    private boolean cancelImpl(PathWatchKey pathWatchKey) {
        PathImpl pathImpl = (PathImpl)pathWatchKey.getPath();
        String pathString = pathImpl.getFile().getPath();
        Integer dirfdInteger = this.dirs.get(pathString);
        if (dirfdInteger == null) {
            return false;
        }
        PathWatchKey key = this.keys.get(dirfdInteger);
        if (key != pathWatchKey) {
            return false;
        }
        boolean eventAdded = false;
        if ((key.getFlags() & 0x40) != 0) {
            key.addWatchEvent(new VoidWatchEvent(ExtendedWatchEventKind.KEY_INVALID));
            eventAdded = true;
        }
        int dirfd = dirfdInteger;
        BSD.kevent[] changelist = new BSD.kevent[]{new BSD.kevent()};
        changelist[0].set_ident(dirfd);
        changelist[0].set_filter(BSD.EVFILT_VNODE);
        changelist[0].set_flags(BSD.EV_DELETE);
        int result = BSD.kevent(this.kqueuefd, changelist, null, null);
        assert (result == 0);
        key.invalidate();
        if ((key.getFlags() & 0x20) != 0) {
            --this.numKeysRequiringPolling;
        }
        return eventAdded;
    }

    @Override
    public synchronized boolean reset(PathWatchKey pathWatchKey) {
        if (!pathWatchKey.isValid()) {
            return false;
        }
        if (pathWatchKey.hasPendingWatchEvents()) {
            this.pendingWatchKeys.add(pathWatchKey);
        } else {
            this.signalledWatchKeys.remove(pathWatchKey);
        }
        return true;
    }

    private void open() {
        this.kqueuefd = BSD.kqueue();
        int[] pipefd = new int[2];
        int pipeResult = Unix.pipe(pipefd);
        this.closePipeReadFd = pipefd[0];
        this.closePipeWriteFd = pipefd[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        byte[] b = new byte[1];
        Unix.write(this.closePipeWriteFd, new byte[]{0}, 1);
        Object object = this.changeLock;
        synchronized (object) {
            BSD.close(this.kqueuefd);
            this.kqueuefd = -1;
            int nread = Unix.read(this.closePipeReadFd, b, 1);
            assert (nread == 1);
            BSD.close(this.closePipeReadFd);
            BSD.close(this.closePipeWriteFd);
        }
    }

    @Override
    public WatchKey poll() throws InterruptedException, ClosedWatchServiceException {
        return this.pollImpl(0L);
    }

    @Override
    public WatchKey poll(long timeout, TimeUnit unit) throws InterruptedException, ClosedWatchServiceException {
        long millis = TimeUnit.MILLISECONDS.convert(timeout, unit);
        return this.pollImpl(millis);
    }

    @Override
    public WatchKey take() throws InterruptedException, ClosedWatchServiceException {
        return this.pollImpl(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WatchKey pollImpl(long timeout) throws InterruptedException, ClosedWatchServiceException {
        long lastStart = System.currentTimeMillis();
        do {
            if (timeout != -1L) {
                long currentTime = System.currentTimeMillis();
                long lastDuration = currentTime - lastStart;
                if ((timeout -= lastDuration) < 0L) {
                    timeout = 0L;
                }
                lastStart = currentTime;
            }
            BSD.kevent[] eventlist = new BSD.kevent[32];
            long selectTimeout = timeout;
            if ((timeout == -1L || timeout > this.pollingIntervalMillis) && this.numKeysRequiringPolling > 0) {
                selectTimeout = this.pollingIntervalMillis;
            }
            int nread = 0;
            Object object = this.changeLock;
            synchronized (object) {
                if (this.pendingWatchKeys.size() > 0) {
                    return this.pendingWatchKeys.remove();
                }
                if (this.kqueuefd == -1) {
                    throw new ClosedWatchServiceException();
                }
                int[] readfds = new int[]{this.closePipeReadFd, this.kqueuefd};
                int selectResult = Unix.select(readfds, null, null, selectTimeout);
                if (selectResult == -1) {
                    if (BSD.errno() == BSD.EINTR) {
                        throw new InterruptedException();
                    }
                    String message = BSD.strerror(BSD.errno());
                    try {
                        this.close();
                    }
                    finally {
                        throw new ClosedWatchServiceException();
                    }
                }
                if (readfds[0] == this.closePipeReadFd) {
                    continue;
                }
                if (readfds[1] == this.kqueuefd) {
                    nread = BSD.kevent(this.kqueuefd, null, eventlist, null);
                }
                if (nread == -1) {
                    if (nread == Unix.EINTR) {
                        throw new InterruptedException();
                    }
                    try {
                        this.close();
                    }
                    finally {
                        throw new ClosedWatchServiceException();
                    }
                }
                if (nread > 0) {
                    for (int i = 0; i < nread; ++i) {
                        boolean eventsAdded;
                        BSD.kevent e = eventlist[i];
                        int dirfd = (int)e.get_ident();
                        int fflags = e.get_fflags();
                        PollingPathWatchKey key = this.keys.get(dirfd);
                        if (key == null) continue;
                        if ((fflags & BSD.NOTE_DELETE) != 0 || (fflags & BSD.NOTE_REVOKE) != 0) {
                            eventsAdded = this.cancelImpl(key);
                        } else {
                            try {
                                eventsAdded = key.poll();
                            }
                            catch (FileNotFoundException ex) {
                                eventsAdded = this.cancelImpl(key);
                            }
                        }
                        if (!eventsAdded) continue;
                        this.queueKey(key);
                    }
                } else if (this.numKeysRequiringPolling > 0) {
                    for (PollingPathWatchKey key : this.keys.values()) {
                        boolean eventsAdded;
                        if ((key.getFlags() & 0x20) == 0) continue;
                        try {
                            eventsAdded = key.poll();
                        }
                        catch (FileNotFoundException ex) {
                            eventsAdded = this.cancelImpl(key);
                        }
                        if (!eventsAdded) continue;
                        this.queueKey(key);
                    }
                }
                if (this.pendingWatchKeys.size() > 0) {
                    return this.pendingWatchKeys.remove();
                }
            }
        } while (timeout > 0L || timeout == -1L);
        return null;
    }

    private void queueKey(PathWatchKey key) {
        if (!this.signalledWatchKeys.contains(key)) {
            this.signalledWatchKeys.add(key);
            this.pendingWatchKeys.add(key);
        }
    }
}

