/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.maven.adf.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class MavenPageDataModelProvider
extends AbstractDataModelProvider {
    public static final String USE_MAVEN = "NewADFApplicationDataModelProvider.USE_MAVEN";
    public static final String MAVEN_GROUP_ID = "NewADFApplicationDataModelProvider.MAVEN_GROUP_ID";
    public static final String MAVEN_ARTIFACT_ID = "NewADFApplicationDataModelProvider.MAVEN_ARTIFACT_ID";
    public static final String MAVEN_VERSION = "NewADFApplicationDataModelProvider.MAVEN_VERSION";
    public static final String MAVEN_SERVER = "NewADFApplicationDataModelProvider.MAVEN_SERVER";
    protected static final List<String> SUPPORTED_SERVER_IDS = new ArrayList<String>();

    static {
        SUPPORTED_SERVER_IDS.add("com.bea.weblogic1212.server");
    }

    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add(USE_MAVEN);
        names.add(MAVEN_GROUP_ID);
        names.add(MAVEN_ARTIFACT_ID);
        names.add(MAVEN_VERSION);
        names.add(MAVEN_SERVER);
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        if (USE_MAVEN.equals(propertyName)) {
            return Boolean.FALSE;
        }
        if (MAVEN_GROUP_ID.equals(propertyName)) {
            return "com.oracle.oepe";
        }
        if (MAVEN_ARTIFACT_ID.equals(propertyName)) {
            return "ADFApp";
        }
        if (MAVEN_VERSION.equals(propertyName)) {
            return "0.0.1-SNAPSHOT";
        }
        if (MAVEN_SERVER.equals(propertyName)) {
            return null;
        }
        return super.getDefaultProperty(propertyName);
    }

    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        if (MAVEN_SERVER.equals(propertyName)) {
            IServer server = (IServer)this.getProperty(MAVEN_SERVER);
            if (server != null) {
                return new DataModelPropertyDescriptor((Object)server, server.getName());
            }
            return new DataModelPropertyDescriptor(null, Resources.NO_MAVEN_SERVER_LABEL);
        }
        return super.getPropertyDescriptor(propertyName);
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (MAVEN_SERVER.equals(propertyName)) {
            ArrayList<IServer> list = new ArrayList<IServer>();
            IServer[] servers = ServerCore.getServers();
            if (servers != null) {
                IServer[] iServerArray = servers;
                int n = servers.length;
                int n2 = 0;
                while (n2 < n) {
                    Object objAdaptedServer;
                    IServer server = iServerArray[n2];
                    if (SUPPORTED_SERVER_IDS.contains(server.getServerType().getId()) && (objAdaptedServer = server.loadAdapter(IWeblogicServer.class, null)) != null) {
                        list.add(server);
                    }
                    ++n2;
                }
            }
            DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[list.size() + 1];
            descriptors[0] = new DataModelPropertyDescriptor(null, Resources.NO_MAVEN_SERVER_LABEL);
            Iterator iterator = list.iterator();
            int i = 0;
            int size = list.size();
            while (i < size) {
                IServer server = (IServer)iterator.next();
                descriptors[i + 1] = new DataModelPropertyDescriptor((Object)server, server.getName());
                ++i;
            }
            if (descriptors.length > 2) {
                Arrays.sort(descriptors, 1, descriptors.length, new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        DataModelPropertyDescriptor d1 = (DataModelPropertyDescriptor)arg0;
                        DataModelPropertyDescriptor d2 = (DataModelPropertyDescriptor)arg1;
                        return d1.getPropertyDescription().compareTo(d2.getPropertyDescription());
                    }
                });
            }
            return descriptors;
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public IStatus validate(String propertyName) {
        if (MAVEN_GROUP_ID.equals(propertyName)) {
            String groupID = this.getStringProperty(MAVEN_GROUP_ID);
            if (this.getBooleanProperty(USE_MAVEN) && (groupID == null || groupID.length() < 1)) {
                return new Status(4, "oracle.eclipse.tools.maven.adf", Resources.EMPTY_MAVEN_GROUP_ID);
            }
            return Status.OK_STATUS;
        }
        if (MAVEN_ARTIFACT_ID.equals(propertyName)) {
            String artifactID = this.getStringProperty(MAVEN_ARTIFACT_ID);
            if (this.getBooleanProperty(USE_MAVEN) && (artifactID == null || artifactID.length() < 1)) {
                return new Status(4, "oracle.eclipse.tools.maven.adf", Resources.EMPTY_MAVEN_ARTIFACT_ID);
            }
            return Status.OK_STATUS;
        }
        if (MAVEN_VERSION.equals(propertyName)) {
            String version = this.getStringProperty(MAVEN_VERSION);
            if (this.getBooleanProperty(USE_MAVEN) && (version == null || version.length() < 1)) {
                return new Status(4, "oracle.eclipse.tools.maven.adf", Resources.EMPTY_MAVEN_VERSION);
            }
            return Status.OK_STATUS;
        }
        if (MAVEN_SERVER.equals(propertyName)) {
            IServer server = (IServer)this.getProperty(MAVEN_SERVER);
            if (this.getBooleanProperty(USE_MAVEN) && server != null) {
                boolean isValid = SUPPORTED_SERVER_IDS.contains(server.getServerType().getId());
                Object objAdaptedServer = server.loadAdapter(IWeblogicServer.class, null);
                if (!(isValid &= objAdaptedServer != null)) {
                    return new Status(4, "oracle.eclipse.tools.maven.adf", Resources.INVALID_MAVEN_SERVER);
                }
            }
            return Status.OK_STATUS;
        }
        return super.validate(propertyName);
    }

    private static final class Resources
    extends NLS {
        public static String NO_MAVEN_SERVER_LABEL;
        public static String EMPTY_MAVEN_GROUP_ID;
        public static String EMPTY_MAVEN_ARTIFACT_ID;
        public static String EMPTY_MAVEN_VERSION;
        public static String INVALID_MAVEN_SERVER;

        static {
            Resources.initializeMessages((String)MavenPageDataModelProvider.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

