/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.maven.adf.project.conversion;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.maven.adf.project.conversion.AbstractFacetedProjectConversionParticipant;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;

public class ADFEJBProjectConversionParticipant
extends AbstractFacetedProjectConversionParticipant {
    protected static final List<AbstractFacetedProjectConversionParticipant.LibraryDescriptor> libraries11g = new ArrayList<AbstractFacetedProjectConversionParticipant.LibraryDescriptor>();
    protected static final List<AbstractFacetedProjectConversionParticipant.LibraryDescriptor> libraries12c;

    static {
        libraries11g.add(new AbstractFacetedProjectConversionParticipant.LibraryDescriptor("oracle.jdeveloper.library", "TopLink", "12.1.2.0.0"));
        libraries11g.add(new AbstractFacetedProjectConversionParticipant.LibraryDescriptor("oracle.jdeveloper.library", "Java-EE", "12.1.2.0.0"));
        libraries11g.add(new AbstractFacetedProjectConversionParticipant.LibraryDescriptor("oracle.jdeveloper.library", "ADF-Model-Runtime", "12.1.2.0.0"));
        libraries11g.add(new AbstractFacetedProjectConversionParticipant.LibraryDescriptor("oracle.jdeveloper.library", "ADF-Model-Generic-Runtime", "12.1.2.0.0"));
        libraries11g.add(new AbstractFacetedProjectConversionParticipant.LibraryDescriptor("oracle.jdeveloper.library", "Oracle-XML-Parser-v2", "12.1.2.0.0"));
        libraries12c = new ArrayList<AbstractFacetedProjectConversionParticipant.LibraryDescriptor>();
        libraries12c.add(new AbstractFacetedProjectConversionParticipant.LibraryDescriptor("com.oracle.adf.library", "TopLink", "12.1.2-0-0"));
        libraries12c.add(new AbstractFacetedProjectConversionParticipant.LibraryDescriptor("com.oracle.adf.library", "Java-EE", "12.1.2-0-0"));
        libraries12c.add(new AbstractFacetedProjectConversionParticipant.LibraryDescriptor("com.oracle.adf.library", "ADF-Model-Runtime", "12.1.2-0-0"));
        libraries12c.add(new AbstractFacetedProjectConversionParticipant.LibraryDescriptor("com.oracle.adf.library", "ADF-Model-Generic-Runtime", "12.1.2-0-0"));
        libraries12c.add(new AbstractFacetedProjectConversionParticipant.LibraryDescriptor("com.oracle.adf.library", "Oracle-XML-Parser-v2", "12.1.2-0-0"));
    }

    @Override
    protected IProjectFacet getApplicableFacet() {
        return IJ2EEFacetConstants.EJB_FACET;
    }

    @Override
    public boolean accept(IProject project) throws CoreException {
        boolean accept = super.accept(project);
        if (accept) {
            QualifiedName isProjectInADFApp = new QualifiedName("oracle.eclipse.tools.maven.adf.ui.mavenpage", "isProjectInADFApp");
            Object inADFApp = project.getSessionProperty(isProjectInADFApp);
            accept = inADFApp instanceof Boolean && (Boolean)inADFApp != false;
        }
        return accept;
    }

    public void convert(IProject project, Model model, IProgressMonitor monitor) throws CoreException {
        if (project != null && model != null) {
            List<AbstractFacetedProjectConversionParticipant.LibraryDescriptor> libraries = libraries11g;
            String adfVersion = ADFEJBProjectConversionParticipant.getADFVersion(project);
            if ("12.1.2".equals(adfVersion)) {
                libraries = libraries12c;
            }
            for (AbstractFacetedProjectConversionParticipant.LibraryDescriptor library : libraries) {
                ADFEJBProjectConversionParticipant.addLibrary(model, library);
            }
            ADFEJBProjectConversionParticipant.addResourceFolder(model, "adfmsrc");
        }
    }
}

