/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.maven.adf.project.conversion;

import java.util.ArrayList;
import java.util.Map;
import oracle.eclipse.tools.maven.adf.project.conversion.AbstractFacetedProjectConversionParticipant;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import oracle.eclipse.tools.weblogic.server.ServerInfo;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;

public class ADFEARProjectConversionParticipant
extends AbstractFacetedProjectConversionParticipant {
    @Override
    protected IProjectFacet getApplicableFacet() {
        return IJ2EEFacetConstants.ENTERPRISE_APPLICATION_FACET;
    }

    @Override
    public boolean accept(IProject project) throws CoreException {
        boolean accept = super.accept(project);
        if (accept) {
            QualifiedName isProjectInADFApp = new QualifiedName("oracle.eclipse.tools.maven.adf.ui.mavenpage", "isProjectInADFApp");
            Object inADFApp = project.getSessionProperty(isProjectInADFApp);
            accept = inADFApp instanceof Boolean && (Boolean)inADFApp != false;
        }
        return accept;
    }

    public void convert(IProject project, Model model, IProgressMonitor monitor) throws CoreException {
        if (project != null && model != null) {
            ADFEARProjectConversionParticipant.setFileNameMapping(model);
            ADFEARProjectConversionParticipant.configureWeblogicDeployment(project, model);
        }
    }

    private static void setFileNameMapping(Model model) {
        if (model != null) {
            Object configuration;
            Plugin plugin;
            Map pluginsMap;
            Build build = model.getBuild();
            if (build == null) {
                build = new Build();
                model.setBuild(build);
            }
            if ((pluginsMap = build.getPluginsAsMap()) == null) {
                ArrayList plugins = new ArrayList();
                build.setPlugins(plugins);
                pluginsMap = build.getPluginsAsMap();
            }
            if ((plugin = (Plugin)pluginsMap.get("org.apache.maven.plugins:maven-ear-plugin")) == null) {
                plugin = new Plugin();
                plugin.setGroupId("org.apache.maven.plugins");
                plugin.setArtifactId("maven-ear-plugin");
                build.addPlugin(plugin);
            }
            if ((configuration = plugin.getConfiguration()) == null) {
                configuration = new Xpp3Dom("configuration");
                plugin.setConfiguration(configuration);
            }
            if (configuration instanceof Xpp3Dom) {
                Xpp3Dom fileNameMapping = new Xpp3Dom("fileNameMapping");
                fileNameMapping.setValue("no-version");
                ((Xpp3Dom)configuration).addChild(fileNameMapping);
            }
        }
    }

    private static void configureWeblogicDeployment(IProject project, Model model) throws CoreException {
        if (project != null && model != null) {
            PluginManagement pluginManagement;
            Build build;
            String adminurl = "SET_ADMINURL";
            QualifiedName weblogicServerKey = new QualifiedName("oracle.eclipse.tools.maven.adf.ui.mavenpage", "weblogicServer");
            Object objWeblogicServer = project.getSessionProperty(weblogicServerKey);
            if (objWeblogicServer instanceof IWeblogicServer) {
                IWeblogicServer weblogicServer = (IWeblogicServer)objWeblogicServer;
                ServerInfo serverInfo = weblogicServer.getServerInfo();
                adminurl = "t3://" + serverInfo.getHostName() + ":" + serverInfo.getPortNumber();
            }
            if ((build = model.getBuild()) == null) {
                build = new Build();
                model.setBuild(build);
            }
            if ((pluginManagement = build.getPluginManagement()) == null) {
                pluginManagement = new PluginManagement();
                build.setPluginManagement(pluginManagement);
            }
            Plugin plugin = new Plugin();
            plugin.setGroupId("com.oracle.weblogic");
            plugin.setArtifactId("weblogic-maven-plugin");
            String adfVersion = ADFEARProjectConversionParticipant.getADFVersion(project);
            if ("12.1.2".equals(adfVersion)) {
                plugin.setVersion("12.1.2.0");
            } else {
                plugin.setVersion("10.3.6.0");
            }
            Xpp3Dom configuration = new Xpp3Dom("configuration");
            ADFEARProjectConversionParticipant.addChildElement(configuration, "adminurl", adminurl);
            ADFEARProjectConversionParticipant.addChildElement(configuration, "user", "${wls.user}");
            ADFEARProjectConversionParticipant.addChildElement(configuration, "password", "${wls.password}");
            ADFEARProjectConversionParticipant.addChildElement(configuration, "upload", "true");
            ADFEARProjectConversionParticipant.addChildElement(configuration, "remote", "false");
            ADFEARProjectConversionParticipant.addChildElement(configuration, "verbose", "true");
            ADFEARProjectConversionParticipant.addChildElement(configuration, "source", "${project.build.directory}/${project.build.finalName}.${project.packaging}");
            ADFEARProjectConversionParticipant.addChildElement(configuration, "name", "${project.build.finalName}");
            plugin.setConfiguration((Object)configuration);
            pluginManagement.addPlugin(plugin);
        }
    }

    private static void addChildElement(Xpp3Dom parent, String name, String value) {
        if (parent != null && name != null && name.trim().length() > 0 && value != null && value.trim().length() > 0) {
            Xpp3Dom child = new Xpp3Dom(name);
            child.setValue(value);
            parent.addChild(child);
        }
    }
}

