/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.maven.adf.project.configurator;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.eclipse.tools.weblogic.JRFRuntimeUtil;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public abstract class AbstractADFProjectConfigurator
extends AbstractProjectConfigurator {
    private static Map<String, RuntimeDescriptor> adfArchetypeVersionToRuntimeDescriptorMap = new HashMap<String, RuntimeDescriptor>();

    static {
        adfArchetypeVersionToRuntimeDescriptorMap.put("12.1.2-0-0", new RuntimeDescriptor("com.bea.weblogic", "12.1.2"));
        adfArchetypeVersionToRuntimeDescriptorMap.put("DEFAULT", new RuntimeDescriptor("com.bea.weblogic", "12.1.2"));
    }

    public abstract String[] getRequiredResourcePaths();

    public abstract List<IProjectFacetVersion> getRequiredFacetVersions(String var1, String var2);

    public abstract String getJobName();

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IFacetedProject facetedProject;
        IProject project;
        if (request != null && (project = request.getProject()) != null && project.isAccessible() && AbstractADFProjectConfigurator.projectContainsResources(project, this.getRequiredResourcePaths()) && (facetedProject = ProjectFacetsManager.create((IProject)project)) != null) {
            IRuntime runtime = AbstractADFProjectConfigurator.getRuntime(request.getMavenProject());
            String wlsVersion = AbstractADFProjectConfigurator.getWLSVersion(runtime);
            String adfVersion = JRFRuntimeUtil.getAdfVersionForWls((String)wlsVersion);
            List<IProjectFacetVersion> facetVersions = this.getRequiredFacetVersions(wlsVersion, adfVersion);
            String jobName = this.getJobName();
            AbstractADFProjectConfigurator.scheduleJob(jobName, facetedProject, runtime, facetVersions);
        }
    }

    private static boolean projectContainsResources(IProject project, String[] resourcePaths) {
        boolean contains = true;
        if (resourcePaths != null) {
            String[] stringArray = resourcePaths;
            int n = resourcePaths.length;
            int n2 = 0;
            while (n2 < n) {
                String resourcePath = stringArray[n2];
                IResource resource = project.findMember(resourcePath);
                contains &= resource != null && resource.exists();
                ++n2;
            }
        }
        return contains;
    }

    private static IRuntime getRuntime(MavenProject mavenProject) {
        String adfArchetypeVersion;
        RuntimeDescriptor descriptor;
        Properties properties;
        IRuntime runtime = null;
        if (mavenProject != null && (properties = mavenProject.getProperties()) != null && (descriptor = adfArchetypeVersionToRuntimeDescriptorMap.get(adfArchetypeVersion = properties.getProperty("adf.archetype.version", "DEFAULT"))) != null) {
            runtime = descriptor.getRuntime();
        }
        return runtime;
    }

    private static String getWLSVersion(IRuntime runtime) {
        List runtimeComponents;
        String version = null;
        if (runtime != null && (runtimeComponents = runtime.getRuntimeComponents()) != null) {
            for (IRuntimeComponent runtimeComponent : runtimeComponents) {
                IRuntimeComponentVersion runtimeComponentVersion = runtimeComponent.getRuntimeComponentVersion();
                if (runtimeComponentVersion == null || !runtimeComponentVersion.getRuntimeComponentType().getId().equals("com.bea.weblogic")) continue;
                version = runtimeComponentVersion.getVersionString();
            }
        }
        return version;
    }

    private static void scheduleJob(String jobName, IFacetedProject facetedProject, IRuntime runtime, List<IProjectFacetVersion> facetVersions) throws CoreException {
        new ADFProjectConfiguratorJob(jobName, facetedProject, runtime, facetVersions).schedule();
    }

    static class ADFProjectConfiguratorJob
    extends WorkspaceJob {
        private IFacetedProject facetedProject;
        private IRuntime runtime;
        private List<IProjectFacetVersion> facetVersions;

        public ADFProjectConfiguratorJob(String jobName, IFacetedProject facetedProject, IRuntime runtime, List<IProjectFacetVersion> facetVersions) {
            super(jobName);
            this.facetedProject = facetedProject;
            this.runtime = runtime;
            this.facetVersions = facetVersions;
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            this.setPriority(30);
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            if (this.facetedProject != null) {
                if (this.runtime != null && this.facetedProject.getPrimaryRuntime() == null) {
                    this.facetedProject.setTargetedRuntimes(Collections.singleton(this.runtime), monitor);
                }
                if (this.facetVersions != null) {
                    for (IProjectFacetVersion facetVersion : this.facetVersions) {
                        if (this.facetedProject.hasProjectFacet(facetVersion.getProjectFacet())) continue;
                        this.facetedProject.installProjectFacet(facetVersion, null, monitor);
                    }
                }
            }
            return Status.OK_STATUS;
        }
    }

    static class RuntimeDescriptor {
        private String type;
        private String version;

        public RuntimeDescriptor(String type, String version) {
            this.type = type;
            this.version = version;
        }

        public IRuntime getRuntime() {
            IRuntime runtime = null;
            if (this.type != null && this.version != null) {
                for (IRuntime curRuntime : RuntimeManager.getRuntimes()) {
                    for (IRuntimeComponent curComponent : curRuntime.getRuntimeComponents()) {
                        IRuntimeComponentType curType = curComponent.getRuntimeComponentType();
                        if (!this.type.equals(curType.getId())) continue;
                        IRuntimeComponentVersion curVersion = curComponent.getRuntimeComponentVersion();
                        if (!this.version.equals(curVersion.getVersionString())) break;
                        runtime = curRuntime;
                        break;
                    }
                    if (runtime != null) break;
                }
            }
            return runtime;
        }
    }
}

