/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.services;

import java.util.Collection;
import java.util.Set;
import oracle.eclipse.tools.adf.controller.ADFControllerPlugin;
import oracle.eclipse.tools.adf.controller.model.IManagedBean;
import oracle.eclipse.tools.adf.controller.model.ITaskFlowFile;
import oracle.eclipse.tools.common.services.util.DefaultUniqueIdGenerator;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ManagedBeanUpdateService
extends AbstractDataModelOperation {
    public static final String SERVICE_TYPE_PROPERTY = "ManagedBeanUpdateService.SERVICE_TYPE";
    public static final String SERVICE_TYPE = "ManagedBeanUpdateService";
    public static final String IFILE_PROPERTY = "ManagedBeanUpdateService.IFile.FILE";
    public static final String CLASS_PROPERTY = "ManagedBeanUpdateService.String.CLASS";
    public static final String NAME_PROPERTY = "ManagedBeanUpdateService.String.NAME";
    public static final String SCOPE_PROPERTY = "ManagedBeanUpdateService.String.SCOPE";

    public ManagedBeanUpdateService(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IFile adfcConfigFile = (IFile)this.getDataModel().getProperty(IFILE_PROPERTY);
        String classVal = (String)this.getDataModel().getProperty(CLASS_PROPERTY);
        String nameVal = (String)this.getDataModel().getProperty(NAME_PROPERTY);
        String scopeVal = (String)this.getDataModel().getProperty(SCOPE_PROPERTY);
        try {
            if (adfcConfigFile == null || !adfcConfigFile.exists()) {
                return Status.CANCEL_STATUS;
            }
            XmlResourceStore store = new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(adfcConfigFile));
            ITaskFlowFile tfFile = (ITaskFlowFile)ITaskFlowFile.TYPE.instantiate((Resource)new RootXmlResource(store));
            ElementList<IManagedBean> managedBeanList = tfFile.getTaskFlow().getManagedBeans();
            IManagedBean managedBean = (IManagedBean)managedBeanList.insert();
            String id = this.generateUniqueId(store, "managed_bean");
            if (id != null) {
                managedBean.setId(id);
            }
            managedBean.setManagedBeanName(nameVal);
            managedBean.setManagedBeanClass(classVal);
            managedBean.setManagedBeanScope(scopeVal);
            this.save(store, adfcConfigFile);
        }
        catch (Exception e) {
            throw new ExecutionException("Error updating adfc-config with managed bean", (Throwable)e);
        }
        return null;
    }

    public String getServiceType() {
        return SERVICE_TYPE;
    }

    private void save(XmlResourceStore store, IFile file) {
        if (store != null) {
            try {
                store.save();
            }
            catch (ResourceStoreException rse) {
                LoggingService.logException((Plugin)ADFControllerPlugin.getDefault(), (Throwable)rse);
            }
        }
    }

    private String generateUniqueId(XmlResourceStore store, String baseName) {
        DefaultUniqueIdGenerator generator = new DefaultUniqueIdGenerator();
        Set ids = generator.getIDs(store.getDomDocument().getDocumentElement());
        return generator.generateUniqueId((Collection)ids, baseName);
    }
}

