/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.refactoring.participants;

import oracle.eclipse.tools.adf.controller.ADFControllerPlugin;
import oracle.eclipse.tools.adf.controller.TaskFlowFactory;
import oracle.eclipse.tools.adf.controller.model.IMetadataResource;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.model.TaskFlowType;
import oracle.eclipse.tools.adf.controller.util.ProjectUtil;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.util.MiscUtil;

public class TaskFlowDeleteParticipant
extends DeleteParticipant {
    private IFile fileToBeDeleted = null;
    private IFile layoutFile = null;

    protected boolean initialize(Object element) {
        if (!(element instanceof IFile)) {
            return false;
        }
        this.fileToBeDeleted = (IFile)element;
        return true;
    }

    public String getName() {
        return Resources.taskFlowDeleteParticipantName;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)2);
        this.computeLayoutFile();
        sm.worked(1);
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
        if (this.layoutFile != null && this.layoutFile.exists()) {
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            deltaFactory.delete((IResource)this.layoutFile);
        }
        sm.worked(1);
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange compositeChange = new CompositeChange(Resources.taskFlowDeleteCompositeChangeText);
        DeleteResourceChange layoutChange = null;
        ADFCConfigReferenceChange referenceChange = null;
        if (this.layoutFile != null && this.layoutFile.exists()) {
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)1);
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            sm.subTask(Resources.taskFlowDeleteLayoutFileText);
            layoutChange = new DeleteResourceChange(this.layoutFile.getFullPath(), true);
            sm.worked(1);
        }
        IFile adfcConfigFile = TaskFlowFactory.getDefaultUnboundedTaskFlowFile(this.fileToBeDeleted.getProject());
        if (TaskFlowUtil.getTaskFlowType(this.fileToBeDeleted) == TaskFlowType.Unbounded && !this.fileToBeDeleted.equals((Object)adfcConfigFile)) {
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)1);
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            referenceChange = new ADFCConfigReferenceChange(Resources.taskFlowDeleteReferenceText, this.fileToBeDeleted);
            sm.subTask(Resources.taskFlowDeleteReferenceText);
            sm.worked(1);
        }
        if (layoutChange != null && referenceChange != null) {
            compositeChange.add(layoutChange);
            compositeChange.add(referenceChange);
            return compositeChange;
        }
        if (layoutChange != null) {
            return layoutChange;
        }
        if (referenceChange != null) {
            return referenceChange;
        }
        return null;
    }

    private void computeLayoutFile() {
        String uniquePath = this.fileToBeDeleted.getProjectRelativePath().toPortableString();
        String fileName = MiscUtil.createStringDigest((String)uniquePath);
        IProject project = this.fileToBeDeleted.getProject();
        IFolder layoutFolder = project.getFolder(".settings/org.eclipse.sapphire.ui.diagram/layouts");
        this.layoutFile = layoutFolder.getFile(fileName);
    }

    private static final class ADFCConfigReferenceChange
    extends Change {
        private String changeName;
        private IFile fileToBeDeleted;
        private IFile adfcConfigFile;

        public ADFCConfigReferenceChange(String name, IFile fileToBeDeleted) {
            this.changeName = name;
            this.fileToBeDeleted = fileToBeDeleted;
            IProject project = this.fileToBeDeleted.getProject();
            this.adfcConfigFile = TaskFlowFactory.getDefaultUnboundedTaskFlowFile(project);
        }

        public String getName() {
            return this.changeName;
        }

        public void initializeValidationData(IProgressMonitor pm) {
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return null;
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            IProject project = this.fileToBeDeleted.getProject();
            IContainer underlyingFolder = ProjectUtil.getWebContentFolderIResource(project);
            if (underlyingFolder != null && this.adfcConfigFile.exists()) {
                IPath webContentPath = underlyingFolder.getProjectRelativePath();
                IPath relativePath = this.fileToBeDeleted.getProjectRelativePath();
                relativePath = relativePath.makeRelativeTo(webContentPath);
                Path metaDataPath = new Path("/" + relativePath.toPortableString());
                ITaskFlow adfcConfigModel = TaskFlowFactory.createTaskFlow(this.adfcConfigFile);
                ElementList<IMetadataResource> resources = adfcConfigModel.getMetadataResources();
                for (IMetadataResource resource : resources) {
                    Path resourcePath = (Path)resource.getMetadataResource().content();
                    if (resourcePath == null || !resourcePath.equals((Object)metaDataPath)) continue;
                    resources.remove((Object)resource);
                    try {
                        adfcConfigModel.resource().save();
                    }
                    catch (ResourceStoreException e) {
                        LoggingService.logException((Plugin)ADFControllerPlugin.getDefault(), (Throwable)e);
                    }
                }
            }
            return null;
        }

        public Object getModifiedElement() {
            return this.adfcConfigFile;
        }
    }

    private static final class Resources
    extends NLS {
        public static String taskFlowDeleteParticipantName;
        public static String taskFlowDeleteLayoutFileText;
        public static String taskFlowDeleteCompositeChangeText;
        public static String taskFlowDeleteReferenceText;

        static {
            Resources.initializeMessages((String)TaskFlowDeleteParticipant.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

