/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.operations.internal;

import oracle.eclipse.tools.adf.controller.TaskFlowFactory;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.model.TaskFlowType;
import oracle.eclipse.tools.adf.controller.operations.IBoundedTaskFlowOp;
import oracle.eclipse.tools.adf.controller.operations.ICreateTaskFlowOp;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.services.EnablementService;
import org.eclipse.sapphire.services.EnablementServiceData;

public class PageFragmentEnablementService
extends EnablementService {
    private Listener PropertyDefListener;

    protected void initEnablementService() {
        IBoundedTaskFlowOp boundedOp = (IBoundedTaskFlowOp)this.context(Element.class);
        this.PropertyDefListener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                if (!((Element)PageFragmentEnablementService.this.context(Element.class)).disposed()) {
                    PageFragmentEnablementService.this.refresh();
                }
            }
        };
        ICreateTaskFlowOp op = (ICreateTaskFlowOp)boundedOp.nearest(ICreateTaskFlowOp.class);
        if (op != null) {
            boundedOp.attach(this.PropertyDefListener, "/BoundedTaskFlow/Document");
        } else {
            boundedOp.attach(this.PropertyDefListener, "/Document");
        }
    }

    protected EnablementServiceData compute() {
        IBoundedTaskFlowOp boundedOp = (IBoundedTaskFlowOp)this.context(Element.class);
        if (boundedOp.disposed()) {
            return new EnablementServiceData(false);
        }
        if (boundedOp.getDocument().content() != null) {
            TaskFlowType tfType;
            IFile templateFile;
            Path templatePath = (Path)boundedOp.getDocument().content();
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(templatePath.toPortableString());
            if (resource instanceof IFile && (templateFile = (IFile)resource).exists() && (tfType = TaskFlowUtil.getTaskFlowType(templateFile)) == TaskFlowType.Template) {
                ITaskFlow referedTaskFlow = TaskFlowFactory.createTaskFlow(templateFile);
                if (((Boolean)referedTaskFlow.isUsePageFragments().content()).booleanValue()) {
                    return new EnablementServiceData(true);
                }
                return new EnablementServiceData(false);
            }
        }
        return new EnablementServiceData(true);
    }

    public void dispose() {
        super.dispose();
        ICreateTaskFlowOp op = (ICreateTaskFlowOp)((Element)this.context(Element.class)).nearest(ICreateTaskFlowOp.class);
        if (op != null) {
            ((Element)this.context(Element.class)).detach(this.PropertyDefListener, "/BoundedTaskFlow/TemplateReference/Document");
        } else {
            ((Element)this.context(Element.class)).detach(this.PropertyDefListener, "/TemplateReference/Document");
        }
    }
}

