/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.model.internal;

import java.util.Set;
import oracle.eclipse.tools.adf.controller.model.IActivity;
import oracle.eclipse.tools.adf.controller.model.IControlFlowCase;
import oracle.eclipse.tools.adf.controller.model.IControlFlowRule;
import oracle.eclipse.tools.adf.controller.model.IRouterCase;
import oracle.eclipse.tools.adf.controller.model.IRouterComponent;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.services.PossibleValuesService;

public class RouterOutcomeService
extends PossibleValuesService {
    protected void fillPossibleValues(Set<String> values) {
        ITaskFlow tf = (ITaskFlow)this.context(ITaskFlow.class);
        ElementList<IControlFlowRule> rules = tf.getControlFlowRules();
        IActivity routerActivity = (IActivity)this.context(IActivity.class);
        for (IControlFlowRule rule : rules) {
            IActivity fromActivity = (IActivity)rule.getFromActivity().resolve();
            if (fromActivity == null || !fromActivity.equals(routerActivity)) continue;
            for (IControlFlowCase flowCase : rule.getControlFlowCases()) {
                String outcome = (String)flowCase.getFromOutcome().content();
                if (outcome == null || values.contains(outcome)) continue;
                values.add(outcome);
            }
        }
        IRouterComponent router = (IRouterComponent)this.context(IRouterComponent.class);
        for (IRouterCase routerCase : router.getCases()) {
            String outcome = (String)routerCase.getOutcome().content();
            if (outcome == null || values.contains(outcome)) continue;
            values.add(outcome);
        }
        String defaultOutcome = (String)router.getDefaultOutcome().content();
        if (defaultOutcome != null && !values.contains(defaultOutcome)) {
            values.add(defaultOutcome);
        }
    }
}

