/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.model.internal;

import java.util.Set;
import oracle.eclipse.tools.adf.controller.model.IActivity;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.model.internal.TemplateService;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.services.PossibleValuesService;

public class AvailableActivitiesService
extends PossibleValuesService {
    @Text(value="Activity ID \"{0}\" does not reference an existing activity.")
    private static LocalizableText invalidActivityIdMsg;
    private TemplateService templateService;
    private Listener templateServiceListener;

    static {
        LocalizableText.init(AvailableActivitiesService.class);
    }

    protected void init() {
        super.init();
        Element element = (Element)this.context(Element.class);
        ITaskFlow tf = (ITaskFlow)element.nearest(ITaskFlow.class);
        if (tf != null) {
            this.templateService = (TemplateService)tf.getTemplateReference().service(TemplateService.class);
            if (this.templateService != null) {
                this.templateServiceListener = new Listener(){

                    public void handle(Event event) {
                        AvailableActivitiesService.this.broadcast();
                    }
                };
                this.templateService.attach(this.templateServiceListener);
            }
        }
    }

    protected void fillPossibleValues(Set<String> values) {
        ITaskFlow tf = (ITaskFlow)this.context(ITaskFlow.class);
        if (tf != null) {
            ElementList<IActivity> activities = tf.getActivities();
            for (IActivity activity : activities) {
                if (activity.getActivityId().content() == null) continue;
                values.add((String)activity.getActivityId().content());
            }
            if (this.templateService != null) {
                Set<String> importedActivityIds = this.templateService.getImportedActivityIds();
                values.addAll(importedActivityIds);
            }
        }
    }

    public String getInvalidValueMessage(String invalidValue) {
        return invalidActivityIdMsg.format(new Object[]{invalidValue});
    }

    public void dispose() {
        super.dispose();
        if (this.templateService != null && this.templateServiceListener != null) {
            this.templateService.detach(this.templateServiceListener);
        }
    }
}

