/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.model.internal;

import oracle.eclipse.tools.adf.controller.model.IActivity;
import oracle.eclipse.tools.adf.controller.model.IParentAction;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.model.ITaskFlowReturn;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class ActivityListValidator
extends ValidationService {
    protected Status compute() {
        ITaskFlow taskFlow = (ITaskFlow)this.context(ITaskFlow.class);
        if (TaskFlowUtil.isUnboundedTaskFlow(taskFlow)) {
            ElementList<IActivity> activities = taskFlow.getActivities();
            for (IActivity activity : activities) {
                if (!(activity instanceof IParentAction) && !(activity instanceof ITaskFlowReturn)) continue;
                String msg = NLS.bind((String)Resources.invalidActivity, (Object)activity.getActivityId().content());
                return Status.createErrorStatus((String)msg);
            }
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String invalidActivity;

        static {
            Resources.initializeMessages((String)ActivityListValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

