/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.model;

import oracle.eclipse.tools.adf.controller.model.IDynamicTaskFlowReference;
import oracle.eclipse.tools.adf.controller.model.IInputParameter;
import oracle.eclipse.tools.adf.controller.model.IReturnValue;
import oracle.eclipse.tools.adf.controller.model.IStaticTaskFlowReference;
import oracle.eclipse.tools.adf.controller.model.ITaskFlowReference;
import oracle.eclipse.tools.adf.controller.model.internal.RemoteAppUrlValidator;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

public interface ITaskFlowCallComponent
extends Element {
    public static final ElementType TYPE = new ElementType(ITaskFlowCallComponent.class);
    @Type(base=ITaskFlowReference.class, possible={IStaticTaskFlowReference.class, IDynamicTaskFlowReference.class})
    @Label(standard="task flow reference")
    @Required
    @XmlElementBinding(mappings={@XmlElementBinding.Mapping(element="task-flow-reference", type=IStaticTaskFlowReference.class), @XmlElementBinding.Mapping(element="dynamic-task-flow-reference", type=IDynamicTaskFlowReference.class)})
    public static final ElementProperty PROP_TASK_FLOW_REFERENCE = new ElementProperty(TYPE, "TaskFlowReference");
    @Type(base=IInputParameter.class)
    @Label(standard="parameters")
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="input-parameter", type=IInputParameter.class)})
    @Documentation(content="A called ADF bounded task flow can accept input parameters and can pass return values to the caller upon exit. [pbr/]To pass input parameters to a bounded task flow, you must specify one or more input parameters on the task flow call activity. These specify where the calling task flow will store parameter values.[pbr/][b]Name[/b][pbr/]Name for the parameter[pbr/][b]Value[/b][pbr/]An EL expression that, when evaluated, specifies where the parameter value will be taken from within the calling task flow, for example, {pageFlowScope.callingTaskflowParm}.[pbr/][b]Pass By Value[/b][pbr/]Choose true to pass the input parameter by value instead of by reference.[pbr/]By default, input parameters are passed by reference to the called bounded task flow. Task flow call activity input parameters can be passed by value only if managed bean objects are passed, not individual values.")
    public static final ListProperty PROP_INPUT_PARAMETERS = new ListProperty(TYPE, "InputParameters");
    @XmlBinding(path="input-parameter-map")
    @Label(standard="parameter map")
    @Documentation(content="Specifies an input parameter Map used for passing parameters to a task flow.")
    public static final ValueProperty PROP_INPUT_PARAMETER_MAP = new ValueProperty(TYPE, "InputParameterMap");
    @Type(base=IReturnValue.class)
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="return-value", type=IReturnValue.class)})
    @Documentation(content="[b]Name[/b][pbr/]Name for the return value[pbr/][b]Value[/b][pbr/]An EL expression that, when evaluated, specifies where the parameter value will be taken from when it is passed back from the called task flow definition to the caller, for example, {pageFlowScope.employee}. ")
    public static final ListProperty PROP_RETURN_VALUES = new ListProperty(TYPE, "ReturnValues");
    @XmlBinding(path="before-listener")
    @Label(standard="before listener")
    @Documentation(content="An EL expression for a Java method that will be called before the ADF bounded task flow is entered, for example, #{pageFlowScope.showState}. The before-listener is used when the caller needs to know when an ADF bounded task flow is being initiated. ")
    public static final ValueProperty PROP_BEFORE_LISTENER = new ValueProperty(TYPE, "BeforeListener");
    @XmlBinding(path="after-listener")
    @Label(standard="after listener")
    @Documentation(content="An EL expression for a Java method that will be called after return from the ADF bounded task flow, for example, #{pageFlowScope.showState}. The after-listener is used when the caller needs to know when a called ADF bounded task flow exits and control flow returns to the caller.")
    public static final ValueProperty PROP_AFTER_LISTENER = new ValueProperty(TYPE, "AfterListener");
    @XmlBinding(path="remote-app-url")
    @Label(standard="remote application URL")
    @Service(impl=RemoteAppUrlValidator.class)
    @Documentation(content="An EL expression that, when evaluated, returns the remote web application\u2019s URL, for example, #{pageFlowScope.managedbean.URLmethod}.[pbr/]Specifying a value for [b]remote-app-url[/b] indicates that the called task flow definition resides in a remote web application. ")
    public static final ValueProperty PROP_REMOTE_APP_URL = new ValueProperty(TYPE, "RemoteAppUrl");

    public ElementHandle<ITaskFlowReference> getTaskFlowReference();

    public ElementList<IInputParameter> getInputParameters();

    public Value<String> getInputParameterMap();

    public void setInputParameterMap(String var1);

    public ElementList<IReturnValue> getReturnValues();

    public Value<String> getBeforeListener();

    public void setBeforeListener(String var1);

    public Value<String> getAfterListener();

    public void setAfterListener(String var1);

    public Value<String> getRemoteAppUrl();

    public void setRemoteAppUrl(String var1);
}

