/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.model;

import oracle.eclipse.tools.adf.controller.model.IFixedOutcome;
import oracle.eclipse.tools.adf.controller.model.IMethodCallOutcome;
import oracle.eclipse.tools.adf.controller.model.IMethodExpression;
import oracle.eclipse.tools.adf.controller.model.IMethodParameter;
import oracle.eclipse.tools.adf.controller.model.IToStringOutcome;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

public interface IMethodCallComponent
extends Element {
    public static final ElementType TYPE = new ElementType(IMethodCallComponent.class);
    @Type(base=IMethodExpression.class)
    @XmlBinding(path="method")
    public static final ImpliedElementProperty PROP_METHOD = new ImpliedElementProperty(TYPE, "Method");
    @Type(base=IMethodParameter.class)
    @Documentation(content="Method call parameters:[pbr/][b]Class[/b][pbr/]The Java class for the parameter, for example, java.lang.Double. [pbr/][b]Value[/b][pbr/]An EL expression indicating where the value for the parameter will be retrieved, for example, #{pageFlowScope.shoppingCart.totalPurchasePrice}. ")
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="parameter", type=IMethodParameter.class)})
    public static final ListProperty PROP_PARAMETERS = new ListProperty(TYPE, "Parameters");
    @XmlBinding(path="return-value")
    @Label(standard="return value")
    @Documentation(content="An EL expression indicating where to store the method return value, for example, #{pageFlowScope.Return}. If a return-value is not provided, it is discarded at run-time. Appropriate boxing will be performed to handle Java primitive types.")
    public static final ValueProperty PROP_RETURN_VALUE = new ValueProperty(TYPE, "ReturnValue");
    @Type(base=IMethodCallOutcome.class, possible={IFixedOutcome.class, IToStringOutcome.class})
    @Label(standard="outcome")
    @XmlElementBinding(path="outcome", mappings={@XmlElementBinding.Mapping(element="fixed-outcome", type=IFixedOutcome.class), @XmlElementBinding.Mapping(element="to-string", type=IToStringOutcome.class)})
    @Required
    @Documentation(content="If method returns without throwing an exception, the outcome will be based on one of the following: [pbr/][b]Fixed Outcome[/b][pbr/]Enter an outcome that will be returned by the method on successful completion, for example, success.[pbr/]If you specify fixed-outcome, the outcome will always return an actual String constant from metadata. If the method type is void, you must specify a fixed-outcome, not a to-string.[pbr/][b]To String[/b][pbr/]Base the outcome on a call to the toString() method on the Java object returned by the method. For example, if toString() returns A, navigation goes to control flow case A. If B, it goes to control flow case B, and so on.")
    public static final ElementProperty PROP_OUTCOME = new ElementProperty(TYPE, "Outcome");

    public IMethodExpression getMethod();

    public ElementList<IMethodParameter> getParameters();

    public Value<String> getReturnValue();

    public void setReturnValue(String var1);

    public ElementHandle<IMethodCallOutcome> getOutcome();
}

