/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.model;

import oracle.eclipse.tools.adf.controller.model.IManagedProperty;
import oracle.eclipse.tools.adf.controller.model.IUiInfoType;
import oracle.eclipse.tools.adf.controller.model.ManagedBeanScopeEnum;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

public interface IManagedBean
extends IUiInfoType {
    public static final ElementType TYPE = new ElementType(IManagedBean.class);
    @XmlBinding(path="managed-bean-name")
    @Label(standard="name")
    @Required
    @Documentation(content="Name for the managed bean, for example, managedBean1. ")
    public static final ValueProperty PROP_MANAGED_BEAN_NAME = new ValueProperty(TYPE, "ManagedBeanName");
    @Type(base=JavaTypeName.class)
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS})
    @Reference(target=JavaType.class)
    @XmlBinding(path="managed-bean-class")
    @Label(standard="class")
    @MustExist
    @Required
    @Documentation(content="Class for the managed bean, for example, java.lang.String.")
    public static final ValueProperty PROP_MANAGED_BEAN_CLASS = new ValueProperty(TYPE, "ManagedBeanClass");
    @Type(base=ManagedBeanScopeEnum.class)
    @Label(standard="scope")
    @XmlBinding(path="managed-bean-scope")
    @Required
    @DefaultValue(text="request")
    @Documentation(content="Scope for the managed bean: [ul][li][b]request[/b] - the duration between when an HTTP request is made until a response is sent back to the client.[/li][li][b]view[/b] - The object is available until the view port ID for the current view activity changes. You can use View scope to hold values for a given page. While request scope can be used to store a value needed from one page to the next, anything stored in view scope will be lost once the view ID changes.[/li][li][b]pageFlow[/b] - the duration between when the current task flow was called and when it finishes executing.[/li][li][b]session[/b] - the duration of the current client session.[/li][li][b]application[/b] - the duration of the application.[/li][li][b]none[/b] - the managed scope does not live within any particular scope, but is instead instantiated each time it is referenced.[/li][/ul]")
    public static final ValueProperty PROP_MANAGED_BEAN_SCOPE = new ValueProperty(TYPE, "ManagedBeanScope");
    @Type(base=IManagedProperty.class)
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="managed-property", type=IManagedProperty.class)})
    public static final ListProperty PROP_MANAGED_PROPERTIES = new ListProperty(TYPE, "ManagedProperties");

    public Value<String> getManagedBeanName();

    public void setManagedBeanName(String var1);

    public ReferenceValue<JavaTypeName, JavaType> getManagedBeanClass();

    public void setManagedBeanClass(String var1);

    public void setManagedBeanClass(JavaTypeName var1);

    public Value<ManagedBeanScopeEnum> getManagedBeanScope();

    public void setManagedBeanScope(String var1);

    public void setManagedBeanScope(ManagedBeanScopeEnum var1);

    public ElementList<IManagedProperty> getManagedProperties();
}

