/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.webapp.javasrc;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.util.FileUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.common.services.Activator;
import oracle.eclipse.tools.webtier.common.services.webapp.javasrc.JDTUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

public class JavaSrcUriResolver {
    private final List<? extends IResource> _mPackageRoots;
    private final IProject _project;

    public JavaSrcUriResolver(IProject project) {
        this._project = project;
        this._mPackageRoots = JDTUtil.getSourceFolders(this._project);
    }

    public Set<IPath> getResources(String fileExtension) {
        HashSet<IPath> result = new HashSet<IPath>();
        for (IResource iResource : this._mPackageRoots) {
            IFolder packageFolder;
            if (iResource.getType() != 2 || !(packageFolder = (IFolder)iResource).isAccessible()) continue;
            try {
                List files = FileUtil.getFiles((IContainer)packageFolder, (String)fileExtension, (boolean)true);
                for (IFile propFile : files) {
                    if (!propFile.isAccessible()) continue;
                    IPath relativePath = FileUtil.getRelative((IContainer)((IContainer)iResource), (IFile)propFile);
                    result.add(relativePath);
                }
            }
            catch (CoreException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
            }
        }
        return result;
    }
}

