/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.webapp.javasrc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.common.services.Activator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JDTUtil {
    public static List<? extends IResource> getSourceFolders(IProject project) {
        List list = Collections.emptyList();
        IJavaProject jpr = JavaCore.create((IProject)project);
        if (jpr != null && jpr.getProject().isAccessible()) {
            try {
                IPackageFragmentRoot[] roots = jpr.getAllPackageFragmentRoots();
                list = new ArrayList();
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (root.getKind() == 1 && root.getResource().getProject().equals((Object)jpr.getProject())) {
                        list.add(root.getResource());
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)((Object)e));
            }
        }
        return list;
    }

    public static IFile findResource(IProject project, String packageName, String fileName) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IPackageFragmentRoot[] roots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getAllPackageFragmentRoots();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                IPackageFragment packageFragment = root.getPackageFragment(packageName);
                if (packageFragment != null && packageFragment.exists()) {
                    Object resObject;
                    if (!packageFragment.isDefaultPackage()) {
                        Object[] nonJavaResources;
                        Object[] objectArray = nonJavaResources = packageFragment.getNonJavaResources();
                        int n3 = nonJavaResources.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            resObject = objectArray[n4];
                            if (resObject instanceof IFile && ((IFile)resObject).getName().equals(fileName)) {
                                return (IFile)resObject;
                            }
                            if (resObject instanceof IJarEntryResource) {
                                IResource res;
                                IJarEntryResource jarEntry = (IJarEntryResource)resObject;
                                if (fileName != null && jarEntry.isFile() && fileName.equals(jarEntry.getName()) && (res = packageFragment.getResource()) != null && res.getType() == 1) {
                                    return (IFile)res;
                                }
                            }
                            ++n4;
                        }
                    } else {
                        IResource underlyingResource = packageFragment.getUnderlyingResource();
                        if (underlyingResource instanceof IContainer && (resObject = ((IContainer)underlyingResource).findMember(fileName)) != null && resObject.exists() && resObject.getType() == 1) {
                            return (IFile)resObject;
                        }
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)((Object)e));
        }
        return null;
    }

    public static List<IPackageFragmentRoot> getJarRoots(IProject project, int containerKind) {
        List<IPackageFragmentRoot> uris = Collections.emptyList();
        IJavaProject jpr = JavaCore.create((IProject)project);
        if (jpr != null && jpr.getProject().isAccessible()) {
            try {
                IPackageFragmentRoot[] roots = jpr.getAllPackageFragmentRoots();
                uris = new ArrayList<IPackageFragmentRoot>();
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathContainer container;
                    IClasspathEntry entry;
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (root.getKind() == 2 && (entry = root.getRawClasspathEntry()) != null && (entry.getEntryKind() == 5 || entry.getEntryKind() == 1) && (container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)jpr)) != null && (container.getKind() | containerKind) == 1) {
                        uris.add(root);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)((Object)e));
            }
        }
        return uris;
    }
}

