/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.webapp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.Plugin;

public class WebAppCopier {
    private File mSourceFolder;
    private JarInputStream mJarInput;
    private File mTarget;
    private List<File> mStack = new LinkedList<File>();
    private boolean mOverwrite;
    private Map<File, File> mExistingFiles;
    private Pattern[] mExcludePatterns;
    private static final String PLACE_HOLDER_FILE_NAME = "_placeholder";

    public WebAppCopier(File src, File target) throws IOException {
        this(src, target, true);
    }

    public WebAppCopier(File src, File target, boolean overwrite) throws IOException {
        this(src, target, overwrite, null);
    }

    public WebAppCopier(File src, File target, boolean overwrite, Pattern[] excludePatterns) throws IOException {
        assert (target.exists() && target.isDirectory());
        assert (src.exists());
        if (!src.exists() || src.isDirectory()) {
            this.mSourceFolder = src;
            File[] files = src.listFiles();
            if (files != null) {
                this.push(files);
            }
        } else {
            this.mJarInput = new JarInputStream(WebAppCopier.getFileUrl(src).openStream());
        }
        this.mTarget = target;
        this.mOverwrite = overwrite;
        this.mExcludePatterns = excludePatterns;
    }

    public Map<File, File> getExistingFiles() {
        return this.mExistingFiles;
    }

    private void push(File[] files) {
        assert (this.mJarInput == null);
        int i = 0;
        while (i < files.length) {
            this.mStack.add(files[i]);
            ++i;
        }
    }

    private Object pop() {
        assert (this.mJarInput == null);
        if (this.mStack.size() == 0) {
            return null;
        }
        return this.mStack.remove(0);
    }

    protected void cleanUp() {
        try {
            if (this.mJarInput != null) {
                this.mJarInput.close();
            }
        }
        catch (IOException e) {
            LoggingService.logError((Plugin)Activator.getDefault(), (String)e.getLocalizedMessage());
        }
    }

    protected void createDir(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Cannot create directory:" + dir.getPath());
        }
    }

    protected Object getNextEntry() throws IOException {
        if (this.mJarInput != null) {
            return this.mJarInput.getNextJarEntry();
        }
        return this.pop();
    }

    protected boolean isDirectory(Object entry) {
        if (this.mJarInput != null) {
            JarEntry jarEntry = (JarEntry)entry;
            return jarEntry.isDirectory();
        }
        File file = (File)entry;
        return file.isDirectory();
    }

    protected void visitFSDirectory(File sourceDir) throws IOException {
        File[] files = sourceDir.listFiles();
        this.push(files);
        String sourcePath = sourceDir.getPath();
        String sourceRootPath = this.mSourceFolder.getPath();
        File dir = new File(this.mTarget, sourcePath.substring(sourceRootPath.length()));
        this.createDir(dir);
    }

    protected void visitFSFile(File source) throws FileNotFoundException, IOException {
        String sourceRootPath;
        String sourcePath = source.getPath();
        File file = new File(this.mTarget, sourcePath.substring((sourceRootPath = this.mSourceFolder.getPath()).length()));
        if (this.excludeFile(file.getName())) {
            return;
        }
        if (file.exists() && !this.mOverwrite) {
            if (this.mExistingFiles == null) {
                this.mExistingFiles = new HashMap<File, File>();
            }
            this.mExistingFiles.put(file, source);
        } else {
            this.copyToFile(file, new FileInputStream(source));
        }
    }

    protected void visitWarDirectory(JarEntry jarEntry) throws IOException {
        File folder = new File(this.mTarget, jarEntry.getName());
        this.createDir(folder);
    }

    protected void visitWarFile(JarEntry entry) throws IOException {
        File file = new File(this.mTarget, entry.getName());
        if (this.excludeFile(file.getName())) {
            return;
        }
        this.copyToFile(file, this.mJarInput);
    }

    protected void copyToFile(File destFile, InputStream input) throws IOException {
        File parent = destFile.getParentFile();
        this.createDir(parent);
        try (FileOutputStream output = null;){
            output = new FileOutputStream(destFile);
            this.copyStreams(input, output);
        }
    }

    protected boolean excludeFile(String filename) {
        if (filename.equals(PLACE_HOLDER_FILE_NAME)) {
            return true;
        }
        if (this.mExcludePatterns != null) {
            int i = 0;
            int n = this.mExcludePatterns.length;
            while (i < n) {
                Matcher matcher = this.mExcludePatterns[i].matcher(filename);
                if (matcher.matches()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void copyStreams(InputStream src, OutputStream dest) throws IOException {
        BufferedInputStream bfin = null;
        BufferedOutputStream bfout = null;
        try {
            int c;
            bfin = new BufferedInputStream(src, 8192);
            bfout = new BufferedOutputStream(dest, 8192);
            while ((c = bfin.read()) >= 0) {
                bfout.write(c);
            }
        }
        finally {
            if (bfout != null) {
                bfout.flush();
            }
        }
    }

    public final void copy() throws IOException {
        this.createDir(this.mTarget);
        try {
            Object entry;
            while ((entry = this.getNextEntry()) != null) {
                if (this.isDirectory(entry)) {
                    this.visitDirectory(entry);
                    continue;
                }
                this.visitFile(entry);
            }
        }
        finally {
            this.cleanUp();
        }
    }

    private void visitFile(Object entry) throws IOException {
        if (this.mJarInput == null) {
            this.visitFSFile((File)entry);
        } else {
            this.visitWarFile((JarEntry)entry);
        }
    }

    private void visitDirectory(Object entry) throws IOException {
        if (this.mJarInput == null) {
            this.visitFSDirectory((File)entry);
        } else {
            this.visitWarDirectory((JarEntry)entry);
        }
    }

    public static URL getFileUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

