/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.webapp;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.application.common.services.util.WorkspaceUtil;
import oracle.eclipse.tools.application.common.services.webapp.javasrc.ParentAndResource;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.project.EnvFileListener;
import oracle.eclipse.tools.common.services.project.FileChangeNotifier;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.common.services.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public abstract class Localizer {
    protected final IProject _project;
    private final ChangeNotifierControl _notifierControl;
    private FileChangeNotifier _changeNotifier;
    private final AtomicBoolean _isDisposed = new AtomicBoolean(false);
    private Exception disposedTrace;
    protected static final String PROPERTIES_EXTENSION = "properties";
    protected static final String CLASS_EXTENSION = "class";
    protected static final Collection<String> STANDARD_EXTENSIONS;

    static {
        HashSet extensions = new HashSet();
        Collections.addAll(extensions, PROPERTIES_EXTENSION, CLASS_EXTENSION);
        STANDARD_EXTENSIONS = Collections.unmodifiableSet(extensions);
    }

    public Localizer(Project project) {
        this(project.getEclipseProject(), new DefaultChangeNotifierControl(project));
    }

    public Localizer(IProject project, ChangeNotifierControl notifierControl) {
        this._project = project;
        this._notifierControl = notifierControl;
        this._changeNotifier = new MyFileChangeNotifier(this._notifierControl);
    }

    public void addListener(EnvFileListener listener) {
        this.getChangeNotifier().addListener(listener);
    }

    public void removeListener(EnvFileListener listener) {
        this.getChangeNotifier().removeListener(listener);
    }

    public void dispose() {
        if (this._isDisposed.compareAndSet(false, true)) {
            this._changeNotifier.dispose();
            this.disposedTrace = new Exception("This is who disposed me");
        }
    }

    protected void assertNotDisposed() {
        if (this._isDisposed.get()) {
            Activator.log("Using a disposed localizer", this.disposedTrace);
            assert (false);
        }
    }

    public IBundleResource getResourceBundle(String baseName, Locale locale) {
        this.assertNotDisposed();
        if (locale == null) {
            throw new IllegalArgumentException("Locale must never be null");
        }
        IBundleResource bundle = this.createBundleResource(baseName, locale);
        if (bundle != null) {
            this.trackBundleFiles(baseName);
        }
        return bundle;
    }

    public Collection<URL> getBundleUrls(String baseName) {
        return this.getBundleUrls(baseName, STANDARD_EXTENSIONS);
    }

    private Collection<URL> getBundleUrls(String baseName, Collection<String> extensions) {
        this.assertNotDisposed();
        String safeBaseName = baseName;
        if (safeBaseName == null && (safeBaseName = this.getDefaultBaseName()) == null) {
            return Collections.EMPTY_LIST;
        }
        Collection<URL> file = this.computeBundleUrls(safeBaseName, extensions);
        return file;
    }

    protected void resourceFilesChanged() {
    }

    protected void resourceFileModified(String baseName) {
    }

    private void trackBundleFiles(String baseName) {
        assert (baseName != null);
        Collection<URL> urls = this.getBundleUrls(baseName);
        for (URL url : urls) {
            IFile file = WorkspaceUtil.convertToIFile((IProject)this._project.getProject(), (URL)url);
            if (file == null) continue;
            this._changeNotifier.track(file);
        }
        this._notifierControl.installNotifier(this._changeNotifier);
    }

    public abstract String getDefaultBaseName();

    public abstract Collection<String> getBaseNames();

    public abstract Set<String> getAllBaseNames();

    public abstract Set<String> getAllBaseNames(boolean var1);

    public abstract Set<ParentAndResource> getAllBaseNamesWithParents(boolean var1);

    protected abstract Collection<URL> computeBundleUrls(String var1, Collection<String> var2);

    public abstract IBundleResource resolveBundle(IDocument var1, int var2, String var3, List<Locale> var4);

    public abstract Locale resolveLocale(List<Locale> var1);

    public abstract Collection<Locale> getAvailableLocales(String var1);

    protected abstract IBundleResource createBundleResource(String var1, Locale var2);

    protected final FileChangeNotifier getChangeNotifier() {
        return this._changeNotifier;
    }

    protected static final class BundleHashKey {
        private final String mBaseName;
        private final Locale mLocale;
        private final int mHash;

        public BundleHashKey(String baseName, Locale locale) {
            this.mBaseName = baseName;
            this.mLocale = locale;
            int familtyHash = locale != null ? locale.hashCode() : 0;
            this.mHash = familtyHash ^ baseName.hashCode();
        }

        public int hashCode() {
            return this.mHash;
        }

        public boolean equals(Object other) {
            if (other instanceof BundleHashKey) {
                BundleHashKey bhk = (BundleHashKey)other;
                if (!this.mBaseName.equals(bhk.mBaseName)) {
                    return false;
                }
                if (this.mLocale == null) {
                    return bhk.mLocale == null;
                }
                return this.mLocale.equals(bhk.mLocale);
            }
            return false;
        }
    }

    public static abstract class ChangeNotifierControl {
        protected abstract void installNotifier(FileChangeNotifier var1);

        protected abstract void uninstallNotifier(FileChangeNotifier var1);
    }

    private static class DefaultChangeNotifierControl
    extends ChangeNotifierControl {
        private final Project _project;

        public DefaultChangeNotifierControl(Project project) {
            this._project = project;
        }

        @Override
        protected void installNotifier(FileChangeNotifier notifier) {
            this._project.addResourceChangeListener((EnvFileListener)notifier);
        }

        @Override
        protected void uninstallNotifier(FileChangeNotifier notifier) {
            this._project.removeResourceChangeListener((EnvFileListener)notifier);
        }
    }

    private static final class MyFileChangeNotifier
    extends FileChangeNotifier {
        private final ChangeNotifierControl _notifierControl;

        private MyFileChangeNotifier(ChangeNotifierControl notifierControl) {
            this._notifierControl = notifierControl;
        }

        protected void doListenerListNoLongerEmpty() {
        }

        protected void doListenerListIsEmpty() {
        }

        public void dispose() {
            this._notifierControl.uninstallNotifier(this);
        }
    }
}

