/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.util;

import oracle.eclipse.tools.application.common.services.appservices.IWebRootResolver;
import oracle.eclipse.tools.common.services.project.Project;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.web.WebApp;

public class WebAppUtil {
    public static WebAppType getWebAppType(IProject project) throws WebAppNotFoundException {
        IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)project);
        if (modelProvider == null) {
            throw new WebAppNotFoundException("Unable to determine if \"" + project.getName() + "\" is a Java EE or J2EE project. Cannot get model provider for project \"" + project.getName() + "\"");
        }
        Object webAppObj = modelProvider.getModelObject();
        if (webAppObj == null) {
            throw new WebAppNotFoundException("Unable to determine if \"" + project.getName() + "\" is a Java EE or J2EE project. Cannot get web-app from project \"" + project.getName() + "\"");
        }
        if (webAppObj instanceof WebApp) {
            return WebAppType.JAVAEE;
        }
        if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            return WebAppType.J2EE;
        }
        return WebAppType.UNKNOWN;
    }

    public static boolean isInsideWebInf(IPath filePath, IProject project) {
        IResource resourceForPath;
        IWebRootResolver appService;
        Project oepeProj = (Project)project.getAdapter(Project.class);
        if (oepeProj != null && (appService = (IWebRootResolver)oepeProj.getAppService(IWebRootResolver.class)) != null && (resourceForPath = appService.getResourceForPath("/WEB-INF")) != null && resourceForPath.exists()) {
            return resourceForPath.getLocation().isPrefixOf(filePath);
        }
        return false;
    }

    public static class WebAppNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public WebAppNotFoundException(String message) {
            super(message);
        }
    }

    public static enum WebAppType {
        JAVAEE,
        J2EE,
        UNKNOWN;

    }
}

