/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.util;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.eclipse.tools.common.operations.OperationUtil;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.common.services.Activator;
import oracle.eclipse.tools.webtier.common.services.webapp.WebAppCopier;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryFacetUninstallConfig;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.osgi.framework.Bundle;

public class FacetUtil {
    public static final String DISABLE_FACET_DIALOGS_PROPERTY = "oracle.eclipse.tools.webtier.facet.dialog.disable";

    public static void uninstallLibraries(LibraryFacetUninstallConfig config, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)1);
        try {
            config.getLibraryUninstallDelegate().execute(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    public static void refreshProject(IProject project) {
        IPath projectLocation = project.getLocation();
        IContainer projectResource = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(projectLocation);
        try {
            projectResource.refreshLocal(2, null);
        }
        catch (CoreException e) {
            LoggingService.logError((Plugin)Activator.getDefault(), (String)e.getLocalizedMessage());
        }
    }

    public static IPath getWebContentPath(IProject project) {
        return FacetUtil.resolveConfigPath(project, "");
    }

    public static IPath getWebInfPath(IProject project) {
        return FacetUtil.resolveConfigPath(project, "WEB-INF");
    }

    public static File getWebContentFolder(IProject project) {
        return FacetUtil.getWebContentPath(project).toFile();
    }

    public static File getWebInfFolder(IProject project) {
        return FacetUtil.getWebInfPath(project).toFile();
    }

    public static File getWebProjectFolder(IProject project) {
        return new File(project.getLocationURI());
    }

    public static File getWebProjectSrcFolder(IProject project) throws CoreException {
        return new File(OperationUtil.getSrcFolderResource((IProject)project).getLocationURI());
    }

    public static File getBundleFolder(Plugin plugin, String folder) throws IOException, URISyntaxException {
        File folderDirectory;
        Bundle bundle = plugin.getBundle();
        URL bundleUrl = bundle.getEntry(folder);
        URL fileUrl = FileLocator.toFileURL((URL)bundleUrl);
        try {
            folderDirectory = new File(fileUrl.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            folderDirectory = new File(fileUrl.getPath());
        }
        return folderDirectory;
    }

    public static File getFileFromPlugin(Plugin plugin, String relativePathForFile) throws IOException, URISyntaxException {
        Bundle bundle = plugin.getBundle();
        URL bundleUrl = bundle.getEntry(relativePathForFile);
        URL fileUrl = FileLocator.toFileURL((URL)bundleUrl);
        File file = new File(fileUrl.toURI());
        return file;
    }

    public static IPath resolveConfigPath(IProject project, String jsfConfigPath) {
        return ComponentCore.createComponent((IProject)project).getRootFolder().getUnderlyingFolder().getRawLocation().append((IPath)new Path(jsfConfigPath));
    }

    public static final Map<File, File> copyFiles(File srcFolder, File targetFolder) throws IOException {
        return FacetUtil.copyFiles(srcFolder, targetFolder, null, true, null);
    }

    public static final Map<File, File> copyFiles(File srcFolder, File targetFolder, Map<File, File> map, boolean overwrite, Pattern[] excludePatterns) throws IOException {
        WebAppCopier copier = new WebAppCopier(srcFolder, targetFolder, overwrite, excludePatterns);
        copier.copy();
        Map<File, File> existingFiles = copier.getExistingFiles();
        if (existingFiles != null && existingFiles.size() > 0) {
            if (map == null) {
                return existingFiles;
            }
            map.putAll(existingFiles);
            return map;
        }
        return map;
    }

    public static String getWebContentFolderName(IProject project) throws CoreException {
        return FacetUtil.getWebContentFolderIResource(project).getName();
    }

    public static IContainer getWebContentFolderIResource(IProject project) throws CoreException {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            throw FacetUtil.cannotResolveProjectPathException();
        }
        IVirtualFolder rootFolder = component.getRootFolder();
        if (rootFolder == null) {
            throw FacetUtil.cannotResolveProjectPathException();
        }
        IContainer underlyingFolder = rootFolder.getUnderlyingFolder();
        if (underlyingFolder == null) {
            throw FacetUtil.cannotResolveProjectPathException();
        }
        return underlyingFolder;
    }

    public static boolean areDialogsDisabled() {
        return Boolean.valueOf(System.getProperty(DISABLE_FACET_DIALOGS_PROPERTY, "false"));
    }

    public static boolean areDialogsEnabled() {
        return !FacetUtil.areDialogsDisabled();
    }

    public static void deleteIFiles(IProject project, IProjectFacetVersion fv, IProgressMonitor monitor, Iterable files) {
        for (Object selectedIfile : files) {
            if (!(selectedIfile instanceof IFile)) {
                throw new IllegalArgumentException("Expected argument of type IFile");
            }
            if (!((IFile)selectedIfile).isAccessible()) continue;
            try {
                ((IFile)selectedIfile).delete(true, monitor);
            }
            catch (CoreException e) {
                LoggingService.logError((String)"oracle.eclipse.tools.webtier.common.services", (String)e.getLocalizedMessage());
            }
        }
        FacetUtil.deleteEmptyDirs(project);
    }

    public static void deleteIFiles(IProject project, IProjectFacetVersion fv, IProgressMonitor monitor, Object[] files) {
        FacetUtil.deleteIFiles(project, fv, monitor, Arrays.asList(files));
    }

    private static void deleteEmptyDirs(IProject webProject) {
        String webContentFolder = FacetUtil.getWebContentFolder(webProject).getAbsolutePath();
        FacetUtil.deleteEmptyDir(String.valueOf(webContentFolder) + "/" + "WEB-INF/config");
        FacetUtil.deleteEmptyDir(String.valueOf(webContentFolder) + "/" + "pages");
    }

    private static void deleteEmptyDir(String dirName) {
        File dir = new File(dirName);
        if (dir.exists() && FacetUtil.dirHasNoFiles(dir)) {
            dir.delete();
        }
    }

    private static boolean dirHasNoFiles(File configDir) {
        return configDir.list().length == 0;
    }

    private static CoreException cannotResolveProjectPathException() {
        return new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.webtier.common.services", "Cannot resolve project config path"));
    }
}

