/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.jsp.include.model;

import oracle.eclipse.tools.webtier.common.services.jsp.include.model.IUpdateEvent;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedModelManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

class UpdateEvent
implements IUpdateEvent {
    private final Object _waitObject = new Object();
    private final IProject _project;
    private final int _timeStamp;
    private volatile boolean _wasSignaled = false;

    public UpdateEvent(IProject project, int timeStamp) {
        this._project = project;
        this._timeStamp = timeStamp;
    }

    @Override
    public IProject getProject() {
        return this._project;
    }

    @Override
    public int getTimeStamp() {
        return this._timeStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForSignal(int timeout) throws InterruptedException {
        ISchedulingRule rule;
        Job currentJob = Job.getJobManager().currentJob();
        if (currentJob != null && (rule = currentJob.getRule()) != null && rule.isConflicting((ISchedulingRule)this._project)) {
            throw new IllegalStateException("Cannot block on event while holding a rule that conflicts with the update job");
        }
        if (this._wasSignaled) {
            return true;
        }
        Object object = this._waitObject;
        synchronized (object) {
            if (!this._wasSignaled) {
                Job[] updateJobs = Job.getJobManager().find(MergedModelManager.UPDATE_JOB_FAMILY);
                if (updateJobs.length > 0) {
                    this._waitObject.wait(timeout);
                }
                return this._wasSignaled;
            }
        }
        return this._wasSignaled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signal() {
        Object object = this._waitObject;
        synchronized (object) {
            this._wasSignaled = true;
            this._waitObject.notifyAll();
        }
    }

    @Override
    public boolean wasSignaled() {
        return this._wasSignaled;
    }

    @Override
    public boolean isSatisfied(int timeStamp) {
        return this._timeStamp == timeStamp;
    }
}

