/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.jsp.include.model;

import oracle.eclipse.tools.application.common.services.include.model.IMergedModelNode;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.IncludeContext;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedModelTypedRegion;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class MergedModelNode
implements IMergedModelNode,
INodeAdapter {
    private IDOMNode _node;
    private IDocumentPartitioner _mergedDocPartitioner;

    MergedModelNode(IDOMNode node) {
        this._node = node;
        IStructuredDocument structuredDoc = node.getStructuredDocument();
        if (structuredDoc instanceof IDocumentExtension3) {
            IDocumentExtension3 doc = (IDocumentExtension3)structuredDoc;
            this._mergedDocPartitioner = doc.getDocumentPartitioner("oracle.eclipse.tools.webtier.common.services.jsp.include.model.MERGED_PARTITIONING");
        }
    }

    public boolean isAdapterForType(Object type) {
        return IMergedModelNode.class.equals(type);
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }

    public boolean isExternal() {
        MergedModelTypedRegion region = this.getTypedRegion();
        return region != null && "__include" == region.getType();
    }

    public boolean isRuntimeIncluded() {
        IncludeContext ic = this.getIncludeContext();
        if (ic != null) {
            return ic.isRuntimeIncluded();
        }
        return false;
    }

    public ResourceLocation getResourceLocation() {
        if (this._node instanceof IDOMAttr) {
            IDOMAttr domAttr = (IDOMAttr)this._node;
            int offset = domAttr.getValueRegionStartOffset();
            String attrText = domAttr.getValueRegionText();
            int length = attrText == null ? 0 : attrText.length();
            return this.getResourceLocation(offset, length);
        }
        int offset = this._node.getStartOffset();
        int end = this._node.getEndOffset();
        int length = 0;
        if (offset >= 0 && end >= offset) {
            length = end - offset;
        }
        return this.getResourceLocation(offset, length);
    }

    public ResourceLocation getResourceLocation(int length) {
        return this.getResourceLocation(this._node.getStartOffset(), length);
    }

    public ResourceLocation getResourceLocation(int offset, int length) {
        IncludeContext startIncludeContext;
        int docLength = this._node.getStructuredDocument().getLength();
        if (offset < 0 || offset >= docLength) {
            LoggingService.logDebug((String)"oracle.eclipse.tools.webtier.common.services", (String)("Requested ResourceLocation with invalid offset, " + offset));
            return null;
        }
        if (length <= 0) {
            LoggingService.logDebug((String)"oracle.eclipse.tools.webtier.common.services", (String)("Requested ResourceLocation with invalid length, " + length));
            return null;
        }
        int normalizedLength = length;
        if (offset + length > docLength) {
            normalizedLength = docLength - offset;
        }
        if ((startIncludeContext = this.getIncludeContext(offset)) == null) {
            LoggingService.logDebug((String)"oracle.eclipse.tools.webtier.common.services", (String)"Could not get region to compute ResourceLocation.");
            return null;
        }
        IPath path = startIncludeContext.getPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFile(path);
        if (file != null && file.exists()) {
            int resourceOffset = this.translateOffset(offset);
            int end = offset + length;
            MergedModelTypedRegion mmtr = this.getTypedRegion(offset);
            if (!mmtr.equals((Object)this.getTypedRegion(end))) {
                int normalizedEndOffset = resourceOffset;
                IPath startRegionPath = startIncludeContext.getPath();
                IPath endRegionPath = null;
                IncludeContext endIncludeContext = this.getIncludeContext(end);
                if (endIncludeContext != null) {
                    endRegionPath = endIncludeContext.getPath();
                }
                if ((normalizedEndOffset = startRegionPath.equals((Object)endRegionPath) ? this.translateOffset(end) : mmtr.getContentOffset() + mmtr.getLength()) > resourceOffset) {
                    normalizedLength = normalizedEndOffset - resourceOffset;
                }
            }
            return new ResourceLocation((IResource)file, new Range((long)resourceOffset, (long)normalizedLength));
        }
        String fileName = file != null ? file.getFullPath().toString() : "null";
        LoggingService.logDebug((String)"oracle.eclipse.tools.webtier.common.services", (String)("Could not find file, " + fileName));
        return null;
    }

    private int translateOffset(int offset) {
        MergedModelTypedRegion currentRegion = this.getTypedRegion(offset);
        if (currentRegion == null) {
            return 0;
        }
        int precedingLength = offset - currentRegion.getOffset();
        int includedRegionsLength = 0;
        int includeNodesLength = 0;
        IncludeContext currentIncludeContext = currentRegion.getIncludeContext();
        int currentDepth = currentIncludeContext.getNestedDepth();
        MergedModelTypedRegion region = this.getPrecedingRegion(currentRegion, currentIncludeContext, currentDepth);
        while (region != null) {
            precedingLength += region.getLength();
            int depth = region.getIncludeContext().getNestedDepth();
            MergedModelTypedRegion preceding = this.getPrecedingRegion(region, currentIncludeContext, currentDepth);
            if (currentDepth < depth) {
                Region incElemRegion;
                includedRegionsLength += region.getLength();
                IncludeContext child = this.getChildLevelContext(currentIncludeContext, region);
                IncludeContext precedingChild = this.getChildLevelContext(currentIncludeContext, preceding);
                if (child != null && !child.equals(precedingChild) && region.getContentOffset() == 0 && (incElemRegion = child.getIncludeElemRegion()) != null) {
                    includeNodesLength += incElemRegion.getLength();
                }
            }
            region = preceding;
        }
        return precedingLength + includeNodesLength - includedRegionsLength;
    }

    private MergedModelTypedRegion getPrecedingRegion(MergedModelTypedRegion currentRegion, IncludeContext ic, int depthLimit) {
        int depth;
        MergedModelTypedRegion precedingRegion;
        int offset;
        if (this._mergedDocPartitioner != null && currentRegion != null && (offset = currentRegion.getOffset()) > 0 && (precedingRegion = (MergedModelTypedRegion)this._mergedDocPartitioner.getPartition(offset - 1)) != null && depthLimit <= (depth = precedingRegion.getIncludeContext().getNestedDepth()) && this.partOfIncludingContent(ic, precedingRegion)) {
            return precedingRegion;
        }
        return null;
    }

    private boolean partOfIncludingContent(IncludeContext ic, MergedModelTypedRegion region) {
        if (ic == null || region == null) {
            return false;
        }
        IncludeContext current = region.getIncludeContext();
        while (current != null) {
            if (ic.equals(current)) {
                return true;
            }
            current = current.getParentContext();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private IncludeContext getChildLevelContext(IncludeContext ic, MergedModelTypedRegion region) {
        if (ic == null || region == null) {
            return null;
        }
        child = region.getIncludeContext();
        if (child == null || !ic.equals(child)) ** GOTO lbl9
        return null;
lbl-1000:
        // 1 sources

        {
            if (ic.equals(child.getParentContext())) {
                return child;
            }
            child = child.getParentContext();
lbl9:
            // 2 sources

            ** while (child != null)
        }
lbl10:
        // 1 sources

        return null;
    }

    private MergedModelTypedRegion getTypedRegion() {
        return this.getTypedRegion(this._node.getStartOffset());
    }

    private MergedModelTypedRegion getTypedRegion(int offset) {
        if (this._mergedDocPartitioner == null) {
            return null;
        }
        int normalizedOffset = offset;
        int length = this._node.getStructuredDocument().getLength();
        if (normalizedOffset > 0 && normalizedOffset >= length) {
            normalizedOffset = length - 1;
        }
        if (normalizedOffset < 0) {
            LoggingService.logDebug((String)"oracle.eclipse.tools.webtier.common.services", (String)("Requested partition with negative offset, " + normalizedOffset));
            normalizedOffset = 0;
        }
        return (MergedModelTypedRegion)this._mergedDocPartitioner.getPartition(normalizedOffset);
    }

    private IncludeContext getIncludeContext() {
        return this.getIncludeContext(this._node.getStartOffset());
    }

    private IncludeContext getIncludeContext(int offset) {
        MergedModelTypedRegion region = this.getTypedRegion(offset);
        if (region != null) {
            return region.getIncludeContext();
        }
        return null;
    }

    public IFile getBaseSourceFile() {
        IncludeContext ic = this.getIncludeContext();
        if (ic != null) {
            return ic.getBaseSourceFile();
        }
        return null;
    }

    public ResourceLocation getLocationInBaseSourceFile() {
        IncludeContext ic = this.getIncludeContext();
        if (ic == null) {
            return null;
        }
        if (ic.getParentContext() == null) {
            return this.getResourceLocation();
        }
        Region region = ic.getBaseSourceFileIncludeElemRegion();
        if (region == null) {
            return new ResourceLocation((IResource)ic.getBaseSourceFile(), null);
        }
        Range range = new Range((long)region.getOffset(), (long)region.getLength());
        return new ResourceLocation((IResource)ic.getBaseSourceFile(), range);
    }
}

