/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.jsp.include.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IModelProvider;
import oracle.eclipse.tools.common.util.LRUCache;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.common.services.TraceOptions;
import oracle.eclipse.tools.webtier.common.services.jsp.include.InclusionCacheManager;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.IMergedModel;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.IUpdateEvent;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedModel;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedModelException;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.UpdateEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class MergedModelManager {
    private static final MergedModelManager INSTANCE = new MergedModelManager();
    private final MergedModelResourceListener _resourceListener = new MergedModelResourceListener();
    private final Map<IProject, Map<String, SharedModel>> _mergedModelCache = new HashMap<IProject, Map<String, SharedModel>>();
    private static final int DEFAULT_CACHE_SIZE = 5;
    private static final String KEY_MERGED_MODEL_CACHE_SIZE = "oracle.eclipse.tools.webtier.common.services.jsp.include.model.mergedmodel.lrucache.size";
    private final int _cacheSize;
    private final Map<String, IMergedModel> _reserveCache;
    private final Map<IProject, UpdateJobManager> _updateJobMgrs = new HashMap<IProject, UpdateJobManager>();
    private static final String KEY_MERGED_MODEL_UPDATE_TIMEOUT = "oracle.eclipse.tools.webtier.common.services.jsp.include.model.mergedmodel.update.timeout";
    private static final int DEFAULT_TIMEOUT = 60000;
    public static final int MERGED_MODEL_UPDATE_TIMEOUT = Integer.getInteger("oracle.eclipse.tools.webtier.common.services.jsp.include.model.mergedmodel.update.timeout", 60000);
    public static final Object UPDATE_JOB_FAMILY = new Object();

    public static MergedModelManager getInstance() {
        return INSTANCE;
    }

    private MergedModelManager() {
        this._cacheSize = Integer.getInteger(KEY_MERGED_MODEL_CACHE_SIZE, 5);
        this._reserveCache = new LRUCache(this._cacheSize);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            workspace.addResourceChangeListener((IResourceChangeListener)this._resourceListener, 7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMergedModel getMergedModel(IFile sourceFile) {
        if (sourceFile == null || !sourceFile.isAccessible()) {
            IllegalArgumentException iae = new IllegalArgumentException("Program Error: cannot create a merged model without a valid file");
            LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (Throwable)iae);
            return null;
        }
        String id = MergedModel.calculateId(sourceFile);
        if (id == null) {
            return null;
        }
        Map<String, SharedModel> modelsMap = null;
        IProject project = sourceFile.getProject();
        Map<IProject, Map<String, SharedModel>> map = this._mergedModelCache;
        synchronized (map) {
            modelsMap = this._mergedModelCache.get(project);
            if (modelsMap == null) {
                modelsMap = new HashMap<String, SharedModel>();
                this._mergedModelCache.put(project, modelsMap);
            }
        }
        SharedModel shared = null;
        Map<String, SharedModel> map2 = modelsMap;
        synchronized (map2) {
            shared = modelsMap.get(id);
            if (shared == null) {
                IMergedModel mergedModel = null;
                Map<String, IMergedModel> map3 = this._reserveCache;
                synchronized (map3) {
                    mergedModel = this._reserveCache.remove(id);
                }
                if (mergedModel == null) {
                    mergedModel = new MergedModel(sourceFile);
                } else if (TraceOptions.MERGED_MODEL_REF_COUNTS || TraceOptions.MERGED_MODEL_PERF) {
                    TraceOptions.log("Merged model (" + id + ") retrieved from LRU cache");
                }
                shared = new SharedModel((MergedModel)mergedModel);
                modelsMap.put(id, shared);
            }
        }
        ++shared.referenceCount;
        if (TraceOptions.MERGED_MODEL_REF_COUNTS) {
            TraceOptions.log("Merged model (" + id + ") ref count, " + shared.referenceCount);
        }
        return shared.mergedModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(IMergedModel mergedModel) {
        if (mergedModel == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Program Error: cannot release a null merged model");
            LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (Throwable)iae);
            return;
        }
        Map<String, SharedModel> modelsMap = null;
        IProject project = mergedModel.getSourceFile().getProject();
        Map<IProject, Map<String, SharedModel>> map = this._mergedModelCache;
        synchronized (map) {
            modelsMap = this._mergedModelCache.get(project);
        }
        boolean moveModelToReserveCache = false;
        String id = mergedModel.getId();
        if (modelsMap == null) {
            if (!((MergedModel)mergedModel).isDisposed()) {
                ((MergedModel)mergedModel).dispose();
            }
            return;
        }
        Map<String, SharedModel> map2 = modelsMap;
        synchronized (map2) {
            SharedModel shared = modelsMap.get(id);
            if (shared != null) {
                if (shared.referenceCount <= 1) {
                    modelsMap.remove(id);
                    if (mergedModel != shared.mergedModel) {
                        IllegalStateException iae = new IllegalStateException("Program Error: inconsistent merged model for release");
                        LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (Throwable)iae);
                    }
                    moveModelToReserveCache = true;
                    if (TraceOptions.MERGED_MODEL_REF_COUNTS) {
                        TraceOptions.log("Merged model (" + id + ") ref count, 0");
                    }
                } else {
                    --shared.referenceCount;
                    if (TraceOptions.MERGED_MODEL_REF_COUNTS) {
                        TraceOptions.log("Merged model (" + id + ") ref count, " + shared.referenceCount);
                    }
                }
            } else if (!((MergedModel)mergedModel).isDisposed()) {
                try {
                    ((MergedModel)mergedModel).dispose();
                }
                finally {
                    IllegalStateException iae = new IllegalStateException("Program Error: inconsistent merged model for release");
                    LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (Throwable)iae);
                }
            }
        }
        if (moveModelToReserveCache) {
            this.cacheMergedModelInReserve(id, mergedModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheMergedModelInReserve(String id, IMergedModel mergedModel) {
        IMergedModel modelToDispose = null;
        IFile sourceFile = mergedModel.getSourceFile();
        if (sourceFile == null || !sourceFile.isAccessible()) {
            modelToDispose = mergedModel;
            if (TraceOptions.MERGED_MODEL_REF_COUNTS) {
                TraceOptions.log("Merged model (" + modelToDispose.getId() + ") source no longer accessible");
            }
        } else {
            Map<String, IMergedModel> map = this._reserveCache;
            synchronized (map) {
                if (this._reserveCache.get(id) == null) {
                    Iterator<String> iter;
                    if (this._reserveCache.size() >= this._cacheSize && (iter = this._reserveCache.keySet().iterator()).hasNext()) {
                        modelToDispose = this._reserveCache.remove(iter.next());
                        if (TraceOptions.MERGED_MODEL_REF_COUNTS) {
                            TraceOptions.log("Merged model (" + modelToDispose.getId() + ") drop from LRU cache and dispose");
                        }
                    }
                    if (TraceOptions.MERGED_MODEL_REF_COUNTS) {
                        TraceOptions.log("Merged model (" + id + ") moving to LRU cache");
                    }
                    this._reserveCache.put(id, mergedModel);
                }
            }
        }
        if (modelToDispose != null) {
            ((MergedModel)modelToDispose).dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForModelUpdatesForProject(IProject project, int timeout) throws InterruptedException {
        UpdateJobManager updateJobManager = null;
        Map<IProject, UpdateJobManager> map = this._updateJobMgrs;
        synchronized (map) {
            updateJobManager = this._updateJobMgrs.get(project);
        }
        if (updateJobManager != null) {
            return updateJobManager.waitForEvents(timeout);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateJobManager getUpdatemanager(IProject project) {
        Map<IProject, UpdateJobManager> map = this._updateJobMgrs;
        synchronized (map) {
            UpdateJobManager updateJobManager = this._updateJobMgrs.get(project);
            if (updateJobManager == null) {
                updateJobManager = new UpdateJobManager(project);
                this._updateJobMgrs.put(project, updateJobManager);
            }
            return updateJobManager;
        }
    }

    void modelChanging(MergedModel model) {
        IProject project;
        IFile sourceFile = model.getSourceFile();
        if (sourceFile != null && (project = sourceFile.getProject()) != null) {
            this.getUpdatemanager(project).modelChanging(model);
        }
    }

    void modelChangeComplete(MergedModel model) {
        IProject project;
        IFile sourceFile = model.getSourceFile();
        if (sourceFile != null && (project = sourceFile.getProject()) != null) {
            this.getUpdatemanager(project).modelChangeComplete(model);
        }
    }

    private class MergedModelResourceListener
    implements IResourceChangeListener {
        MergedModelResourceListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceChanged(IResourceChangeEvent event) {
            try {
                switch (event.getType()) {
                    case 2: 
                    case 4: {
                        IProject project = (IProject)event.getResource();
                        if (project == null) break;
                        Map map = MergedModelManager.this._mergedModelCache;
                        synchronized (map) {
                            MergedModelManager.this._mergedModelCache.remove(project);
                        }
                        this.removeReserveModelsForProject(project);
                        InclusionCacheManager.getInstance().releaseModelsForProject(project);
                        break;
                    }
                    case 1: {
                        final HashMap<IProject, Set<IFile>> changedFilesMap = new HashMap<IProject, Set<IFile>>();
                        event.getDelta().accept((IResourceDeltaVisitor)new ResourceDeltaVisitor(changedFilesMap));
                        Job schedulerJob = new Job(""){

                            protected IStatus run(IProgressMonitor monitor) {
                                MergedModelResourceListener.this.scheduleModelUpdates(changedFilesMap);
                                return Status.OK_STATUS;
                            }
                        };
                        schedulerJob.schedule();
                        break;
                    }
                }
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.webtier.common.services", (CoreException)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeReserveModelsForProject(IProject project) {
            ArrayList<MergedModel> modelsToDispose = new ArrayList<MergedModel>();
            Map map = MergedModelManager.this._reserveCache;
            synchronized (map) {
                for (IMergedModel mergedModel : MergedModelManager.this._reserveCache.values()) {
                    IProject modelProject = mergedModel.getSourceFile().getProject();
                    if (!project.equals((Object)modelProject)) continue;
                    modelsToDispose.add((MergedModel)mergedModel);
                }
            }
            for (MergedModel mergedModel : modelsToDispose) {
                if (TraceOptions.MERGED_MODEL_REF_COUNTS) {
                    TraceOptions.log("Merged model (" + mergedModel.getId() + ") drop closing resource from LRU cache and dispose");
                }
                Map map2 = MergedModelManager.this._reserveCache;
                synchronized (map2) {
                    MergedModelManager.this._reserveCache.remove(mergedModel.getId());
                }
                mergedModel.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleModelUpdates(HashMap<IProject, Set<IFile>> changedFilesMap) {
            if (changedFilesMap.size() > 0) {
                for (Map.Entry<IProject, Set<IFile>> entry : changedFilesMap.entrySet()) {
                    IProject project = entry.getKey();
                    Set<IFile> files = entry.getValue();
                    ArrayList<MergedModel> modelsToUpdate = new ArrayList<MergedModel>();
                    Map modelsMap = null;
                    Map map = MergedModelManager.this._mergedModelCache;
                    synchronized (map) {
                        modelsMap = (Map)MergedModelManager.this._mergedModelCache.get(project);
                    }
                    if (modelsMap != null) {
                        map = modelsMap;
                        synchronized (map) {
                            if (modelsMap.size() > 0) {
                                for (SharedModel sharedModel : modelsMap.values()) {
                                    if (!sharedModel.mergedModel.isDependentOn(files)) continue;
                                    modelsToUpdate.add(sharedModel.mergedModel);
                                }
                            }
                        }
                    }
                    map = MergedModelManager.this._reserveCache;
                    synchronized (map) {
                        for (IMergedModel mergedModel : MergedModelManager.this._reserveCache.values()) {
                            IProject modelProject = mergedModel.getSourceFile().getProject();
                            if (!project.equals((Object)modelProject) || !((MergedModel)mergedModel).isDependentOn(files)) continue;
                            modelsToUpdate.add((MergedModel)mergedModel);
                        }
                    }
                    if (modelsToUpdate.size() <= 0) continue;
                    MergedModelManager.this.getUpdatemanager(project).scheduleUpdateJob(modelsToUpdate);
                }
            }
        }
    }

    public static class ModelProvider
    implements IModelProvider {
        private IMergedModel mergedModel = null;

        public void dispose() {
            if (this.mergedModel != null) {
                this.mergedModel.release();
            }
        }

        public IStructuredModel getModelForRead(IFile file) throws CoreException, IOException {
            this.mergedModel = MergedModelManager.getInstance().getMergedModel(file);
            if (this.mergedModel != null) {
                GetModelRunnable runnable = new GetModelRunnable();
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)runnable, (ISchedulingRule)file.getProject(), 1, (IProgressMonitor)new NullProgressMonitor());
                return runnable.getModel();
            }
            return null;
        }

        private final class GetModelRunnable
        implements IWorkspaceRunnable {
            private IStructuredModel mergedModelForRead = null;

            private GetModelRunnable() {
            }

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    this.mergedModelForRead = ModelProvider.this.mergedModel.getModelForRead();
                }
                catch (MergedModelException mme) {
                    throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.webtier.common.services", 4, mme.getMessage(), (Throwable)mme));
                }
            }

            private IStructuredModel getModel() {
                return this.mergedModelForRead;
            }
        }
    }

    private static class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        final HashMap<IProject, Set<IFile>> _changedFilesMap;

        ResourceDeltaVisitor(HashMap<IProject, Set<IFile>> map) {
            this._changedFilesMap = map;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    switch (delta.getKind()) {
                        case 4: {
                            int flags = delta.getFlags();
                            if (flags != 131072 && flags != 0 && flags != 524288) {
                                IProject project = resource.getProject();
                                Set<IFile> files = this._changedFilesMap.get(project);
                                if (files == null) {
                                    files = new HashSet<IFile>();
                                    this._changedFilesMap.put(project, files);
                                }
                                files.add((IFile)resource);
                            }
                            return false;
                        }
                    }
                    return false;
                }
            }
            return false;
        }
    }

    private static class SharedModel {
        int referenceCount;
        MergedModel mergedModel;

        SharedModel(MergedModel mm) {
            this.mergedModel = mm;
            this.referenceCount = 0;
        }
    }

    private static class UpdateEventManager {
        private final CopyOnWriteArrayList<IUpdateEvent> _waitingEvents = new CopyOnWriteArrayList();

        private UpdateEventManager() {
        }

        synchronized void addEvent(IUpdateEvent updateEvent) {
            this._waitingEvents.add(updateEvent);
        }

        synchronized void signalUpdate(int timeStamp) {
            ArrayList<IUpdateEvent> satisfied = new ArrayList<IUpdateEvent>();
            for (IUpdateEvent event : this._waitingEvents) {
                if (!event.isSatisfied(timeStamp)) continue;
                satisfied.add(event);
            }
            for (IUpdateEvent satisfiedEvent : satisfied) {
                this._waitingEvents.remove(satisfiedEvent);
                satisfiedEvent.signal();
            }
        }

        synchronized List<IUpdateEvent> getCurrentEvents(int timeStamp) {
            ArrayList<IUpdateEvent> events = new ArrayList<IUpdateEvent>();
            for (IUpdateEvent event : this._waitingEvents) {
                if (event.getTimeStamp() > timeStamp) continue;
                events.add(event);
            }
            return events;
        }
    }

    private static class UpdateJobManager {
        private final IProject _project;
        private final UpdateEventManager _eventManager = new UpdateEventManager();
        private final AtomicInteger _currentTimeStamp = new AtomicInteger(0);
        private final ConcurrentHashMap<String, IUpdateEvent> _modelEventMap = new ConcurrentHashMap();

        UpdateJobManager(IProject project) {
            this._project = project;
        }

        void scheduleUpdateJob(List<MergedModel> modelsToUpdate) {
            UpdateEvent updateEvent = new UpdateEvent(this._project, this._currentTimeStamp.incrementAndGet());
            this._eventManager.addEvent(updateEvent);
            UpdateMergedModelsJob job = new UpdateMergedModelsJob(modelsToUpdate, updateEvent, this._eventManager, "");
            job.schedule();
        }

        void modelChanging(MergedModel model) {
            UpdateEvent updateEvent = new UpdateEvent(this._project, this._currentTimeStamp.incrementAndGet());
            this._eventManager.addEvent(updateEvent);
            this._modelEventMap.put(model.getId(), updateEvent);
        }

        void modelChangeComplete(MergedModel model) {
            IUpdateEvent event = this._modelEventMap.remove(model.getId());
            if (event != null) {
                this._eventManager.signalUpdate(event.getTimeStamp());
            }
        }

        boolean waitForEvents(int timeout) throws InterruptedException {
            List<IUpdateEvent> events = this._eventManager.getCurrentEvents(this._currentTimeStamp.get());
            int remainingTime = timeout;
            long startTime = System.currentTimeMillis();
            int i = events.size();
            while (i >= 1) {
                IUpdateEvent event = events.get(i - 1);
                event.waitForSignal(remainingTime);
                remainingTime = timeout - (int)(System.currentTimeMillis() - startTime);
                if (remainingTime <= 0) {
                    return false;
                }
                --i;
            }
            return true;
        }
    }

    private static class UpdateMergedModelsJob
    extends WorkspaceJob {
        private final List<MergedModel> _modelsToUpdate;
        private final IUpdateEvent _updateEvent;
        private final UpdateEventManager _updateEventMgr;
        IJobChangeListener jobListener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                UpdateMergedModelsJob.this._updateEventMgr.signalUpdate(UpdateMergedModelsJob.this._updateEvent.getTimeStamp());
            }
        };

        UpdateMergedModelsJob(List<MergedModel> modelsToUpdate, IUpdateEvent updateEvent, UpdateEventManager updateEventMgr, String name) {
            super(name);
            this._modelsToUpdate = modelsToUpdate;
            this._updateEvent = updateEvent;
            this._updateEventMgr = updateEventMgr;
            this.setRule((ISchedulingRule)this._updateEvent.getProject());
            this.setSystem(true);
            this.setPriority(20);
            this.addJobChangeListener(this.jobListener);
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            for (MergedModel model : this._modelsToUpdate) {
                model.doUpdate(monitor);
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == UPDATE_JOB_FAMILY;
        }
    }
}

