/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.common.services.jsp.include;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.eclipse.tools.common.util.LRUCache;
import oracle.eclipse.tools.webtier.common.services.TraceOptions;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class InclusionCacheManager {
    private static final InclusionCacheManager INSTANCE = new InclusionCacheManager();
    private static final int DEFAULT_CACHE_SIZE = 10;
    private static final String KEY_MODEL_CACHE_SIZE = "oracle.eclipse.tools.webtier.common.services.jsp.include.inclusion.lrucache.size";
    private final Map<IFile, IDOMModel> _modelCache;
    private final int _cacheSize = Integer.getInteger("oracle.eclipse.tools.webtier.common.services.jsp.include.inclusion.lrucache.size", 10);

    private InclusionCacheManager() {
        this._modelCache = new LRUCache(this._cacheSize);
    }

    public static InclusionCacheManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDOMModel getModel(IFile file) throws IOException, CoreException {
        IStructuredModel structuredModel;
        IDOMModel model = null;
        if (file == null || !file.isAccessible()) {
            return null;
        }
        IModelManager manager = StructuredModelManager.getModelManager();
        if (manager == null) {
            return null;
        }
        Map<IFile, IDOMModel> map = this._modelCache;
        synchronized (map) {
            model = this._modelCache.get(file);
        }
        if (model == null) {
            long startTime = 0L;
            if (TraceOptions.MERGED_MODEL_PERF) {
                startTime = System.nanoTime();
            }
            IStructuredModel structuredModel2 = null;
            try {
                structuredModel2 = manager.getModelForRead(file);
            }
            catch (ResourceException re) {
                IStatus status = re.getStatus();
                if (status == null || status.getCode() != 274) {
                    throw re;
                }
                file.refreshLocal(0, null);
                structuredModel2 = manager.getModelForRead(file);
            }
            if (TraceOptions.MERGED_MODEL_PERF) {
                TraceOptions.log("InclusionCacheManager (" + file.getFullPath().toString() + ") get structured model for included page time ns, " + (System.nanoTime() - startTime));
            }
            if (structuredModel2 instanceof IDOMModel) {
                model = (IDOMModel)structuredModel2;
            }
            if (model != null && !this.cacheIDOMModel(file, model)) {
                return model;
            }
        } else if (TraceOptions.MERGED_MODEL_PERF) {
            TraceOptions.log("InclusionCacheManager (" + file.getFullPath().toString() + ") get structured model from LRU cache");
        }
        if (model != null && (structuredModel = manager.getExistingModelForRead(file)) instanceof IDOMModel) {
            model = (IDOMModel)structuredModel;
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cacheIDOMModel(IFile file, IDOMModel model) {
        boolean modelWasCached = false;
        IDOMModel lruModel = null;
        Map<IFile, IDOMModel> map = this._modelCache;
        synchronized (map) {
            if (this._modelCache.get(file) == null) {
                Iterator<IFile> iter;
                if (this._modelCache.size() >= this._cacheSize && (iter = this._modelCache.keySet().iterator()).hasNext()) {
                    lruModel = this._modelCache.remove(iter.next());
                }
                this._modelCache.put(file, model);
                modelWasCached = true;
            }
        }
        if (lruModel != null) {
            lruModel.releaseFromRead();
        }
        return modelWasCached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseModelsForProject(IProject project) {
        if (project == null) {
            return;
        }
        ArrayList<IFile> modelsToRelease = new ArrayList<IFile>();
        Map<IFile, IDOMModel> map = this._modelCache;
        synchronized (map) {
            for (IFile file : this._modelCache.keySet()) {
                IProject modelProject = file.getProject();
                if (!project.equals((Object)modelProject)) continue;
                modelsToRelease.add(file);
            }
        }
        for (IFile file : modelsToRelease) {
            IDOMModel model = null;
            Map<IFile, IDOMModel> map2 = this._modelCache;
            synchronized (map2) {
                model = this._modelCache.remove(file);
            }
            if (model == null) continue;
            model.releaseFromRead();
        }
    }
}

